/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.VerticalClassMergerGraphLense;
import com.android.tools.r8.utils.FieldSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class VerticalClassMerger {
    private final DexApplication application;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense graphLense;
    private final Timing timing;
    private Collection<DexMethod> invokes;
    private final Map<DexType, DexType> mergedClasses = new HashMap<DexType, DexType>();
    private final Map<DexType, Set<DexType>> mergedClassesInverse = new HashMap<DexType, Set<DexType>>();
    private final VerticalClassMergerGraphLense.Builder renamedMembersLense;

    public VerticalClassMerger(DexApplication application, Enqueuer.AppInfoWithLiveness appInfo, GraphLense graphLense, Timing timing) {
        this.application = application;
        this.appInfo = appInfo;
        this.graphLense = graphLense;
        this.renamedMembersLense = VerticalClassMergerGraphLense.builder(appInfo);
        this.timing = timing;
    }

    private Set<DexType> getPinnedTypes(Iterable<DexProgramClass> classes) {
        HashSet<DexType> pinnedTypes = new HashSet<DexType>();
        this.extractPinnedItems(this.appInfo.pinnedItems, pinnedTypes, AbortReason.PINNED_SOURCE);
        this.extractPinnedItems(this.appInfo.alwaysInline, pinnedTypes, AbortReason.ALWAYS_INLINE);
        this.extractPinnedItems(this.appInfo.noSideEffects.keySet(), pinnedTypes, AbortReason.NO_SIDE_EFFECTS);
        for (DexMethod signature : this.appInfo.brokenSuperInvokes) {
            DexClass targetClass = this.appInfo.definitionFor(signature.holder);
            if (targetClass == null || !targetClass.isProgramClass()) continue;
            pinnedTypes.add(signature.holder);
        }
        return pinnedTypes;
    }

    private void extractPinnedItems(Iterable<DexItem> items, Set<DexType> pinnedTypes, AbortReason reason) {
        for (DexItem item : items) {
            if (item instanceof DexType || item instanceof DexClass) {
                DexType type = item instanceof DexType ? (DexType)item : ((DexClass)item).type;
                if (this.appInfo.isPinned(type)) continue;
                this.markTypeAsPinned(type, pinnedTypes, reason);
                continue;
            }
            if (item instanceof DexField || item instanceof DexEncodedField) {
                DexField field = item instanceof DexField ? (DexField)item : ((DexEncodedField)item).field;
                this.markTypeAsPinned(field.clazz, pinnedTypes, reason);
                this.markTypeAsPinned(field.type, pinnedTypes, reason);
                continue;
            }
            if (!(item instanceof DexMethod) && !(item instanceof DexEncodedMethod)) continue;
            DexMethod method = item instanceof DexMethod ? (DexMethod)item : ((DexEncodedMethod)item).method;
            this.markTypeAsPinned(method.holder, pinnedTypes, reason);
            this.markTypeAsPinned(method.proto.returnType, pinnedTypes, reason);
            for (DexType parameterType : method.proto.parameters.values) {
                this.markTypeAsPinned(parameterType, pinnedTypes, reason);
            }
        }
    }

    private void markTypeAsPinned(DexType type, Set<DexType> pinnedTypes, AbortReason reason) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz != null && clazz.isProgramClass()) {
            boolean bl = pinnedTypes.add(type);
        }
    }

    private boolean isMergeCandidate(DexProgramClass clazz, Set<DexType> pinnedTypes) {
        if (this.appInfo.instantiatedTypes.contains(clazz.type) || this.appInfo.instantiatedLambdas.contains(clazz.type) || this.appInfo.isPinned(clazz.type) || pinnedTypes.contains(clazz.type)) {
            return false;
        }
        if (this.mergedClassesInverse.containsKey(clazz.type)) {
            return false;
        }
        DexType singleSubtype = clazz.type.getSingleSubtype();
        if (singleSubtype == null) {
            return false;
        }
        for (DexEncodedField field : clazz.fields()) {
            if (!this.appInfo.isPinned(field.field)) continue;
            return false;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (this.appInfo.isPinned(method.method)) {
                return false;
            }
            if (!method.isInstanceInitializer() || !VerticalClassMerger.disallowInlining(method)) continue;
            return false;
        }
        DexClass targetClass = this.appInfo.definitionFor(singleSubtype);
        return !this.mergeMayLeadToIllegalAccesses(clazz, targetClass);
    }

    private boolean mergeMayLeadToIllegalAccesses(DexClass source, DexClass target) {
        if (source.type.isSamePackage(target.type)) {
            int accessLevel;
            int n = source.accessFlags.isPrivate() ? 0 : (accessLevel = source.accessFlags.isPublic() ? 2 : 1);
            int otherAccessLevel = target.accessFlags.isPrivate() ? 0 : (target.accessFlags.isPublic() ? 2 : 1);
            return accessLevel > otherAccessLevel;
        }
        if (!target.accessFlags.isPublic()) {
            return true;
        }
        for (DexEncodedField field : source.fields()) {
            if (field.accessFlags.isPublic() || field.accessFlags.isPrivate()) continue;
            return true;
        }
        for (DexEncodedMethod method : source.methods()) {
            if (method.accessFlags.isPublic() || method.accessFlags.isPrivate()) continue;
            return true;
        }
        IllegalAccessDetector registry = new IllegalAccessDetector(source);
        for (DexEncodedMethod method : source.methods()) {
            method.registerCodeReferences(registry);
            if (!registry.foundIllegalAccess()) continue;
            return true;
        }
        return false;
    }

    private void addProgramMethods(Set<Equivalence.Wrapper<DexMethod>> set, DexMethod method, Equivalence<DexMethod> equivalence) {
        DexClass definition = this.appInfo.definitionFor(method.holder);
        if (definition != null && definition.isProgramClass()) {
            set.add(equivalence.wrap(method));
        }
    }

    private Collection<DexMethod> getInvokes() {
        if (this.invokes == null) {
            HashSet filteredInvokes = new HashSet();
            MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
            this.appInfo.targetedMethods.forEach(m -> this.addProgramMethods(filteredInvokes, (DexMethod)m, equivalence));
            this.invokes = filteredInvokes.stream().map(Equivalence.Wrapper::get).filter(this::removeNonProgram).collect(Collectors.toList());
        }
        return this.invokes;
    }

    private boolean isProgramClass(DexType type) {
        DexClass clazz;
        if (type.isArrayType()) {
            type = type.toBaseType(this.appInfo.dexItemFactory);
        }
        return type.isClassType() && (clazz = this.appInfo.definitionFor(type)) != null && clazz.isProgramClass();
    }

    private boolean removeNonProgram(DexMethod dexMethod) {
        for (DexType type : dexMethod.proto.parameters.values) {
            if (!this.isProgramClass(type)) continue;
            return true;
        }
        return this.isProgramClass(dexMethod.proto.returnType);
    }

    public GraphLense run() {
        this.timing.begin("merge");
        GraphLense mergingGraphLense = this.mergeClasses(this.graphLense);
        this.timing.end();
        this.timing.begin("fixup");
        GraphLense result = new TreeFixer().fixupTypeReferences(mergingGraphLense);
        this.timing.end();
        assert (result.assertNotModified(this.appInfo.alwaysInline));
        assert (result.assertNotModified(this.appInfo.noSideEffects.keySet()));
        return result;
    }

    private void addAncestorsToWorklist(DexProgramClass clazz, Deque<DexProgramClass> worklist, Set<DexProgramClass> seenBefore) {
        DexClass definition;
        if (seenBefore.contains(clazz)) {
            return;
        }
        worklist.addFirst(clazz);
        if (clazz.superType != null && (definition = this.appInfo.definitionFor(clazz.superType)) != null && definition.isProgramClass()) {
            this.addAncestorsToWorklist(definition.asProgramClass(), worklist, seenBefore);
        }
        for (DexType interfaceType : clazz.interfaces.values) {
            DexClass definition2 = this.appInfo.definitionFor(interfaceType);
            if (definition2 == null || !definition2.isProgramClass()) continue;
            this.addAncestorsToWorklist(definition2.asProgramClass(), worklist, seenBefore);
        }
    }

    private GraphLense mergeClasses(GraphLense graphLense) {
        Iterable<DexProgramClass> classes = this.application.classesWithDeterministicOrder();
        ArrayDeque<DexProgramClass> worklist = new ArrayDeque<DexProgramClass>();
        HashSet<DexProgramClass> seenBefore = new HashSet<DexProgramClass>();
        boolean numberOfMerges = false;
        Set<DexType> pinnedTypes = this.getPinnedTypes(classes);
        Iterator<DexProgramClass> classIterator = classes.iterator();
        while (classIterator.hasNext() || !worklist.isEmpty()) {
            ClassMerger merger;
            boolean merged;
            DexProgramClass clazz;
            if (worklist.isEmpty()) {
                this.addAncestorsToWorklist(classIterator.next(), worklist, seenBefore);
                if (worklist.isEmpty()) continue;
            }
            if (!seenBefore.add(clazz = (DexProgramClass)worklist.removeFirst()) || !this.isMergeCandidate(clazz, pinnedTypes)) continue;
            DexClass targetClass = this.appInfo.definitionFor(clazz.type.getSingleSubtype());
            assert (!this.mergedClasses.containsKey(targetClass.type));
            if (clazz.hasClassInitializer() && targetClass.hasClassInitializer() || this.methodResolutionMayChange(clazz, targetClass) || this.fieldResolutionMayChange(clazz, targetClass) || new CollisionDetector(clazz.type, targetClass.type, this.getInvokes(), this.mergedClasses).mayCollide() || !(merged = (merger = new ClassMerger(clazz, targetClass)).merge())) continue;
            this.renamedMembersLense.merge(merger.getRenamings());
        }
        return this.renamedMembersLense.build(graphLense, this.mergedClasses, this.application.dexItemFactory);
    }

    private boolean methodResolutionMayChange(DexClass source, DexClass target) {
        if (source.isInterface() && !target.isInterface()) {
            ArrayList<DexEncodedMethod> defaultMethods = new ArrayList<DexEncodedMethod>();
            for (DexEncodedMethod virtualMethod : source.virtualMethods()) {
                if (virtualMethod.accessFlags.isAbstract()) continue;
                defaultMethods.add(virtualMethod);
            }
            for (DexEncodedMethod method : defaultMethods) {
                Set<DexEncodedMethod> interfaceTargets = this.appInfo.lookupInterfaceTargets(method.method);
                if (!interfaceTargets.remove(method)) continue;
                for (DexEncodedMethod interfaceTarget : interfaceTargets) {
                    DexClass enclosingClass = this.appInfo.definitionFor(interfaceTarget.method.holder);
                    if (enclosingClass == null || !enclosingClass.isInterface()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean fieldResolutionMayChange(DexClass source, DexClass target) {
        if (source.type == target.superType) {
            FieldSignatureEquivalence equivalence = FieldSignatureEquivalence.get();
            HashSet<Equivalence.Wrapper<DexField>> staticFieldsInInterfacesOfTarget = new HashSet<Equivalence.Wrapper<DexField>>();
            for (DexType dexType : target.interfaces.values) {
                DexClass clazz = this.appInfo.definitionFor(dexType);
                for (DexEncodedField staticField : clazz.staticFields()) {
                    staticFieldsInInterfacesOfTarget.add(equivalence.wrap(staticField.field));
                }
            }
            for (DexItem dexItem : source.instanceFields()) {
                if (!staticFieldsInInterfacesOfTarget.contains(equivalence.wrap(((DexEncodedField)dexItem).field))) continue;
                return true;
            }
        }
        return false;
    }

    private static void makePrivate(DexEncodedMethod method) {
        assert (!method.accessFlags.isAbstract());
        method.accessFlags.unsetPublic();
        method.accessFlags.unsetProtected();
        method.accessFlags.setPrivate();
    }

    private static boolean disallowInlining(DexEncodedMethod method) {
        MethodInlineDecision registry = new MethodInlineDecision();
        method.getCode().registerCodeReferences(registry);
        return registry.isInliningDisallowed();
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.mergedClasses.keySet());
    }

    private class IllegalAccessDetector
    extends UseRegistry {
        private boolean foundIllegalAccess = false;
        private DexClass source;

        public IllegalAccessDetector(DexClass source) {
            this.source = source;
        }

        public boolean foundIllegalAccess() {
            return this.foundIllegalAccess;
        }

        private boolean checkFieldReference(DexField field) {
            if (!this.foundIllegalAccess && field.clazz.isSamePackage(this.source.type)) {
                this.checkTypeReference(field.clazz);
                this.checkTypeReference(field.type);
                DexEncodedField definition = VerticalClassMerger.this.appInfo.definitionFor(field);
                if (definition == null || !definition.accessFlags.isPublic()) {
                    this.foundIllegalAccess = true;
                }
            }
            return true;
        }

        private boolean checkMethodReference(DexMethod method) {
            if (!this.foundIllegalAccess && method.holder.isSamePackage(this.source.type)) {
                this.checkTypeReference(method.holder);
                this.checkTypeReference(method.proto.returnType);
                for (DexType type : method.proto.parameters.values) {
                    this.checkTypeReference(type);
                }
                DexEncodedMethod definition = VerticalClassMerger.this.appInfo.definitionFor(method);
                if (definition == null || !definition.accessFlags.isPublic()) {
                    this.foundIllegalAccess = true;
                }
            }
            return true;
        }

        private boolean checkTypeReference(DexType type) {
            DexClass clazz;
            if (!this.foundIllegalAccess && type.isClassType() && type.isSamePackage(this.source.type) && ((clazz = VerticalClassMerger.this.appInfo.definitionFor(type)) == null || !clazz.accessFlags.isPublic())) {
                this.foundIllegalAccess = true;
            }
            return true;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.checkTypeReference(type);
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return this.checkTypeReference(type);
        }
    }

    private static class MethodInlineDecision
    extends UseRegistry {
        private boolean disallowInlining = false;

        private MethodInlineDecision() {
        }

        public boolean isInliningDisallowed() {
            return this.disallowInlining;
        }

        private boolean allowInlining() {
            return true;
        }

        private boolean disallowInlining() {
            this.disallowInlining = true;
            return true;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.disallowInlining();
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.disallowInlining();
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.allowInlining();
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.allowInlining();
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.allowInlining();
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.allowInlining();
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.allowInlining();
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.allowInlining();
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.allowInlining();
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.allowInlining();
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return this.allowInlining();
        }
    }

    private class CollisionDetector {
        private static final int NOT_FOUND = Integer.MIN_VALUE;
        private final Map<DexString, Int2IntMap> seenPositions = new IdentityHashMap<DexString, Int2IntMap>();
        private final Reference2IntMap<DexProto> targetProtoCache;
        private final Reference2IntMap<DexProto> sourceProtoCache;
        private final DexType source;
        private final DexType target;
        private final Collection<DexMethod> invokes;
        private final Map<DexType, DexType> substituions;

        private CollisionDetector(DexType source, DexType target, Collection<DexMethod> invokes, Map<DexType, DexType> substitutions) {
            this.source = source;
            this.target = target;
            this.invokes = invokes;
            this.substituions = substitutions;
            this.targetProtoCache = new Reference2IntOpenHashMap<DexProto>(invokes.size() / 2);
            this.targetProtoCache.defaultReturnValue(Integer.MIN_VALUE);
            this.sourceProtoCache = new Reference2IntOpenHashMap<DexProto>(invokes.size() / 2);
            this.sourceProtoCache.defaultReturnValue(Integer.MIN_VALUE);
        }

        boolean mayCollide() {
            VerticalClassMerger.this.timing.begin("collision detection");
            this.fillSeenPositions(this.invokes);
            boolean result = false;
            if (!this.seenPositions.isEmpty()) {
                for (DexMethod method : this.invokes) {
                    int arity;
                    int previous;
                    Int2IntMap positionsMap = this.seenPositions.get(method.name);
                    if (positionsMap == null || (previous = positionsMap.get(arity = method.getArity())) == Integer.MIN_VALUE) continue;
                    assert (previous != 0);
                    int positions = this.computePositionsFor(method.proto, this.source, this.sourceProtoCache, this.substituions);
                    if ((positions & previous) == 0) continue;
                    result = true;
                    break;
                }
            }
            VerticalClassMerger.this.timing.end();
            return result;
        }

        private void fillSeenPositions(Collection<DexMethod> invokes) {
            for (DexMethod method : invokes) {
                DexType[] parameters = method.proto.parameters.values;
                int arity = parameters.length;
                int positions = this.computePositionsFor(method.proto, this.target, this.targetProtoCache, this.substituions);
                if (positions == 0) continue;
                Int2IntMap positionsMap = this.seenPositions.computeIfAbsent(method.name, k -> {
                    Int2IntOpenHashMap result = new Int2IntOpenHashMap();
                    result.defaultReturnValue(Integer.MIN_VALUE);
                    return result;
                });
                int value = 0;
                int previous = positionsMap.get(arity);
                if (previous != Integer.MIN_VALUE) {
                    value = previous;
                }
                positionsMap.put(arity, value |= positions);
            }
        }

        private int computePositionsFor(DexProto proto, DexType type, Reference2IntMap<DexProto> cache, Map<DexType, DexType> substitutions) {
            int result = cache.getInt(proto);
            if (result != Integer.MIN_VALUE) {
                return result;
            }
            result = 0;
            int bitsUsed = 0;
            int accumulator = 0;
            for (DexType aType : proto.parameters.values) {
                if (substitutions != null) {
                    while (substitutions.containsKey(aType)) {
                        aType = substitutions.get(aType);
                    }
                }
                accumulator <<= 1;
                ++bitsUsed;
                if (aType == type) {
                    accumulator |= 1;
                }
                if (bitsUsed != 31) continue;
                result |= accumulator;
                accumulator = 0;
                bitsUsed = 0;
            }
            DexType returnType = proto.returnType;
            if (substitutions != null) {
                while (substitutions.containsKey(returnType)) {
                    returnType = substitutions.get(returnType);
                }
            }
            accumulator <<= 1;
            if (returnType == type) {
                accumulator |= 1;
            }
            cache.put(proto, result |= accumulator);
            return result;
        }
    }

    private class TreeFixer {
        private final GraphLense.Builder lense = GraphLense.builder();
        Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        private TreeFixer() {
        }

        private GraphLense fixupTypeReferences(GraphLense graphLense) {
            for (DexProgramClass clazz : VerticalClassMerger.this.appInfo.classes()) {
                clazz.setDirectMethods(this.substituteTypesIn(clazz.directMethods()));
                clazz.setVirtualMethods(this.substituteTypesIn(clazz.virtualMethods()));
                clazz.setVirtualMethods(this.removeDupes(clazz.virtualMethods()));
                clazz.setStaticFields(this.substituteTypesIn(clazz.staticFields()));
                clazz.setInstanceFields(this.substituteTypesIn(clazz.instanceFields()));
            }
            for (DexType type : VerticalClassMerger.this.mergedClasses.keySet()) {
                DexType fixed = this.fixupType(type);
                this.lense.map(type, fixed);
            }
            return this.lense.build(((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory, graphLense);
        }

        private DexEncodedMethod[] removeDupes(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            IdentityHashMap<DexMethod, DexEncodedMethod> filtered = new IdentityHashMap<DexMethod, DexEncodedMethod>();
            for (DexEncodedMethod method : methods) {
                DexEncodedMethod previous = filtered.put(method.method, method);
                if (previous == null || previous.accessFlags.isBridge()) continue;
                if (!method.accessFlags.isBridge()) {
                    throw new CompilationError("Class merging produced invalid result on: " + previous.toSourceString());
                }
                filtered.put(previous.method, previous);
            }
            if (filtered.size() == methods.length) {
                return methods;
            }
            return filtered.values().toArray(new DexEncodedMethod[filtered.size()]);
        }

        private DexEncodedMethod[] substituteTypesIn(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            for (int i = 0; i < methods.length; ++i) {
                DexEncodedMethod encodedMethod = methods[i];
                DexMethod method = encodedMethod.method;
                DexProto newProto = this.getUpdatedProto(method.proto);
                DexType newHolder = this.fixupType(method.holder);
                DexMethod newMethod = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(newHolder, newProto, method.name);
                if (newMethod == encodedMethod.method) continue;
                this.lense.map(encodedMethod.method, newMethod);
                methods[i] = encodedMethod.toTypeSubstitutedMethod(newMethod);
            }
            return methods;
        }

        private DexEncodedField[] substituteTypesIn(DexEncodedField[] fields) {
            if (fields == null) {
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                DexEncodedField encodedField = fields[i];
                DexField field = encodedField.field;
                DexType newType = this.fixupType(field.type);
                DexType newHolder = this.fixupType(field.clazz);
                DexField newField = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(newHolder, newType, field.name);
                if (newField == encodedField.field) continue;
                this.lense.map(encodedField.field, newField);
                fields[i] = encodedField.toTypeSubstitutedField(newField);
            }
            return fields;
        }

        private DexProto getUpdatedProto(DexProto proto) {
            DexProto result = this.protoFixupCache.get(proto);
            if (result == null) {
                DexType returnType = this.fixupType(proto.returnType);
                DexType[] arguments = this.fixupTypes(proto.parameters.values);
                result = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createProto(returnType, arguments);
                this.protoFixupCache.put(proto, result);
            }
            return result;
        }

        private DexType fixupType(DexType type) {
            if (type.isArrayType()) {
                DexType fixed;
                DexType base = type.toBaseType(((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory);
                if (base == (fixed = this.fixupType(base))) {
                    return type;
                }
                return type.replaceBaseType(fixed, ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory);
            }
            while (VerticalClassMerger.this.mergedClasses.containsKey(type)) {
                type = (DexType)VerticalClassMerger.this.mergedClasses.get(type);
            }
            return type;
        }

        private DexType[] fixupTypes(DexType[] types) {
            DexType[] result = new DexType[types.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.fixupType(types[i]);
            }
            return result;
        }
    }

    private class ClassMerger {
        private static final String CONSTRUCTOR_NAME = "constructor";
        private final DexClass source;
        private final DexClass target;
        private final VerticalClassMergerGraphLense.Builder deferredRenamings;
        private boolean abortMerge;

        private ClassMerger(DexClass source, DexClass target) {
            this.deferredRenamings = VerticalClassMergerGraphLense.builder(VerticalClassMerger.this.appInfo);
            this.abortMerge = false;
            this.source = source;
            this.target = target;
        }

        public boolean merge() {
            if (this.source.getEnclosingMethod() != null || !this.source.getInnerClasses().isEmpty() || this.target.getEnclosingMethod() != null || !this.target.getInnerClasses().isEmpty()) {
                return false;
            }
            HashSet existingMethods = new HashSet();
            this.addAll(existingMethods, this.target.methods(), MethodSignatureEquivalence.get());
            HashMap directMethods = new HashMap();
            HashMap virtualMethods = new HashMap();
            Predicate<DexMethod> availableMethodSignatures = method -> {
                Equivalence.Wrapper<DexMethod> wrapped = MethodSignatureEquivalence.get().wrap(method);
                return !existingMethods.contains(wrapped) && !directMethods.containsKey(wrapped) && !virtualMethods.containsKey(wrapped);
            };
            for (DexEncodedMethod directMethod : this.source.directMethods()) {
                if (directMethod.isInstanceInitializer()) {
                    this.add(directMethods, this.renameConstructor(directMethod, availableMethodSignatures), MethodSignatureEquivalence.get());
                    continue;
                }
                DexEncodedMethod resultingDirectMethod = this.renameMethod(directMethod, availableMethodSignatures, directMethod.isClassInitializer() ? Rename.NEVER : Rename.IF_NEEDED);
                this.add(directMethods, resultingDirectMethod, MethodSignatureEquivalence.get());
                this.deferredRenamings.map(directMethod.method, resultingDirectMethod.method);
                if (directMethod.isStaticMethod()) continue;
                this.blockRedirectionOfSuperCalls(resultingDirectMethod.method);
            }
            for (DexEncodedMethod virtualMethod : this.source.virtualMethods()) {
                DexEncodedMethod shadowedBy = this.findMethodInTarget(virtualMethod);
                if (shadowedBy != null) {
                    if (virtualMethod.accessFlags.isAbstract()) {
                        this.deferredRenamings.map(virtualMethod.method, shadowedBy.method);
                        continue;
                    }
                } else {
                    if (this.abortMerge) {
                        return false;
                    }
                    if (virtualMethod.accessFlags.isAbstract()) {
                        DexEncodedMethod resultingVirtualMethod = this.renameMethod(virtualMethod, availableMethodSignatures, Rename.NEVER);
                        this.deferredRenamings.map(virtualMethod.method, resultingVirtualMethod.method);
                        this.add(virtualMethods, resultingVirtualMethod, MethodSignatureEquivalence.get());
                        continue;
                    }
                }
                DexEncodedMethod resultingDirectMethod = this.renameMethod(virtualMethod, availableMethodSignatures, Rename.ALWAYS);
                VerticalClassMerger.makePrivate(resultingDirectMethod);
                this.add(directMethods, resultingDirectMethod, MethodSignatureEquivalence.get());
                this.redirectSuperCallsInTarget(virtualMethod.method, resultingDirectMethod.method);
                this.blockRedirectionOfSuperCalls(resultingDirectMethod.method);
                if (shadowedBy == null) {
                    shadowedBy = this.buildBridgeMethod(virtualMethod, resultingDirectMethod.method);
                    this.add(virtualMethods, shadowedBy, MethodSignatureEquivalence.get());
                }
                this.deferredRenamings.map(virtualMethod.method, shadowedBy.method);
            }
            Collection mergedDirectMethods = this.mergeItems(directMethods.values().iterator(), this.target.directMethods(), MethodSignatureEquivalence.get(), this::resolveMethodConflict);
            Collection mergedVirtualMethods = this.mergeItems(virtualMethods.values().iterator(), this.target.virtualMethods(), MethodSignatureEquivalence.get(), this::resolveMethodConflict);
            if (this.abortMerge) {
                return false;
            }
            Collection mergedStaticFields = this.mergeItems(Iterators.forArray(this.source.staticFields()), this.target.staticFields(), FieldSignatureEquivalence.get(), this::resolveFieldConflict);
            Collection mergedInstanceFields = this.mergeItems(Iterators.forArray(this.source.instanceFields()), this.target.instanceFields(), FieldSignatureEquivalence.get(), this::resolveFieldConflict);
            Set<DexType> interfaces = this.mergeArrays(this.target.interfaces.values, this.source.interfaces.values);
            if (this.source.isInterface()) {
                interfaces.remove(this.source.type);
            } else {
                assert (!this.target.isInterface());
                this.target.superType = this.source.superType;
            }
            this.target.interfaces = interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(new DexType[interfaces.size()]));
            this.target.setDirectMethods(mergedDirectMethods.toArray(new DexEncodedMethod[mergedDirectMethods.size()]));
            this.target.setVirtualMethods(mergedVirtualMethods.toArray(new DexEncodedMethod[mergedVirtualMethods.size()]));
            this.target.setStaticFields(mergedStaticFields.toArray(new DexEncodedField[mergedStaticFields.size()]));
            this.target.setInstanceFields(mergedInstanceFields.toArray(new DexEncodedField[mergedInstanceFields.size()]));
            this.source.superType = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.objectType;
            this.source.setDirectMethods(null);
            this.source.setVirtualMethods(null);
            this.source.setInstanceFields(null);
            this.source.setStaticFields(null);
            this.source.interfaces = DexTypeList.empty();
            VerticalClassMerger.this.mergedClasses.put(this.source.type, this.target.type);
            VerticalClassMerger.this.mergedClassesInverse.computeIfAbsent(this.target.type, key -> new HashSet()).add(this.source.type);
            assert (!this.abortMerge);
            return true;
        }

        public VerticalClassMergerGraphLense.Builder getRenamings() {
            return this.deferredRenamings;
        }

        private void redirectSuperCallsInTarget(DexMethod oldTarget, DexMethod newTarget) {
            DexClass holder = this.target;
            while (holder != null && holder.isProgramClass()) {
                boolean resolutionSucceeds;
                DexMethod signatureInHolder = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(holder.type, oldTarget.proto, oldTarget.name);
                boolean bl = resolutionSucceeds = holder.lookupVirtualMethod(signatureInHolder) != null || VerticalClassMerger.this.appInfo.lookupSuperTarget(signatureInHolder, holder.type) != null;
                if (!resolutionSucceeds) break;
                this.deferredRenamings.mapVirtualMethodToDirectInType(signatureInHolder, newTarget, this.target.type);
                Set mergedTypes = (Set)VerticalClassMerger.this.mergedClassesInverse.get(holder.type);
                if (mergedTypes != null) {
                    for (DexType type : mergedTypes) {
                        DexMethod signatureInType = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(type, oldTarget.proto, oldTarget.name);
                        boolean resolutionSucceededBeforeMerge = VerticalClassMerger.this.renamedMembersLense.hasMappingForSignatureInContext(holder.type, signatureInType) || VerticalClassMerger.this.appInfo.lookupSuperTarget(signatureInHolder, holder.type) != null;
                        if (!resolutionSucceededBeforeMerge) continue;
                        this.deferredRenamings.mapVirtualMethodToDirectInType(signatureInType, newTarget, this.target.type);
                    }
                }
                holder = holder.superType != null ? VerticalClassMerger.this.appInfo.definitionFor(holder.superType) : null;
            }
        }

        private void blockRedirectionOfSuperCalls(DexMethod method) {
            this.deferredRenamings.markMethodAsMerged(method);
        }

        private DexEncodedMethod buildBridgeMethod(DexEncodedMethod signature, DexMethod invocationTarget) {
            DexType holder = this.target.type;
            DexProto proto = invocationTarget.proto;
            DexString name = signature.method.name;
            MethodAccessFlags accessFlags = signature.accessFlags.copy();
            accessFlags.setBridge();
            accessFlags.setSynthetic();
            accessFlags.unsetAbstract();
            return new DexEncodedMethod(((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(holder, proto, name), accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new ForwardMethodSourceCode(holder, proto, holder, invocationTarget, Invoke.Type.DIRECT), registry -> registry.registerInvokeDirect(invocationTarget)), signature.hasClassFileVersion() ? signature.getClassFileVersion() : -1);
        }

        private DexEncodedMethod findMethodInTarget(DexEncodedMethod method) {
            AppInfo.ResolutionResult resolutionResult = VerticalClassMerger.this.appInfo.resolveMethod(this.target.type, method.method);
            if (!resolutionResult.hasSingleTarget()) {
                this.abortMerge = true;
                return null;
            }
            DexEncodedMethod actual = resolutionResult.asSingleTarget();
            if (actual != method) {
                return actual;
            }
            assert (!method.accessFlags.isAbstract() || this.target.accessFlags.isAbstract());
            return null;
        }

        private <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> void add(Map<Equivalence.Wrapper<S>, T> map2, T item, Equivalence<S> equivalence) {
            map2.put(equivalence.wrap(item.getKey()), item);
        }

        private <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> void addAll(Collection<Equivalence.Wrapper<S>> collection, Iterable<T> items, Equivalence<S> equivalence) {
            for (KeyedDexItem item : items) {
                collection.add(equivalence.wrap(item.getKey()));
            }
        }

        private <T> Set<T> mergeArrays(T[] one, T[] other) {
            LinkedHashSet merged = new LinkedHashSet();
            Collections.addAll(merged, one);
            Collections.addAll(merged, other);
            return merged;
        }

        private <T extends PresortedComparable<T>, S extends KeyedDexItem<T>> Collection<S> mergeItems(Iterator<S> fromItems, S[] toItems, Equivalence<T> equivalence, BiFunction<S, Predicate<T>, S> onConflict) {
            HashMap<Equivalence.Wrapper<T>, S> map2 = new HashMap<Equivalence.Wrapper<T>, S>();
            for (S item : toItems) {
                map2.put(equivalence.wrap(((KeyedDexItem)item).getKey()), item);
            }
            this.addNonShadowed(fromItems, map2, equivalence, onConflict);
            return map2.values();
        }

        private <T extends PresortedComparable<T>, S extends KeyedDexItem<T>> void addNonShadowed(Iterator<S> items, Map<Equivalence.Wrapper<T>, S> map2, Equivalence<T> equivalence, BiFunction<S, Predicate<T>, S> onConflict) {
            Predicate<PresortedComparable> availableSignatures = key -> !map2.containsKey(equivalence.wrap(key));
            while (items.hasNext()) {
                KeyedDexItem item = (KeyedDexItem)items.next();
                assert (item != null);
                Equivalence.Wrapper wrapped = equivalence.wrap(item.getKey());
                if (map2.containsKey(wrapped)) {
                    KeyedDexItem resolved = (KeyedDexItem)onConflict.apply(item, availableSignatures);
                    assert (availableSignatures.test((PresortedComparable)resolved.getKey()));
                    wrapped = equivalence.wrap(resolved.getKey());
                    map2.put(wrapped, resolved);
                    assert (!availableSignatures.test((PresortedComparable)resolved.getKey()));
                    continue;
                }
                map2.put(wrapped, item);
            }
        }

        private DexString getFreshName(String nameString, int index, DexType holder) {
            String freshName = nameString + "$" + holder.toSourceString().replace('.', '$');
            if (index > 1) {
                freshName = freshName + index;
            }
            return ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createString(freshName);
        }

        private DexEncodedMethod resolveMethodConflict(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures) {
            assert (false);
            this.abortMerge = true;
            return method;
        }

        private DexEncodedMethod renameConstructor(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures) {
            DexMethod newSignature;
            assert (method.isInstanceInitializer());
            DexType oldHolder = method.method.holder;
            int count = 1;
            do {
                DexString newName = this.getFreshName(CONSTRUCTOR_NAME, count, oldHolder);
                newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, method.method.proto, newName);
                ++count;
            } while (!availableMethodSignatures.test(newSignature));
            DexEncodedMethod result = method.toTypeSubstitutedMethod(newSignature);
            result.markForceInline();
            this.deferredRenamings.map(method.method, result.method);
            result.accessFlags.unsetConstructor();
            VerticalClassMerger.makePrivate(result);
            return result;
        }

        private DexEncodedMethod renameMethod(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures, Rename strategy) {
            DexMethod newSignature;
            assert (!method.accessFlags.isConstructor() || strategy == Rename.NEVER);
            DexString oldName = method.method.name;
            DexType oldHolder = method.method.holder;
            switch (strategy) {
                case IF_NEEDED: {
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, method.method.proto, oldName);
                    if (availableMethodSignatures.test(newSignature)) break;
                }
                case ALWAYS: {
                    int count = 1;
                    do {
                        DexString newName = this.getFreshName(oldName.toSourceString(), count, oldHolder);
                        newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, method.method.proto, newName);
                        ++count;
                    } while (!availableMethodSignatures.test(newSignature));
                    break;
                }
                case NEVER: {
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, method.method.proto, oldName);
                    assert (availableMethodSignatures.test(newSignature));
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            return method.toTypeSubstitutedMethod(newSignature);
        }

        private DexEncodedField resolveFieldConflict(DexEncodedField field, Predicate<DexField> availableFieldSignatures) {
            DexField newSignature;
            DexString oldName = field.field.name;
            DexType oldHolder = field.field.clazz;
            int count = 1;
            do {
                DexString newName = this.getFreshName(oldName.toSourceString(), count, oldHolder);
                newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(this.target.type, field.field.type, newName);
                ++count;
            } while (!availableFieldSignatures.test(newSignature));
            DexEncodedField result = field.toTypeSubstitutedField(newSignature);
            this.deferredRenamings.map(field.field, result.field);
            return result;
        }
    }

    private static enum Rename {
        ALWAYS,
        IF_NEEDED,
        NEVER;

    }

    private static final class AbortReason
    extends Enum<AbortReason> {
        public static final /* enum */ AbortReason ALREADY_MERGED = new AbortReason();
        public static final /* enum */ AbortReason ALWAYS_INLINE = new AbortReason();
        public static final /* enum */ AbortReason CONFLICT = new AbortReason();
        public static final /* enum */ AbortReason ILLEGAL_ACCESS = new AbortReason();
        public static final /* enum */ AbortReason NO_SIDE_EFFECTS = new AbortReason();
        public static final /* enum */ AbortReason PINNED_SOURCE = new AbortReason();
        public static final /* enum */ AbortReason RESOLUTION_FOR_FIELDS_MAY_CHANGE = new AbortReason();
        public static final /* enum */ AbortReason RESOLUTION_FOR_METHODS_MAY_CHANGE = new AbortReason();
        public static final /* enum */ AbortReason STATIC_INITIALIZERS = new AbortReason();
        public static final /* enum */ AbortReason UNSAFE_INLINING = new AbortReason();
        public static final /* enum */ AbortReason UNSUPPORTED_ATTRIBUTES = new AbortReason();
        private static final /* synthetic */ AbortReason[] $VALUES;

        public static AbortReason[] values() {
            return (AbortReason[])$VALUES.clone();
        }

        public static AbortReason valueOf(String name) {
            return Enum.valueOf(AbortReason.class, name);
        }

        public void printLogMessageForClass(DexClass clazz) {
            Log.info(VerticalClassMerger.class, this.getMessageForClass(clazz), new Object[0]);
        }

        private String getMessageForClass(DexClass clazz) {
            String message = null;
            switch (this) {
                case ALREADY_MERGED: {
                    message = "it has already been merged with its superclass";
                    break;
                }
                case ALWAYS_INLINE: {
                    message = "it is mentioned in appInfo.alwaysInline";
                    break;
                }
                case CONFLICT: {
                    message = "it is conflicting with its subclass";
                    break;
                }
                case ILLEGAL_ACCESS: {
                    message = "it could lead to illegal accesses";
                    break;
                }
                case NO_SIDE_EFFECTS: {
                    message = "it is mentioned in appInfo.noSideEffects";
                    break;
                }
                case PINNED_SOURCE: {
                    message = "it should be kept";
                    break;
                }
                case RESOLUTION_FOR_FIELDS_MAY_CHANGE: {
                    message = "it could affect field resolution";
                    break;
                }
                case RESOLUTION_FOR_METHODS_MAY_CHANGE: {
                    message = "it could affect method resolution";
                    break;
                }
                case STATIC_INITIALIZERS: {
                    message = "merging of static initializers are not supported";
                    break;
                }
                case UNSAFE_INLINING: {
                    message = "force-inlining might fail";
                    break;
                }
                case UNSUPPORTED_ATTRIBUTES: {
                    message = "since inner-class attributes are not supported";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return String.format("Cannot merge %s since %s.", clazz.toSourceString(), message);
        }

        static {
            $VALUES = new AbortReason[]{ALREADY_MERGED, ALWAYS_INLINE, CONFLICT, ILLEGAL_ACCESS, NO_SIDE_EFFECTS, PINNED_SOURCE, RESOLUTION_FOR_FIELDS_MAY_CHANGE, RESOLUTION_FOR_METHODS_MAY_CHANGE, STATIC_INITIALIZERS, UNSAFE_INLINING, UNSUPPORTED_ATTRIBUTES};
        }
    }
}

