/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.InliningStrategy;
import java.util.ListIterator;
import java.util.Map;

final class ForcedInliningOracle
implements InliningOracle,
InliningStrategy {
    private final DexEncodedMethod method;
    private final Map<InvokeMethod, Inliner.InliningInfo> invokesToInline;

    ForcedInliningOracle(DexEncodedMethod method, Map<InvokeMethod, Inliner.InliningInfo> invokesToInline) {
        this.method = method;
        this.invokesToInline = invokesToInline;
    }

    @Override
    public void finish() {
    }

    @Override
    public Inliner.InlineAction computeForInvokeWithReceiver(InvokeMethodWithReceiver invoke, DexType invocationContext) {
        return this.computeForInvoke(invoke);
    }

    @Override
    public Inliner.InlineAction computeForInvokeStatic(InvokeStatic invoke, DexType invocationContext) {
        return this.computeForInvoke(invoke);
    }

    private Inliner.InlineAction computeForInvoke(InvokeMethod invoke) {
        Inliner.InliningInfo info = this.invokesToInline.get(invoke);
        if (info == null) {
            return null;
        }
        assert (this.method != info.target);
        return new Inliner.InlineAction(info.target, invoke, Inliner.Reason.FORCE);
    }

    @Override
    public Inliner.InlineAction computeForInvokePolymorphic(InvokePolymorphic invoke, DexType invocationContext) {
        return null;
    }

    @Override
    public void ensureMethodProcessed(DexEncodedMethod target, IRCode inlinee) {
    }

    @Override
    public boolean isValidTarget(InvokeMethod invoke, DexEncodedMethod target, IRCode inlinee) {
        return true;
    }

    @Override
    public ListIterator<BasicBlock> updateTypeInformationIfNeeded(IRCode inlinee, ListIterator<BasicBlock> blockIterator, BasicBlock block, BasicBlock invokeSuccessor) {
        return blockIterator;
    }

    @Override
    public boolean exceededAllowance() {
        return false;
    }

    @Override
    public void markInlined(IRCode inlinee) {
    }

    @Override
    public DexType getReceiverTypeIfKnown(InvokeMethod invoke) {
        assert (invoke.isInvokeMethodWithReceiver());
        Inliner.InliningInfo info = this.invokesToInline.get(invoke.asInvokeMethodWithReceiver());
        assert (info != null);
        return info.receiverType;
    }
}

