/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.code.FillArrayData;
import com.android.tools.r8.code.FillArrayDataPayload;
import com.android.tools.r8.code.FilledNewArray;
import com.android.tools.r8.code.FilledNewArrayRange;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeDirectRange;
import com.android.tools.r8.code.InvokeInterface;
import com.android.tools.r8.code.InvokeInterfaceRange;
import com.android.tools.r8.code.InvokePolymorphic;
import com.android.tools.r8.code.InvokePolymorphicRange;
import com.android.tools.r8.code.InvokeStatic;
import com.android.tools.r8.code.InvokeStaticRange;
import com.android.tools.r8.code.InvokeSuper;
import com.android.tools.r8.code.InvokeSuperRange;
import com.android.tools.r8.code.InvokeVirtual;
import com.android.tools.r8.code.InvokeVirtualRange;
import com.android.tools.r8.code.MoveException;
import com.android.tools.r8.code.MoveResult;
import com.android.tools.r8.code.MoveResultObject;
import com.android.tools.r8.code.MoveResultWide;
import com.android.tools.r8.code.SwitchPayload;
import com.android.tools.r8.code.Throw;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.code.CanonicalPositions;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.ArrayFilledDataPayloadResolver;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.ir.conversion.SwitchPayloadResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DexSourceCode
implements SourceCode {
    private final DexCode code;
    private final MethodAccessFlags accessFlags;
    private final DexProto proto;
    private final Map<Integer, Integer> offsetToInstructionIndex = new HashMap<Integer, Integer>();
    private final SwitchPayloadResolver switchPayloadResolver = new SwitchPayloadResolver();
    private final ArrayFilledDataPayloadResolver arrayFilledDataPayloadResolver = new ArrayFilledDataPayloadResolver();
    private DexCode.Try currentTryRange = null;
    private CatchHandlers<Integer> currentCatchHandlers = null;
    private Instruction currentDexInstruction = null;
    private Position currentPosition = null;
    private final CanonicalPositions canonicalPositions;
    private final List<ValueType> argumentTypes;
    private List<DexDebugEntry> debugEntries = null;
    private final DexMethod originalMethod;

    public DexSourceCode(DexCode code, DexEncodedMethod method, DexMethod originalMethod, Position callerPosition, boolean preserveCaller) {
        this.code = code;
        this.proto = method.method.proto;
        this.accessFlags = method.accessFlags;
        this.originalMethod = originalMethod;
        this.argumentTypes = this.computeArgumentTypes();
        DexDebugInfo info = code.getDebugInfo();
        if (info != null) {
            this.debugEntries = info.computeEntries(originalMethod);
        }
        this.canonicalPositions = new CanonicalPositions(callerPosition, preserveCaller, this.debugEntries == null ? 0 : this.debugEntries.size(), originalMethod);
    }

    @Override
    public boolean verifyRegister(int register) {
        return register < this.code.registerSize;
    }

    @Override
    public int instructionCount() {
        return this.code.instructions.length;
    }

    @Override
    public DebugLocalInfo getIncomingLocal(int register) {
        return null;
    }

    @Override
    public DebugLocalInfo getOutgoingLocal(int register) {
        return null;
    }

    @Override
    public void setUp() {
        for (int index = 0; index < this.code.instructions.length; ++index) {
            Instruction insn = this.code.instructions[index];
            this.offsetToInstructionIndex.put(insn.getOffset(), index);
            if (!insn.isPayload()) continue;
            if (insn.isSwitchPayload()) {
                this.switchPayloadResolver.resolve((SwitchPayload)insn);
                continue;
            }
            this.arrayFilledDataPayloadResolver.resolve((FillArrayDataPayload)insn);
        }
    }

    @Override
    public void buildPrelude(IRBuilder builder) {
        this.currentPosition = this.canonicalPositions.getPreamblePosition();
        if (this.code.incomingRegisterSize == 0) {
            return;
        }
        int register = this.code.registerSize - this.code.incomingRegisterSize;
        if (!this.accessFlags.isStatic()) {
            builder.addThisArgument(register);
            ++register;
        }
        for (ValueType type : this.argumentTypes) {
            builder.addNonThisArgument(register, type);
            register += type.requiredRegisters();
        }
    }

    @Override
    public void buildPostlude(IRBuilder builder) {
    }

    @Override
    public void buildInstruction(IRBuilder builder, int instructionIndex, boolean firstBlockInstruction) {
        this.updateCurrentCatchHandlers(instructionIndex);
        this.updateDebugPosition(instructionIndex, builder);
        this.currentDexInstruction = this.code.instructions[instructionIndex];
        this.currentDexInstruction.buildIR(builder);
    }

    @Override
    public CatchHandlers<Integer> getCurrentCatchHandlers() {
        return this.currentCatchHandlers;
    }

    @Override
    public int getMoveExceptionRegister(int instructionIndex) {
        Instruction instruction = this.code.instructions[instructionIndex];
        if (instruction instanceof MoveException) {
            MoveException moveException = (MoveException)instruction;
            return moveException.AA;
        }
        return -1;
    }

    @Override
    public Position getCanonicalDebugPositionAtOffset(int offset) {
        DexDebugEntry entry = this.getDebugEntryAtOffset(offset);
        return entry == null ? this.canonicalPositions.getPreamblePosition() : this.getCanonicalPositionAppendCaller(entry);
    }

    @Override
    public Position getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public boolean verifyCurrentInstructionCanThrow() {
        return this.currentDexInstruction.canThrow();
    }

    @Override
    public boolean verifyLocalInScope(DebugLocalInfo local) {
        return true;
    }

    private void updateCurrentCatchHandlers(int instructionIndex) {
        DexCode.Try tryRange = this.getTryForOffset(this.instructionOffset(instructionIndex));
        if (tryRange == this.currentTryRange) {
            return;
        }
        this.currentTryRange = tryRange;
        this.currentCatchHandlers = tryRange == null ? null : new CatchHandlers<Integer>(this.getTryHandlerGuards(tryRange), this.getTryHandlerOffsets(tryRange));
    }

    private DexDebugEntry getDebugEntryAtOffset(int offset) {
        DexDebugEntry current = null;
        if (this.debugEntries != null) {
            for (DexDebugEntry entry : this.debugEntries) {
                if (entry.address > offset) break;
                current = entry;
            }
        }
        return current;
    }

    private void updateDebugPosition(int instructionIndex, IRBuilder builder) {
        if (this.debugEntries == null || this.debugEntries.isEmpty()) {
            return;
        }
        int offset = this.instructionOffset(instructionIndex);
        DexDebugEntry entry = this.getDebugEntryAtOffset(offset);
        if (entry == null) {
            this.currentPosition = this.canonicalPositions.getPreamblePosition();
        } else {
            this.currentPosition = this.getCanonicalPositionAppendCaller(entry);
            if (entry.lineEntry && entry.address == offset) {
                builder.addDebugPosition(this.currentPosition);
            }
        }
    }

    private Position getCanonicalPositionAppendCaller(DexDebugEntry entry) {
        assert (entry.callerPosition == null || entry.callerPosition.getOutermostCaller().method == this.originalMethod);
        return this.canonicalPositions.getCanonical(new Position(entry.line, entry.sourceFile, entry.method, this.canonicalPositions.canonicalizeCallerPosition(entry.callerPosition)));
    }

    @Override
    public void clear() {
        this.switchPayloadResolver.clear();
        this.arrayFilledDataPayloadResolver.clear();
    }

    @Override
    public int instructionIndex(int instructionOffset) {
        return this.offsetToInstructionIndex.get(instructionOffset);
    }

    @Override
    public int instructionOffset(int instructionIndex) {
        return this.code.instructions[instructionIndex].getOffset();
    }

    @Override
    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
        builder.addSwitch(value, this.switchPayloadResolver.getKeys(payloadOffset), fallthroughOffset, this.switchPayloadResolver.absoluteTargets(payloadOffset));
    }

    @Override
    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
        builder.addNewArrayFilledData(arrayRef, this.arrayFilledDataPayloadResolver.getElementWidth(payloadOffset), this.arrayFilledDataPayloadResolver.getSize(payloadOffset), this.arrayFilledDataPayloadResolver.getData(payloadOffset));
    }

    private List<ValueType> computeArgumentTypes() {
        ArrayList<ValueType> types = new ArrayList<ValueType>(this.proto.parameters.size());
        String shorty = this.proto.shorty.toString();
        for (int i = 1; i < this.proto.shorty.size; ++i) {
            ValueType valueType = ValueType.fromTypeDescriptorChar(shorty.charAt(i));
            types.add(valueType);
        }
        return types;
    }

    private boolean isInvoke(Instruction dex) {
        return dex instanceof InvokeDirect || dex instanceof InvokeDirectRange || dex instanceof InvokeVirtual || dex instanceof InvokeVirtualRange || dex instanceof InvokeInterface || dex instanceof InvokeInterfaceRange || dex instanceof InvokeStatic || dex instanceof InvokeStaticRange || dex instanceof InvokeSuper || dex instanceof InvokeSuperRange || dex instanceof InvokePolymorphic || dex instanceof InvokePolymorphicRange || dex instanceof FilledNewArray || dex instanceof FilledNewArrayRange;
    }

    private boolean isMoveResult(Instruction dex) {
        return dex instanceof MoveResult || dex instanceof MoveResultObject || dex instanceof MoveResultWide;
    }

    @Override
    public int traceInstruction(int index, IRBuilder builder) {
        Instruction dex = this.code.instructions[index];
        int offset = dex.getOffset();
        assert (!dex.isPayload());
        int[] targets = dex.getTargets();
        if (targets != Instruction.NO_TARGETS) {
            assert (!dex.canThrow());
            for (int relativeOffset : targets) {
                builder.ensureNormalSuccessorBlock(offset, offset + relativeOffset);
            }
            return index;
        }
        if (dex.canThrow()) {
            DexCode.Try tryRange = this.getTryForOffset(offset);
            if (tryRange != null) {
                int tryRangeStartAddress = tryRange.startAddress;
                if (this.isMoveResult(this.code.instructions[this.offsetToInstructionIndex.get(tryRangeStartAddress)])) {
                    ++tryRangeStartAddress;
                }
                builder.ensureBlockWithoutEnqueuing(tryRangeStartAddress);
                for (Integer handlerOffset : this.getUniqueTryHandlerOffsets(tryRange)) {
                    builder.ensureExceptionalSuccessorBlock(offset, handlerOffset);
                }
                if (index + 1 < this.code.instructions.length && this.isMoveResult(this.code.instructions[index + 1])) {
                    assert (this.isInvoke(dex));
                    dex = this.code.instructions[++index];
                }
                if (!(dex instanceof Throw)) {
                    builder.ensureNormalSuccessorBlock(offset, dex.getOffset() + dex.getSize());
                }
                return index;
            }
            return dex instanceof Throw ? index : -1;
        }
        if (dex.isSwitch()) {
            this.switchPayloadResolver.addPayloadUser(dex);
            for (int target : this.switchPayloadResolver.absoluteTargets(dex)) {
                builder.ensureNormalSuccessorBlock(offset, target);
            }
            builder.ensureNormalSuccessorBlock(offset, offset + dex.getSize());
            return index;
        }
        if (dex.hasPayload()) {
            this.arrayFilledDataPayloadResolver.addPayloadUser((FillArrayData)dex);
        }
        return -1;
    }

    private boolean inTryRange(DexCode.Try tryItem, int offset) {
        return tryItem.startAddress <= offset && offset < tryItem.startAddress + tryItem.instructionCount;
    }

    private DexCode.Try getTryForOffset(int offset) {
        for (DexCode.Try tryRange : this.code.tries) {
            if (!this.inTryRange(tryRange, offset)) continue;
            return tryRange;
        }
        return null;
    }

    private Set<Integer> getUniqueTryHandlerOffsets(DexCode.Try tryRange) {
        return new HashSet<Integer>(this.getTryHandlerOffsets(tryRange));
    }

    private List<Integer> getTryHandlerOffsets(DexCode.Try tryRange) {
        ArrayList<Integer> handlerOffsets = new ArrayList<Integer>();
        DexCode.TryHandler handler = this.code.handlers[tryRange.handlerIndex];
        for (DexCode.TryHandler.TypeAddrPair pair : handler.pairs) {
            handlerOffsets.add(pair.addr);
        }
        if (handler.catchAllAddr != -1) {
            handlerOffsets.add(handler.catchAllAddr);
        }
        return handlerOffsets;
    }

    private List<DexType> getTryHandlerGuards(DexCode.Try tryRange) {
        ArrayList<DexType> handlerGuards = new ArrayList<DexType>();
        DexCode.TryHandler handler = this.code.handlers[tryRange.handlerIndex];
        for (DexCode.TryHandler.TypeAddrPair pair : handler.pairs) {
            handlerGuards.add(pair.type);
        }
        if (handler.catchAllAddr != -1) {
            handlerGuards.add(DexItemFactory.catchAllType);
        }
        return handlerGuards;
    }
}

