/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexItemFactory {
    private final ConcurrentHashMap<DexString, DexString> strings = new ConcurrentHashMap();
    private final ConcurrentHashMap<DexString, DexType> types = new ConcurrentHashMap();
    private final ConcurrentHashMap<DexField, DexField> fields = new ConcurrentHashMap();
    private final ConcurrentHashMap<DexProto, DexProto> protos = new ConcurrentHashMap();
    private final ConcurrentHashMap<DexMethod, DexMethod> methods = new ConcurrentHashMap();
    private final ConcurrentHashMap<DexMethodHandle, DexMethodHandle> methodHandles = new ConcurrentHashMap();
    private final List<DexCallSite> callSites = new ArrayList<DexCallSite>();
    private final Int2ObjectMap<DexDebugEvent.AdvanceLine> advanceLines = new Int2ObjectOpenHashMap<DexDebugEvent.AdvanceLine>();
    private final Int2ObjectMap<DexDebugEvent.AdvancePC> advancePCs = new Int2ObjectOpenHashMap<DexDebugEvent.AdvancePC>();
    private final Int2ObjectMap<DexDebugEvent.Default> defaults = new Int2ObjectOpenHashMap<DexDebugEvent.Default>();
    private final Int2ObjectMap<DexDebugEvent.EndLocal> endLocals = new Int2ObjectOpenHashMap<DexDebugEvent.EndLocal>();
    private final Int2ObjectMap<DexDebugEvent.RestartLocal> restartLocals = new Int2ObjectOpenHashMap<DexDebugEvent.RestartLocal>();
    private final DexDebugEvent.SetEpilogueBegin setEpilogueBegin = new DexDebugEvent.SetEpilogueBegin();
    private final DexDebugEvent.SetPrologueEnd setPrologueEnd = new DexDebugEvent.SetPrologueEnd();
    private final Map<DexString, DexDebugEvent.SetFile> setFiles = new HashMap<DexString, DexDebugEvent.SetFile>();
    private final Map<DexDebugEvent.SetInlineFrame, DexDebugEvent.SetInlineFrame> setInlineFrames = new HashMap<DexDebugEvent.SetInlineFrame, DexDebugEvent.SetInlineFrame>();
    private final ConcurrentHashMap<DexItemBasedString, DexItemBasedString> identifiers = new ConcurrentHashMap();
    boolean sorted = false;
    public static final DexType catchAllType = new DexType(new DexString("CATCH_ALL"));
    public static final DexType nullValueType = new DexType(new DexString("NULL"));
    public static final DexString unknownTypeName = new DexString("UNKNOWN");
    private static final IdentityHashMap<DexItem, DexItem> internalSentinels = new IdentityHashMap<DexString, DexString>(ImmutableMap.of(catchAllType, catchAllType, nullValueType, nullValueType, unknownTypeName, unknownTypeName));
    public final DexString booleanDescriptor = this.createString("Z");
    public final DexString byteDescriptor = this.createString("B");
    public final DexString charDescriptor = this.createString("C");
    public final DexString doubleDescriptor = this.createString("D");
    public final DexString floatDescriptor = this.createString("F");
    public final DexString intDescriptor = this.createString("I");
    public final DexString longDescriptor = this.createString("J");
    public final DexString shortDescriptor = this.createString("S");
    public final DexString voidDescriptor = this.createString("V");
    public final DexString boxedBooleanDescriptor = this.createString("Ljava/lang/Boolean;");
    public final DexString boxedByteDescriptor = this.createString("Ljava/lang/Byte;");
    public final DexString boxedCharDescriptor = this.createString("Ljava/lang/Character;");
    public final DexString boxedDoubleDescriptor = this.createString("Ljava/lang/Double;");
    public final DexString boxedFloatDescriptor = this.createString("Ljava/lang/Float;");
    public final DexString boxedIntDescriptor = this.createString("Ljava/lang/Integer;");
    public final DexString boxedLongDescriptor = this.createString("Ljava/lang/Long;");
    public final DexString boxedShortDescriptor = this.createString("Ljava/lang/Short;");
    public final DexString boxedNumberDescriptor = this.createString("Ljava/lang/Number;");
    public final DexString unboxBooleanMethodName = this.createString("booleanValue");
    public final DexString unboxByteMethodName = this.createString("byteValue");
    public final DexString unboxCharMethodName = this.createString("charValue");
    public final DexString unboxShortMethodName = this.createString("shortValue");
    public final DexString unboxIntMethodName = this.createString("intValue");
    public final DexString unboxLongMethodName = this.createString("longValue");
    public final DexString unboxFloatMethodName = this.createString("floatValue");
    public final DexString unboxDoubleMethodName = this.createString("doubleValue");
    public final DexString valueOfMethodName = this.createString("valueOf");
    public final DexString getClassMethodName = this.createString("getClass");
    public final DexString finalizeMethodName = this.createString("finalize");
    public final DexString ordinalMethodName = this.createString("ordinal");
    public final DexString desiredAssertionStatusMethodName = this.createString("desiredAssertionStatus");
    public final DexString forNameMethodName = this.createString("forName");
    public final DexString getNameName = this.createString("getName");
    public final DexString getSimpleNameName = this.createString("getSimpleName");
    public final DexString getFieldName = this.createString("getField");
    public final DexString getDeclaredFieldName = this.createString("getDeclaredField");
    public final DexString getMethodName = this.createString("getMethod");
    public final DexString getDeclaredMethodName = this.createString("getDeclaredMethod");
    public final DexString assertionsDisabled = this.createString("$assertionsDisabled");
    public final DexString invokeMethodName = this.createString("invoke");
    public final DexString invokeExactMethodName = this.createString("invokeExact");
    public final DexString stringDescriptor = this.createString("Ljava/lang/String;");
    public final DexString stringArrayDescriptor = this.createString("[Ljava/lang/String;");
    public final DexString objectDescriptor = this.createString("Ljava/lang/Object;");
    public final DexString objectArrayDescriptor = this.createString("[Ljava/lang/Object;");
    public final DexString classDescriptor = this.createString("Ljava/lang/Class;");
    public final DexString autoCloseableDescriptor = this.createString("Ljava/lang/AutoCloseable;");
    public final DexString classArrayDescriptor = this.createString("[Ljava/lang/Class;");
    public final DexString fieldDescriptor = this.createString("Ljava/lang/reflect/Field;");
    public final DexString methodDescriptor = this.createString("Ljava/lang/reflect/Method;");
    public final DexString enumDescriptor = this.createString("Ljava/lang/Enum;");
    public final DexString annotationDescriptor = this.createString("Ljava/lang/annotation/Annotation;");
    public final DexString throwableDescriptor = this.createString("Ljava/lang/Throwable;");
    public final DexString objectsDescriptor = this.createString("Ljava/util/Objects;");
    public final DexString stringBuilderDescriptor = this.createString("Ljava/lang/StringBuilder;");
    public final DexString stringBufferDescriptor = this.createString("Ljava/lang/StringBuffer;");
    public final DexString varHandleDescriptor = this.createString("Ljava/lang/invoke/VarHandle;");
    public final DexString methodHandleDescriptor = this.createString("Ljava/lang/invoke/MethodHandle;");
    public final DexString methodTypeDescriptor = this.createString("Ljava/lang/invoke/MethodType;");
    public final DexString intFieldUpdaterDescriptor = this.createString("Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;");
    public final DexString longFieldUpdaterDescriptor = this.createString("Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;");
    public final DexString referenceFieldUpdaterDescriptor = this.createString("Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;");
    public final DexString newUpdaterName = this.createString("newUpdater");
    public final DexString constructorMethodName = this.createString("<init>");
    public final DexString classConstructorMethodName = this.createString("<clinit>");
    public final DexString thisName = this.createString("this");
    private final DexString charArrayDescriptor = this.createString("[C");
    private final DexType charArrayType = this.createType(this.charArrayDescriptor);
    public final DexString throwableArrayDescriptor = this.createString("[Ljava/lang/Throwable;");
    public final DexType booleanType = this.createType(this.booleanDescriptor);
    public final DexType byteType = this.createType(this.byteDescriptor);
    public final DexType charType = this.createType(this.charDescriptor);
    public final DexType doubleType = this.createType(this.doubleDescriptor);
    public final DexType floatType = this.createType(this.floatDescriptor);
    public final DexType intType = this.createType(this.intDescriptor);
    public final DexType longType = this.createType(this.longDescriptor);
    public final DexType shortType = this.createType(this.shortDescriptor);
    public final DexType voidType = this.createType(this.voidDescriptor);
    public final DexType boxedBooleanType = this.createType(this.boxedBooleanDescriptor);
    public final DexType boxedByteType = this.createType(this.boxedByteDescriptor);
    public final DexType boxedCharType = this.createType(this.boxedCharDescriptor);
    public final DexType boxedDoubleType = this.createType(this.boxedDoubleDescriptor);
    public final DexType boxedFloatType = this.createType(this.boxedFloatDescriptor);
    public final DexType boxedIntType = this.createType(this.boxedIntDescriptor);
    public final DexType boxedLongType = this.createType(this.boxedLongDescriptor);
    public final DexType boxedShortType = this.createType(this.boxedShortDescriptor);
    public final DexType boxedNumberType = this.createType(this.boxedNumberDescriptor);
    public final DexType stringType = this.createType(this.stringDescriptor);
    public final DexType stringArrayType = this.createType(this.stringArrayDescriptor);
    public final DexType objectType = this.createType(this.objectDescriptor);
    public final DexType objectArrayType = this.createType(this.objectArrayDescriptor);
    public final DexType enumType = this.createType(this.enumDescriptor);
    public final DexType annotationType = this.createType(this.annotationDescriptor);
    public final DexType throwableType = this.createType(this.throwableDescriptor);
    public final DexType classType = this.createType(this.classDescriptor);
    public final DexType autoCloseableType = this.createType(this.autoCloseableDescriptor);
    public final DexType stringBuilderType = this.createType(this.stringBuilderDescriptor);
    public final DexType stringBufferType = this.createType(this.stringBufferDescriptor);
    public final DexType varHandleType = this.createType(this.varHandleDescriptor);
    public final DexType methodHandleType = this.createType(this.methodHandleDescriptor);
    public final DexType methodTypeType = this.createType(this.methodTypeDescriptor);
    public final StringBuildingMethods stringBuilderMethods = new StringBuildingMethods(this.stringBuilderType);
    public final StringBuildingMethods stringBufferMethods = new StringBuildingMethods(this.stringBufferType);
    public final ObjectsMethods objectsMethods = new ObjectsMethods();
    public final ObjectMethods objectMethods = new ObjectMethods();
    public final LongMethods longMethods = new LongMethods();
    public final ThrowableMethods throwableMethods = new ThrowableMethods();
    public final ClassMethods classMethods = new ClassMethods();
    public final AtomicFieldUpdaterMethods atomicFieldUpdaterMethods = new AtomicFieldUpdaterMethods();
    public final Kotlin kotlin;
    public final PolymorphicMethods polymorphicMethods = new PolymorphicMethods();
    public final DexString twrCloseResourceMethodName = this.createString("$closeResource");
    public final DexProto twrCloseResourceMethodProto = this.createProto(this.voidType, this.throwableType, this.autoCloseableType);
    public final DexType annotationDefault = this.createType("Ldalvik/annotation/AnnotationDefault;");
    public final DexType annotationEnclosingClass = this.createType("Ldalvik/annotation/EnclosingClass;");
    public final DexType annotationEnclosingMethod = this.createType("Ldalvik/annotation/EnclosingMethod;");
    public final DexType annotationInnerClass = this.createType("Ldalvik/annotation/InnerClass;");
    public final DexType annotationMemberClasses = this.createType("Ldalvik/annotation/MemberClasses;");
    public final DexType annotationMethodParameters = this.createType("Ldalvik/annotation/MethodParameters;");
    public final DexType annotationSignature = this.createType("Ldalvik/annotation/Signature;");
    public final DexType annotationSourceDebugExtension = this.createType("Ldalvik/annotation/SourceDebugExtension;");
    public final DexType annotationThrows = this.createType("Ldalvik/annotation/Throws;");
    public final DexType annotationSynthesizedClassMap = this.createType("Lcom/android/tools/r8/annotations/SynthesizedClassMap;");
    public final DexType annotationCovariantReturnType = this.createType("Ldalvik/annotation/codegen/CovariantReturnType;");
    public final DexType annotationCovariantReturnTypes = this.createType("Ldalvik/annotation/codegen/CovariantReturnType$CovariantReturnTypes;");
    private static final String METAFACTORY_METHOD_NAME = "metafactory";
    private static final String METAFACTORY_ALT_METHOD_NAME = "altMetafactory";
    public final DexType metafactoryType = this.createType("Ljava/lang/invoke/LambdaMetafactory;");
    public final DexType callSiteType = this.createType("Ljava/lang/invoke/CallSite;");
    public final DexType lookupType = this.createType("Ljava/lang/invoke/MethodHandles$Lookup;");
    public final DexType serializableType = this.createType("Ljava/io/Serializable;");
    public final DexType comparableType = this.createType("Ljava/lang/Comparable;");
    public final DexMethod metafactoryMethod = this.createMethod(this.metafactoryType, this.createProto(this.callSiteType, this.lookupType, this.stringType, this.methodTypeType, this.methodTypeType, this.methodHandleType, this.methodTypeType), this.createString("metafactory"));
    public final DexMethod metafactoryAltMethod = this.createMethod(this.metafactoryType, this.createProto(this.callSiteType, this.lookupType, this.stringType, this.methodTypeType, this.objectArrayType), this.createString("altMetafactory"));
    public final DexType stringConcatFactoryType = this.createType("Ljava/lang/invoke/StringConcatFactory;");
    public final DexMethod stringConcatWithConstantsMethod = this.createMethod(this.stringConcatFactoryType, this.createProto(this.callSiteType, this.lookupType, this.stringType, this.methodTypeType, this.stringType, this.objectArrayType), this.createString("makeConcatWithConstants"));
    public final DexMethod stringConcatMethod = this.createMethod(this.stringConcatFactoryType, this.createProto(this.callSiteType, this.lookupType, this.stringType, this.methodTypeType), this.createString("makeConcat"));
    private boolean skipNameValidationForTesting = false;

    public DexItemFactory() {
        this.kotlin = new Kotlin(this);
    }

    public static boolean isInternalSentinel(DexItem item) {
        return internalSentinels.containsKey(item);
    }

    public void setSkipNameValidationForTesting(boolean skipNameValidationForTesting) {
        this.skipNameValidationForTesting = skipNameValidationForTesting;
    }

    public boolean getSkipNameValidationForTesting() {
        return this.skipNameValidationForTesting;
    }

    public synchronized void clearSubtypeInformation() {
        this.types.values().forEach(DexType::clearSubtypeInformation);
    }

    private static <T extends DexItem> T canonicalize(ConcurrentHashMap<T, T> map2, T item) {
        assert (item != null);
        assert (!DexItemFactory.isInternalSentinel(item));
        DexItem previous = (DexItem)map2.putIfAbsent(item, item);
        return (T)(previous == null ? item : previous);
    }

    public DexString createString(int size, byte[] content) {
        assert (!this.sorted);
        return DexItemFactory.canonicalize(this.strings, new DexString(size, content));
    }

    public DexString createString(String source) {
        assert (!this.sorted);
        return DexItemFactory.canonicalize(this.strings, new DexString(source));
    }

    public DexString lookupString(String source) {
        return this.strings.get(new DexString(source));
    }

    public DexItemBasedString createItemBasedString(DexReference reference) {
        DexItemBasedString dexItemBasedString;
        assert (!this.sorted);
        if (reference.isDexType()) {
            dexItemBasedString = new DexItemBasedString(reference.asDexType());
        } else if (reference.isDexMethod()) {
            dexItemBasedString = new DexItemBasedString(reference.asDexMethod());
        } else {
            assert (reference.isDexField());
            dexItemBasedString = new DexItemBasedString(reference.asDexField());
        }
        return DexItemFactory.canonicalize(this.identifiers, dexItemBasedString);
    }

    public synchronized Marker extractMarker() {
        for (DexString dexString : this.strings.keySet()) {
            Marker result = Marker.parse(dexString);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public synchronized List<Marker> extractMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (DexString dexString : this.strings.keySet()) {
            Marker marker = Marker.parse(dexString);
            if (marker == null) continue;
            markers.add(marker);
        }
        return markers;
    }

    public synchronized DexType createType(DexString descriptor) {
        assert (!this.sorted);
        assert (descriptor != null);
        DexType result = this.types.get(descriptor);
        if (result == null) {
            result = new DexType(descriptor);
            assert (result.isArrayType() || result.isClassType() || result.isPrimitiveType() || result.isVoidType());
            assert (!DexItemFactory.isInternalSentinel(result));
            this.types.put(descriptor, result);
        }
        return result;
    }

    public DexType createType(String descriptor) {
        return this.createType(this.createString(descriptor));
    }

    public DexType lookupType(DexString descriptor) {
        return this.types.get(descriptor);
    }

    public DexType createArrayType(int nesting, DexType baseType) {
        assert (nesting > 0);
        return this.createType(Strings.repeat("[", nesting) + baseType.toDescriptorString());
    }

    public DexField createField(DexType clazz, DexType type, DexString name) {
        assert (!this.sorted);
        DexField field = new DexField(clazz, type, name, this.skipNameValidationForTesting);
        return DexItemFactory.canonicalize(this.fields, field);
    }

    public DexField createField(DexType clazz, DexType type, String name) {
        return this.createField(clazz, type, this.createString(name));
    }

    public DexProto createProto(DexType returnType, DexString shorty, DexTypeList parameters) {
        assert (!this.sorted);
        DexProto proto = new DexProto(shorty, returnType, parameters);
        return DexItemFactory.canonicalize(this.protos, proto);
    }

    public DexProto createProto(DexType returnType, DexType ... parameters) {
        assert (!this.sorted);
        return this.createProto(returnType, this.createShorty(returnType, parameters), parameters.length == 0 ? DexTypeList.empty() : new DexTypeList(parameters));
    }

    public DexProto applyClassMappingToProto(DexProto proto, Function<DexType, DexType> mapping, Map<DexProto, DexProto> cache) {
        assert (cache != null);
        DexProto result = cache.get(proto);
        if (result == null) {
            DexType returnType = mapping.apply(proto.returnType);
            Object[] parameters = DexItemFactory.applyClassMappingToDexTypes(proto.parameters.values, mapping);
            if (returnType == proto.returnType && parameters == proto.parameters.values) {
                result = proto;
            } else {
                assert (returnType == proto.returnType || !returnType.equals(proto.returnType));
                assert (parameters == proto.parameters.values || !Arrays.equals(parameters, proto.parameters.values));
                result = this.createProto(returnType, (DexType[])parameters);
            }
            cache.put(proto, result);
        }
        return result;
    }

    private static DexType[] applyClassMappingToDexTypes(DexType[] types, Function<DexType, DexType> mapping) {
        Int2ObjectArrayMap<DexType> changed = new Int2ObjectArrayMap<DexType>();
        for (int i = 0; i < types.length; ++i) {
            DexType applied = mapping.apply(types[i]);
            if (applied == types[i]) continue;
            changed.put(Integer.valueOf(i), applied);
        }
        return changed.isEmpty() ? types : ArrayUtils.copyWithSparseChanges(DexType[].class, types, changed);
    }

    private DexString createShorty(DexType returnType, DexType[] argumentTypes) {
        StringBuilder shortyBuilder = new StringBuilder();
        shortyBuilder.append(returnType.toShorty());
        for (DexType argumentType : argumentTypes) {
            shortyBuilder.append(argumentType.toShorty());
        }
        return this.createString(shortyBuilder.toString());
    }

    public DexMethod createMethod(DexType holder, DexProto proto, DexString name) {
        assert (!this.sorted);
        DexMethod method = new DexMethod(holder, proto, name, this.skipNameValidationForTesting);
        return DexItemFactory.canonicalize(this.methods, method);
    }

    public DexMethod createMethod(DexType holder, DexProto proto, String name) {
        return this.createMethod(holder, proto, this.createString(name));
    }

    public DexMethodHandle createMethodHandle(DexMethodHandle.MethodHandleType type, Descriptor<? extends DexItem, ? extends Descriptor<?, ?>> fieldOrMethod) {
        assert (!this.sorted);
        DexMethodHandle methodHandle = new DexMethodHandle(type, fieldOrMethod);
        return DexItemFactory.canonicalize(this.methodHandles, methodHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexCallSite createCallSite(DexString methodName, DexProto methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs) {
        assert (!this.sorted);
        DexCallSite callSite = new DexCallSite(methodName, methodProto, bootstrapMethod, bootstrapArgs);
        List<DexCallSite> list = this.callSites;
        synchronized (list) {
            this.callSites.add(callSite);
        }
        return callSite;
    }

    public DexMethod createMethod(DexString clazzDescriptor, DexString name, DexString returnTypeDescriptor, DexString[] parameterDescriptors) {
        assert (!this.sorted);
        DexType clazz = this.createType(clazzDescriptor);
        DexType returnType = this.createType(returnTypeDescriptor);
        DexType[] parameterTypes = new DexType[parameterDescriptors.length];
        for (int i = 0; i < parameterDescriptors.length; ++i) {
            parameterTypes[i] = this.createType(parameterDescriptors[i]);
        }
        DexProto proto = this.createProto(returnType, parameterTypes);
        return this.createMethod(clazz, proto, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.AdvanceLine createAdvanceLine(int delta) {
        Int2ObjectMap<DexDebugEvent.AdvanceLine> int2ObjectMap = this.advanceLines;
        synchronized (int2ObjectMap) {
            return this.advanceLines.computeIfAbsent(delta, DexDebugEvent.AdvanceLine::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.AdvancePC createAdvancePC(int delta) {
        Int2ObjectMap<DexDebugEvent.AdvancePC> int2ObjectMap = this.advancePCs;
        synchronized (int2ObjectMap) {
            return this.advancePCs.computeIfAbsent(delta, DexDebugEvent.AdvancePC::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.Default createDefault(int value) {
        Int2ObjectMap<DexDebugEvent.Default> int2ObjectMap = this.defaults;
        synchronized (int2ObjectMap) {
            return this.defaults.computeIfAbsent(value, DexDebugEvent.Default::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.EndLocal createEndLocal(int registerNum) {
        Int2ObjectMap<DexDebugEvent.EndLocal> int2ObjectMap = this.endLocals;
        synchronized (int2ObjectMap) {
            return this.endLocals.computeIfAbsent(registerNum, DexDebugEvent.EndLocal::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.RestartLocal createRestartLocal(int registerNum) {
        Int2ObjectMap<DexDebugEvent.RestartLocal> int2ObjectMap = this.restartLocals;
        synchronized (int2ObjectMap) {
            return this.restartLocals.computeIfAbsent(registerNum, DexDebugEvent.RestartLocal::new);
        }
    }

    public DexDebugEvent.SetEpilogueBegin createSetEpilogueBegin() {
        return this.setEpilogueBegin;
    }

    public DexDebugEvent.SetPrologueEnd createSetPrologueEnd() {
        return this.setPrologueEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.SetFile createSetFile(DexString fileName) {
        Map<DexString, DexDebugEvent.SetFile> map2 = this.setFiles;
        synchronized (map2) {
            return this.setFiles.computeIfAbsent(fileName, DexDebugEvent.SetFile::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexDebugEvent.SetInlineFrame createSetInlineFrame(DexMethod callee, Position caller) {
        Map<DexDebugEvent.SetInlineFrame, DexDebugEvent.SetInlineFrame> map2 = this.setInlineFrames;
        synchronized (map2) {
            return this.setInlineFrames.computeIfAbsent(new DexDebugEvent.SetInlineFrame(callee, caller), p -> p);
        }
    }

    public boolean isConstructor(DexMethod method) {
        return method.name == this.constructorMethodName;
    }

    public boolean isClassConstructor(DexMethod method) {
        return method.name == this.classConstructorMethodName;
    }

    private static <S extends PresortedComparable<S>> void assignSortedIndices(Collection<S> items, NamingLens namingLens) {
        ArrayList<S> sorted2 = new ArrayList<S>(items);
        sorted2.sort((a, b) -> a.layeredCompareTo(b, namingLens));
        int i = 0;
        for (PresortedComparable value : sorted2) {
            value.setSortedIndex(i++);
        }
    }

    public synchronized void sort(NamingLens namingLens) {
        assert (!this.sorted);
        DexItemFactory.assignSortedIndices(this.strings.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.types.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.fields.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.protos.values(), namingLens);
        DexItemFactory.assignSortedIndices(this.methods.values(), namingLens);
        this.sorted = true;
    }

    public synchronized void resetSortedIndices() {
        if (!this.sorted) {
            return;
        }
        this.strings.values().forEach(IndexedDexItem::resetSortedIndex);
        this.types.values().forEach(IndexedDexItem::resetSortedIndex);
        this.fields.values().forEach(IndexedDexItem::resetSortedIndex);
        this.protos.values().forEach(IndexedDexItem::resetSortedIndex);
        this.methods.values().forEach(IndexedDexItem::resetSortedIndex);
        this.sorted = false;
    }

    public synchronized void forAllTypes(Consumer<DexType> f) {
        new ArrayList<DexType>(this.types.values()).forEach(f);
    }

    public synchronized void forAllCallSites(Consumer<DexCallSite> f) {
        new ArrayList<DexCallSite>(this.callSites).forEach(f);
    }

    public class PolymorphicMethods {
        private final DexProto signature;
        private final DexProto setSignature;
        private final DexProto compareAndSetSignature;
        private final Set<DexString> varHandleMethods;
        private final Set<DexString> varHandleSetMethods;
        private final Set<DexString> varHandleCompareAndSetMethods;

        public PolymorphicMethods() {
            this.signature = DexItemFactory.this.createProto(DexItemFactory.this.objectType, DexItemFactory.this.objectArrayType);
            this.setSignature = DexItemFactory.this.createProto(DexItemFactory.this.voidType, DexItemFactory.this.objectArrayType);
            this.compareAndSetSignature = DexItemFactory.this.createProto(DexItemFactory.this.booleanType, DexItemFactory.this.objectArrayType);
            this.varHandleMethods = this.createStrings("compareAndExchange", "compareAndExchangeAcquire", "compareAndExchangeRelease", "get", "getAcquire", "getAndAdd", "getAndAddAcquire", "getAndAddRelease", "getAndBitwiseAnd", "getAndBitwiseAndAcquire", "getAndBitwiseAndRelease", "getAndBitwiseOr", "getAndBitwiseOrAcquire", "getAndBitwiseOrRelease", "getAndBitwiseXor", "getAndBitwiseXorAcquire", "getAndBitwiseXorRelease", "getAndSet", "getAndSetAcquire", "getAndSetRelease", "getOpaque", "getVolatile");
            this.varHandleSetMethods = this.createStrings("set", "setOpaque", "setRelease", "setVolatile");
            this.varHandleCompareAndSetMethods = this.createStrings("compareAndSet", "weakCompareAndSet", "weakCompareAndSetAcquire", "weakCompareAndSetPlain", "weakCompareAndSetRelease");
        }

        public DexMethod canonicalize(DexMethod invokeProto) {
            if (invokeProto.holder == DexItemFactory.this.methodHandleType) {
                if (invokeProto.name == DexItemFactory.this.invokeMethodName || invokeProto.name == DexItemFactory.this.invokeExactMethodName) {
                    return DexItemFactory.this.createMethod(DexItemFactory.this.methodHandleType, this.signature, invokeProto.name);
                }
            } else if (invokeProto.holder == DexItemFactory.this.varHandleType) {
                if (this.varHandleMethods.contains(invokeProto.name)) {
                    return DexItemFactory.this.createMethod(DexItemFactory.this.varHandleType, this.signature, invokeProto.name);
                }
                if (this.varHandleSetMethods.contains(invokeProto.name)) {
                    return DexItemFactory.this.createMethod(DexItemFactory.this.varHandleType, this.setSignature, invokeProto.name);
                }
                if (this.varHandleCompareAndSetMethods.contains(invokeProto.name)) {
                    return DexItemFactory.this.createMethod(DexItemFactory.this.varHandleType, this.compareAndSetSignature, invokeProto.name);
                }
            }
            return null;
        }

        private Set<DexString> createStrings(String ... strings) {
            IdentityHashMap<DexString, DexString> map2 = new IdentityHashMap<DexString, DexString>();
            for (String string : strings) {
                DexString dexString = DexItemFactory.this.createString(string);
                map2.put(dexString, dexString);
            }
            return map2.keySet();
        }
    }

    public class StringBuildingMethods {
        public final DexMethod appendBoolean;
        public final DexMethod appendChar;
        public final DexMethod appendCharArray;
        public final DexMethod appendSubCharArray;
        public final DexMethod appendCharSequence;
        public final DexMethod appendSubCharSequence;
        public final DexMethod appendInt;
        public final DexMethod appendDouble;
        public final DexMethod appendFloat;
        public final DexMethod appendLong;
        public final DexMethod appendObject;
        public final DexMethod appendString;
        public final DexMethod appendStringBuffer;

        private StringBuildingMethods(DexType receiver) {
            DexType sbufType = DexItemFactory.this.createType(DexItemFactory.this.createString("Ljava/lang/StringBuffer;"));
            DexType charSequenceType = DexItemFactory.this.createType(DexItemFactory.this.createString("Ljava/lang/CharSequence;"));
            DexString append = DexItemFactory.this.createString("append");
            DexString toStringMethodName = DexItemFactory.this.createString("toString");
            this.appendBoolean = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.booleanType), append);
            this.appendChar = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charType), append);
            this.appendCharArray = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charArrayType), append);
            this.appendSubCharArray = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.charArrayType, DexItemFactory.this.intType, DexItemFactory.this.intType), append);
            this.appendCharSequence = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, charSequenceType), append);
            this.appendSubCharSequence = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, charSequenceType, DexItemFactory.this.intType, DexItemFactory.this.intType), append);
            this.appendInt = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.intType), append);
            this.appendDouble = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.doubleType), append);
            this.appendFloat = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.floatType), append);
            this.appendLong = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.longType), append);
            this.appendObject = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.objectType), append);
            this.appendString = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, DexItemFactory.this.stringType), append);
            this.appendStringBuffer = DexItemFactory.this.createMethod(receiver, DexItemFactory.this.createProto(receiver, sbufType), append);
        }

        public void forEachAppendMethod(Consumer<DexMethod> consumer) {
            consumer.accept(this.appendBoolean);
            consumer.accept(this.appendChar);
            consumer.accept(this.appendCharArray);
            consumer.accept(this.appendSubCharArray);
            consumer.accept(this.appendCharSequence);
            consumer.accept(this.appendSubCharSequence);
            consumer.accept(this.appendInt);
            consumer.accept(this.appendDouble);
            consumer.accept(this.appendFloat);
            consumer.accept(this.appendLong);
            consumer.accept(this.appendObject);
            consumer.accept(this.appendString);
            consumer.accept(this.appendStringBuffer);
            consumer.accept(this.appendBoolean);
        }
    }

    public class AtomicFieldUpdaterMethods {
        public DexMethod intUpdater;
        public DexMethod longUpdater;
        public DexMethod referenceUpdater;
        private Set<DexMethod> updaters;

        private AtomicFieldUpdaterMethods() {
            this.intUpdater = DexItemFactory.this.createMethod(DexItemFactory.this.intFieldUpdaterDescriptor, DexItemFactory.this.newUpdaterName, DexItemFactory.this.intFieldUpdaterDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.longUpdater = DexItemFactory.this.createMethod(DexItemFactory.this.longFieldUpdaterDescriptor, DexItemFactory.this.newUpdaterName, DexItemFactory.this.longFieldUpdaterDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.referenceUpdater = DexItemFactory.this.createMethod(DexItemFactory.this.referenceFieldUpdaterDescriptor, DexItemFactory.this.newUpdaterName, DexItemFactory.this.referenceFieldUpdaterDescriptor, new DexString[]{DexItemFactory.this.classDescriptor, DexItemFactory.this.classDescriptor, DexItemFactory.this.stringDescriptor});
            this.updaters = ImmutableSet.of(this.intUpdater, this.longUpdater, this.referenceUpdater);
        }

        public boolean isFieldUpdater(DexMethod method) {
            return this.updaters.contains(method);
        }
    }

    public class ClassMethods {
        public DexMethod desiredAssertionStatus;
        public DexMethod forName;
        public DexMethod getName;
        public DexMethod getSimpleName;
        public DexMethod getField;
        public DexMethod getDeclaredField;
        public DexMethod getMethod;
        public DexMethod getDeclaredMethod;
        private Set<DexMethod> getMembers;

        private ClassMethods() {
            this.desiredAssertionStatus = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.desiredAssertionStatusMethodName, DexItemFactory.this.booleanDescriptor, DexString.EMPTY_ARRAY);
            this.forName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.forNameMethodName, DexItemFactory.this.classDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor});
            this.getName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getNameName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.getSimpleName = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getSimpleNameName, DexItemFactory.this.stringDescriptor, DexString.EMPTY_ARRAY);
            this.getField = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getFieldName, DexItemFactory.this.fieldDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor});
            this.getDeclaredField = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getDeclaredFieldName, DexItemFactory.this.fieldDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor});
            this.getMethod = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getMethodName, DexItemFactory.this.methodDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor, DexItemFactory.this.classArrayDescriptor});
            this.getDeclaredMethod = DexItemFactory.this.createMethod(DexItemFactory.this.classDescriptor, DexItemFactory.this.getDeclaredMethodName, DexItemFactory.this.methodDescriptor, new DexString[]{DexItemFactory.this.stringDescriptor, DexItemFactory.this.classArrayDescriptor});
            this.getMembers = ImmutableSet.of(this.getField, this.getDeclaredField, this.getMethod, this.getDeclaredMethod);
        }

        public boolean isReflectiveMemberLookup(DexMethod method) {
            return this.getMembers.contains(method);
        }
    }

    public class ObjectsMethods {
        public DexMethod requireNonNull;

        private ObjectsMethods() {
            this.requireNonNull = DexItemFactory.this.createMethod(DexItemFactory.this.objectsDescriptor, DexItemFactory.this.createString("requireNonNull"), DexItemFactory.this.objectDescriptor, new DexString[]{DexItemFactory.this.objectDescriptor});
        }
    }

    public class ObjectMethods {
        public final DexMethod getClass;
        public final DexMethod constructor;
        public final DexMethod finalize;

        private ObjectMethods() {
            this.getClass = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.getClassMethodName, DexItemFactory.this.classDescriptor, DexString.EMPTY_ARRAY);
            this.constructor = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.constructorMethodName, DexItemFactory.this.voidType.descriptor, DexString.EMPTY_ARRAY);
            this.finalize = DexItemFactory.this.createMethod(DexItemFactory.this.objectDescriptor, DexItemFactory.this.finalizeMethodName, DexItemFactory.this.voidType.descriptor, DexString.EMPTY_ARRAY);
        }
    }

    public class ThrowableMethods {
        public final DexMethod addSuppressed;
        public final DexMethod getSuppressed;

        private ThrowableMethods() {
            this.addSuppressed = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("addSuppressed"), DexItemFactory.this.voidDescriptor, new DexString[]{DexItemFactory.this.throwableDescriptor});
            this.getSuppressed = DexItemFactory.this.createMethod(DexItemFactory.this.throwableDescriptor, DexItemFactory.this.createString("getSuppressed"), DexItemFactory.this.throwableArrayDescriptor, DexString.EMPTY_ARRAY);
        }
    }

    public class LongMethods {
        public final DexMethod compare;

        private LongMethods() {
            this.compare = DexItemFactory.this.createMethod(DexItemFactory.this.boxedLongDescriptor, DexItemFactory.this.createString("compare"), DexItemFactory.this.intDescriptor, new DexString[]{DexItemFactory.this.longDescriptor, DexItemFactory.this.longDescriptor});
        }
    }
}

