/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011BW\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\nR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/builder/core/DesugarProcessArgs;", "Ljava/io/Serializable;", "inputsToOutputs", "", "", "classpath", "", "bootClasspath", "tmpDir", "verbose", "", "minSdkVersion", "", "enableBugFixForJacoco", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;Ljava/lang/String;ZIZ)V", "getArgs", "isWindows", "Companion", "builder"})
public final class DesugarProcessArgs
implements Serializable {
    private final Map<String, String> inputsToOutputs;
    private final List<String> classpath;
    private final List<String> bootClasspath;
    private final String tmpDir;
    private final boolean verbose;
    private final int minSdkVersion;
    private final boolean enableBugFixForJacoco;
    public static final int MIN_SUPPORTED_API_TRY_WITH_RESOURCES = 19;
    public static final int MAX_CMD_LENGTH_FOR_WINDOWS = 32768;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> getArgs(boolean isWindows) {
        List list;
        List args;
        block12: {
            block11: {
                void $receiver$iv$iv;
                args = new ArrayList();
                if (this.verbose) {
                    args.add("--verbose");
                }
                this.inputsToOutputs.forEach(new BiConsumer<String, String>(args){
                    final /* synthetic */ List $args;

                    public final void accept(@NotNull String input, @NotNull String out) {
                        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                        this.$args.add("--input");
                        this.$args.add(input);
                        this.$args.add("--output");
                        this.$args.add(out);
                    }
                    {
                        this.$args = list;
                    }
                });
                Iterable $receiver$iv = this.classpath;
                for (Object element$iv : $receiver$iv) {
                    String c = (String)element$iv;
                    args.add("--classpath_entry");
                    args.add(c);
                }
                $receiver$iv = this.bootClasspath;
                for (Object element$iv : $receiver$iv) {
                    String b = (String)element$iv;
                    args.add("--bootclasspath_entry");
                    args.add(b);
                }
                args.add("--min_sdk_version");
                String string = Integer.toString(this.minSdkVersion);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(minSdkVersion)");
                args.add(string);
                if (this.minSdkVersion < 19) {
                    args.add("--desugar_try_with_resources_if_needed");
                } else {
                    args.add("--nodesugar_try_with_resources_if_needed");
                }
                args.add("--desugar_try_with_resources_omit_runtime_classes");
                if (this.enableBugFixForJacoco) {
                    args.add("--legacy_jacoco_fix");
                }
                args.add("--copy_bridges_from_classpath");
                if (!isWindows) break block11;
                $receiver$iv = args;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String $i$f$forEach = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Integer n = it.length();
                    collection.add(n);
                }
                if (CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)) > 32768) break block12;
            }
            list = args;
            return list;
        }
        Path pathTmpDir = Paths.get(this.tmpDir, new String[0]);
        if (!Files.exists(pathTmpDir, new LinkOption[0])) {
            Files.createDirectories(pathTmpDir, new FileAttribute[0]);
        }
        Path argsFile = Files.createTempFile(pathTmpDir, "desugar_args", "", new FileAttribute[0]);
        Files.write(argsFile, (Iterable<? extends CharSequence>)args, Charsets.UTF_8, new OpenOption[0]);
        ImmutableList immutableList = ImmutableList.of((Object)("@" + ((Object)argsFile).toString()));
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(\"@\" + argsFile.toString())");
        list = (List)immutableList;
        return list;
    }

    public DesugarProcessArgs(@NotNull Map<String, String> inputsToOutputs, @NotNull List<String> classpath, @NotNull List<String> bootClasspath, @NotNull String tmpDir, boolean verbose, int minSdkVersion, boolean enableBugFixForJacoco) {
        Intrinsics.checkParameterIsNotNull(inputsToOutputs, (String)"inputsToOutputs");
        Intrinsics.checkParameterIsNotNull(classpath, (String)"classpath");
        Intrinsics.checkParameterIsNotNull(bootClasspath, (String)"bootClasspath");
        Intrinsics.checkParameterIsNotNull((Object)tmpDir, (String)"tmpDir");
        this.inputsToOutputs = inputsToOutputs;
        this.classpath = classpath;
        this.bootClasspath = bootClasspath;
        this.tmpDir = tmpDir;
        this.verbose = verbose;
        this.minSdkVersion = minSdkVersion;
        this.enableBugFixForJacoco = enableBugFixForJacoco;
    }

    public /* synthetic */ DesugarProcessArgs(Map map2, List list, List list2, String string, boolean bl, int n, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            bl2 = true;
        }
        this(map2, list, list2, string, bl, n, bl2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/core/DesugarProcessArgs$Companion;", "", "()V", "MAX_CMD_LENGTH_FOR_WINDOWS", "", "MIN_SUPPORTED_API_TRY_WITH_RESOURCES", "builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

