/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.CfgPrinter;
import java.util.List;
import java.util.ListIterator;

public class Goto
extends JumpInstruction {
    public Goto() {
        super(null);
        super.setPosition(Position.none());
    }

    public Goto(BasicBlock block) {
        this();
        this.setBlock(block);
    }

    @Override
    public void setPosition(Position position) {
    }

    public BasicBlock getTarget() {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 1);
        return successors.get(successors.size() - 1);
    }

    public void setTarget(BasicBlock nextBlock) {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 1);
        BasicBlock target = successors.get(successors.size() - 1);
        target.getPredecessors().remove(this.getBlock());
        successors.set(successors.size() - 1, nextBlock);
        nextBlock.getPredecessors().add(this.getBlock());
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addGoto(this);
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "Goto has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Goto defines no values.";
        return 0;
    }

    @Override
    public String toString() {
        if (this.getBlock() != null && !this.getBlock().getSuccessors().isEmpty()) {
            return super.toString() + "block " + this.getTarget().getNumberAsString();
        }
        return super.toString() + "block <unknown>";
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        printer.append(" B").append(this.getTarget().getNumber());
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isGoto() && other.asGoto().getTarget() == this.getTarget();
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isGoto());
        assert (false) : "Not supported";
        return 0;
    }

    @Override
    public boolean isGoto() {
        return true;
    }

    @Override
    public Goto asGoto() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
    }

    public boolean isTrivialGotoToTheNextBlock(IRCode code) {
        BasicBlock thisBlock = this.getBlock();
        ListIterator blockIterator = code.blocks.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            if (thisBlock != block) continue;
            return blockIterator.hasNext() && blockIterator.next() == this.getTarget();
        }
        return false;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfGoto(builder.getLabel(this.getTarget())));
    }
}

