/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;

abstract class MemberNameMinifier<MemberType, StateType extends CachedHashValueDexItem> {
    protected final Enqueuer.AppInfoWithLiveness appInfo;
    protected final RootSetBuilder.RootSet rootSet;
    protected final ImmutableList<String> dictionary;
    protected final Map<MemberType, DexString> renaming = new IdentityHashMap<MemberType, DexString>();
    protected final Map<DexType, NamingState<StateType, ?>> states = new IdentityHashMap();
    protected final NamingState<StateType, ?> globalState;
    protected final boolean useUniqueMemberNames;
    protected final boolean overloadAggressively;

    MemberNameMinifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.dictionary = options.proguardConfiguration.getObfuscationDictionary();
        this.useUniqueMemberNames = options.proguardConfiguration.isUseUniqueClassMemberNames();
        this.overloadAggressively = options.proguardConfiguration.isOverloadAggressivelyWithoutUseUniqueClassMemberNames();
        this.globalState = NamingState.createRoot(appInfo.dexItemFactory, this.dictionary, this.getKeyTransform(), this.useUniqueMemberNames);
    }

    abstract Function<StateType, ?> getKeyTransform();

    protected NamingState<StateType, ?> computeStateIfAbsent(DexType type, Function<DexType, NamingState<StateType, ?>> f) {
        return this.useUniqueMemberNames ? this.globalState : this.states.computeIfAbsent(type, f);
    }

    protected NamingState<StateType, ?> getState(DexType type) {
        return this.useUniqueMemberNames ? this.globalState : this.states.get(type);
    }
}

