/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.ApkInfoParser;
import com.android.builder.core.BootClasspathBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.BlockingResourceLinker;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.internal.compiler.ShaderProcessor;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class AndroidBuilder {
    public static final Revision MIN_BUILD_TOOLS_REV;
    public static final Revision DEFAULT_BUILD_TOOLS_REVISION;
    private static final int API_LEVEL_SPLIT_APK = 21;
    private final String mProjectId;
    private final ILogger mLogger;
    private final ProcessExecutor mProcessExecutor;
    private final JavaProcessExecutor mJavaProcessExecutor;
    private final EvalIssueReporter issueReporter;
    private final MessageReceiver messageReceiver;
    private final boolean mVerboseExec;
    private String mCreatedBy;
    private SdkInfo mSdkInfo;
    private TargetInfo mTargetInfo;
    private List<File> mBootClasspathFiltered;
    private List<File> mBootClasspathAll;
    private List<LibraryRequest> mLibraryRequests = ImmutableList.of();

    public AndroidBuilder(String projectId, String createdBy, ProcessExecutor processExecutor, JavaProcessExecutor javaProcessExecutor, EvalIssueReporter issueReporter, MessageReceiver messageReceiver, ILogger logger, boolean verboseExec) {
        this.mProjectId = (String)Preconditions.checkNotNull((Object)projectId);
        this.mCreatedBy = createdBy;
        this.mProcessExecutor = (ProcessExecutor)Preconditions.checkNotNull((Object)processExecutor);
        this.mJavaProcessExecutor = (JavaProcessExecutor)Preconditions.checkNotNull((Object)javaProcessExecutor);
        this.issueReporter = (EvalIssueReporter)Preconditions.checkNotNull((Object)issueReporter);
        this.messageReceiver = messageReceiver;
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
    }

    public void setTargetInfo(TargetInfo targetInfo) {
        this.mTargetInfo = targetInfo;
        if (this.mTargetInfo.getBuildTools().getRevision().compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            this.issueReporter.reportError(EvalIssueReporter.Type.BUILD_TOOLS_TOO_LOW, new EvalIssueException(String.format("The SDK Build Tools revision (%1$s) is too low for project '%2$s'. Minimum required is %3$s", this.mTargetInfo.getBuildTools().getRevision(), this.mProjectId, MIN_BUILD_TOOLS_REV), MIN_BUILD_TOOLS_REV.toString()));
        }
    }

    public void setSdkInfo(SdkInfo sdkInfo) {
        this.mSdkInfo = sdkInfo;
    }

    public void setLibraryRequests(Collection<LibraryRequest> libraryRequests) {
        this.mLibraryRequests = ImmutableList.copyOf(libraryRequests);
    }

    public SdkInfo getSdkInfo() {
        return this.mSdkInfo;
    }

    public TargetInfo getTargetInfo() {
        return this.mTargetInfo;
    }

    public BuildToolInfo getBuildToolInfo() {
        Preconditions.checkNotNull((Object)this.mTargetInfo, (Object)"Cannot call getBuildToolInfo() before setTargetInfo() is called.");
        return this.mTargetInfo.getBuildTools();
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public EvalIssueReporter getIssueReporter() {
        return this.issueReporter;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public IAndroidTarget getTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTarget() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget();
    }

    public boolean isPreviewTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call isTargetAPreview() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().isPreview();
    }

    public String getTargetCodename() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTargetCodename() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().getCodename();
    }

    public List<File> getBootClasspath(boolean includeOptionalLibraries) {
        if (includeOptionalLibraries) {
            return this.computeFullBootClasspath();
        }
        return this.computeFilteredBootClasspath();
    }

    public List<File> computeAdditionalAndRequestedOptionalLibraries() {
        return BootClasspathBuilder.computeAdditionalAndRequestedOptionalLibraries(this.mTargetInfo.getTarget(), this.mLibraryRequests, this.issueReporter);
    }

    private List<File> computeFilteredBootClasspath() {
        if (this.mBootClasspathFiltered == null) {
            Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
            this.mBootClasspathFiltered = BootClasspathBuilder.computeFilteredClasspath(this.mTargetInfo.getTarget(), this.mLibraryRequests, this.issueReporter, this.mSdkInfo.getAnnotationsJar());
        }
        return this.mBootClasspathFiltered;
    }

    private List<File> computeFullBootClasspath() {
        if (this.mBootClasspathAll == null) {
            Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
            this.mBootClasspathAll = BootClasspathBuilder.computeFullBootClasspath(this.mTargetInfo.getTarget(), this.mSdkInfo.getAnnotationsJar());
        }
        return this.mBootClasspathAll;
    }

    public List<String> getBootClasspathAsStrings(boolean includeOptionalLibraries) {
        List<File> classpath = this.getBootClasspath(includeOptionalLibraries);
        ArrayList results = Lists.newArrayListWithCapacity((int)classpath.size());
        for (File f : classpath) {
            results.add(f.getAbsolutePath());
        }
        return results;
    }

    public File getRenderScriptSupportJar(boolean useAndroidX) {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportJar(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath(), useAndroidX);
        }
        return null;
    }

    public File getSupportNativeLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportNativeLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public File getSupportBlasLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportBlasLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public ProcessExecutor getProcessExecutor() {
        return this.mProcessExecutor;
    }

    public JavaProcessExecutor getJavaProcessExecutor() {
        return this.mJavaProcessExecutor;
    }

    public ProcessResult executeProcess(ProcessInfo processInfo, ProcessOutputHandler handler) {
        return this.mProcessExecutor.execute(processInfo, handler);
    }

    public MergingReport mergeManifestsForApplication(File mainManifest, List<File> manifestOverlays, List<? extends ManifestProvider> dependencies, List<File> navigationFiles, String featureName, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion, String outManifestLocation, String outAaptSafeManifestLocation, String outInstantRunManifestLocation, String outMetadataFeatureManifestLocation, String outBundleManifestLocation, String outInstantAppManifestLocation, ManifestMerger2.MergeType mergeType, Map<String, Object> placeHolders, Collection<ManifestMerger2.Invoker.Feature> optionalFeatures, File reportFile) {
        try {
            ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(manifestOverlays.toArray(new File[0])).addManifestProviders(dependencies).addNavigationFiles(navigationFiles).withFeatures(optionalFeatures.toArray(new ManifestMerger2.Invoker.Feature[0])).setMergeReportFile(reportFile).setFeatureName(featureName);
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            if (outAaptSafeManifestLocation != null) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE});
            }
            AndroidBuilder.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode, versionName, minSdkVersion, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            this.mLogger.verbose("Merging result: %1$s", new Object[]{mergingReport.getResult()});
            switch (mergingReport.getResult()) {
                case WARNING: {
                    mergingReport.log(this.mLogger);
                }
                case SUCCESS: {
                    String instantAppManifest;
                    String bundleMergedManifest;
                    String featureManifest;
                    String instantRunMergedManifest;
                    String xmlDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    }
                    AndroidBuilder.save(xmlDocument, new File(outManifestLocation));
                    this.mLogger.verbose("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    if (outAaptSafeManifestLocation != null) {
                        AndroidBuilder.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
                    }
                    if (outInstantRunManifestLocation != null && (instantRunMergedManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.INSTANT_RUN)) != null) {
                        AndroidBuilder.save(instantRunMergedManifest, new File(outInstantRunManifestLocation));
                    }
                    if (outMetadataFeatureManifestLocation != null && (featureManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.METADATA_FEATURE)) != null) {
                        AndroidBuilder.save(featureManifest, new File(outMetadataFeatureManifestLocation));
                    }
                    if (outBundleManifestLocation != null && (bundleMergedManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BUNDLE)) != null) {
                        AndroidBuilder.save(bundleMergedManifest, new File(outBundleManifestLocation));
                    }
                    if (outInstantAppManifestLocation == null || (instantAppManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.INSTANT_APP)) == null) break;
                    AndroidBuilder.save(instantAppManifest, new File(outInstantAppManifestLocation));
                    break;
                }
                case ERROR: {
                    mergingReport.log(this.mLogger);
                    throw new RuntimeException(mergingReport.getReportString());
                }
                default: {
                    throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
                }
            }
            return mergingReport;
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setInjectableValues(ManifestMerger2.Invoker<?> invoker, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion) {
        if (!Strings.isNullOrEmpty((String)packageOverride)) {
            invoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
        }
        if (versionCode > 0) {
            invoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(versionCode));
        }
        if (!Strings.isNullOrEmpty((String)versionName)) {
            invoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName);
        }
        if (!Strings.isNullOrEmpty((String)minSdkVersion)) {
            invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
        }
        if (!Strings.isNullOrEmpty((String)targetSdkVersion)) {
            invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
        }
    }

    private static void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            Files.write((CharSequence)xmlDocument, (File)out, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeManifestsForTestVariant(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, String testLabel, File testManifestFile, List<? extends ManifestProvider> manifestProviders, Map<String, Object> manifestPlaceholders, File outManifest, File tmpDir) throws IOException {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(manifestProviders, (Object)"manifestProviders cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        File tempFile1 = null;
        File tempFile2 = null;
        try {
            FileUtils.mkdirs((File)tmpDir);
            File generatedTestManifest = manifestProviders.isEmpty() && testManifestFile == null ? outManifest : (tempFile1 = File.createTempFile("manifestMerger", ".xml", tmpDir));
            this.mLogger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
            AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
            if (testManifestFile != null && testManifestFile.exists()) {
                ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setPlaceHolderValues(manifestPlaceholders).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifest(generatedTestManifest);
                invoker.setOverride(ManifestSystemProperty.PACKAGE, testApplicationId);
                invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
                invoker.setOverride(ManifestSystemProperty.NAME, instrumentationRunner);
                invoker.setOverride(ManifestSystemProperty.TARGET_PACKAGE, testedApplicationId);
                invoker.setOverride(ManifestSystemProperty.FUNCTIONAL_TEST, functionalTest.toString());
                invoker.setOverride(ManifestSystemProperty.HANDLE_PROFILING, handleProfiling.toString());
                if (testLabel != null) {
                    invoker.setOverride(ManifestSystemProperty.LABEL, testLabel);
                }
                if (!targetSdkVersion.equals("-1")) {
                    invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                }
                MergingReport mergingReport = invoker.merge();
                if (manifestProviders.isEmpty()) {
                    this.handleMergingResult(mergingReport, outManifest);
                } else {
                    tempFile2 = File.createTempFile("manifestMerger", ".xml", tmpDir);
                    this.handleMergingResult(mergingReport, tempFile2);
                    generatedTestManifest = tempFile2;
                }
            }
            if (!manifestProviders.isEmpty()) {
                MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestSystemProperty.PACKAGE, testApplicationId).addManifestProviders(manifestProviders).setPlaceHolderValues(manifestPlaceholders).merge();
                this.handleMergingResult(mergingReport, outManifest);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to create the temporary file", e);
                catch (ManifestMerger2.MergeFailureException e2) {
                    throw new RuntimeException("Manifest merging exception", e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile1 != null) {
                        FileUtils.delete(tempFile1);
                    }
                    if (tempFile2 == null) throw throwable;
                    FileUtils.delete(tempFile2);
                    throw throwable;
                }
                catch (IOException e3) {
                    this.mLogger.error((Throwable)e3, "Unable to clean up the temporary files.", new Object[0]);
                }
                throw throwable;
            }
        }
        try {
            if (tempFile1 != null) {
                FileUtils.delete((File)tempFile1);
            }
            if (tempFile2 == null) return;
            FileUtils.delete(tempFile2);
            return;
        }
        catch (IOException e) {
            this.mLogger.error((Throwable)e, "Unable to clean up the temporary files.", new Object[0]);
            return;
        }
    }

    private void handleMergingResult(MergingReport mergingReport, File outFile) {
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(this.mLogger);
            }
            case SUCCESS: {
                try {
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    } else {
                        this.mLogger.verbose("No blaming records from manifest merger", new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                String finalMergedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                if (finalMergedDocument == null) {
                    throw new RuntimeException("No result from manifest merger");
                }
                try {
                    Files.write((CharSequence)finalMergedDocument, (File)outFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    this.mLogger.error((Throwable)e, "Cannot write resulting xml", new Object[0]);
                    throw new RuntimeException(e);
                }
                this.mLogger.verbose("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(this.mLogger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processResources(BlockingResourceLinker aapt, AaptPackageConfig.Builder aaptConfigBuilder) throws IOException, ProcessException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processResources() before setTargetInfo() is called.");
        aaptConfigBuilder.setAndroidTarget(this.mTargetInfo.getTarget());
        AaptPackageConfig aaptConfig = aaptConfigBuilder.build();
        AndroidBuilder.processResources(aapt, aaptConfig, this.mLogger);
    }

    public static void processResources(BlockingResourceLinker aapt, AaptPackageConfig aaptConfig, ILogger logger) throws IOException, ProcessException {
        try {
            aapt.link(aaptConfig, logger);
        }
        catch (Aapt2Exception | Aapt2InternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessException("Failed to execute aapt", (Throwable)e);
        }
        File sourceOut = aaptConfig.getSourceOutputDir();
        if (sourceOut != null) {
            File mainRTxt;
            String mainPackageName = aaptConfig.getCustomPackageForR();
            if (mainPackageName == null) {
                mainPackageName = SymbolUtils.getPackageNameFromManifest((File)aaptConfig.getManifestFile());
            }
            SymbolTable mainSymbols = (mainRTxt = new File(aaptConfig.getSymbolOutputDir(), "R.txt")).isFile() ? SymbolIo.readFromAapt((File)mainRTxt, (String)mainPackageName) : SymbolTable.builder().tablePackage(mainPackageName).build();
            ImmutableSet depSymbolTables = SymbolUtils.loadDependenciesSymbolTables(aaptConfig.getLibrarySymbolTableFiles());
            boolean finalIds = true;
            if (aaptConfig.getVariantType().isAar()) {
                finalIds = false;
            }
            RGeneration.generateRForLibraries((SymbolTable)mainSymbols, (Collection)depSymbolTables, (File)sourceOut, (boolean)finalIds);
        }
    }

    public void generateApkData(File apkFile, File outResFolder, String mainPkgName, String resName) throws ProcessException, IOException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null) {
            throw new IllegalStateException("Unable to get aapt location from Build Tools " + buildToolInfo.getRevision());
        }
        ApkInfoParser parser = new ApkInfoParser(new File(aapt), this.mProcessExecutor);
        ApkInfoParser.ApkInfo apkInfo = parser.parseApk(apkFile);
        if (!apkInfo.getPackageName().equals(mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <versionCode>%2$s</versionCode>\n    <versionName>%3$s</versionName>\n    <rawPathResId>%4$s</rawPathResId>\n</wearableApp>", apkInfo.getPackageName(), apkInfo.getVersionCode(), apkInfo.getVersionName(), resName);
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public void generateUnbundledWearApkData(File outResFolder, String mainPkgName) throws ProcessException, IOException {
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <unbundled />\n</wearableApp>", mainPkgName);
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public static void generateApkDataEntryInManifest(int minSdkVersion, int targetSdkVersion, File manifestFile) throws InterruptedException, IOException {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n").append("    package=\"${packageName}\">\n").append("    <uses-sdk android:minSdkVersion=\"" + minSdkVersion + "\"");
        if (targetSdkVersion != -1) {
            content.append(" android:targetSdkVersion=\"").append(targetSdkVersion).append("\"");
        }
        content.append("/>\n");
        content.append("    <application>\n").append("        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n").append("                   android:resource=\"@xml/android_wear_micro_apk").append("\" />\n").append("   </application>\n").append("</manifest>\n");
        Files.write((CharSequence)content, (File)manifestFile, (Charset)Charsets.UTF_8);
    }

    public void compileAllShaderFiles(File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, File nkdLocation, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkNotNull((Object)sourceFolder, (Object)"sourceFolder cannot be null.");
        Preconditions.checkNotNull((Object)outputDir, (Object)"outputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllShaderFiles() before setTargetInfo() is called.");
        Supplier<ShaderProcessor> processor = () -> new ShaderProcessor(nkdLocation, sourceFolder, outputDir, defaultArgs, scopedArgs, this.mProcessExecutor, processOutputHandler, WaitableExecutor.useGlobalSharedThreadPool());
        DirectoryWalker.builder().root(sourceFolder.toPath()).extensions("vert", "tesc", "tese", "geom", "frag", "comp").action(processor).build().walk();
    }

    public void compileShaderFile(File sourceFolder, File shaderFile, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, File nkdLocation, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkNotNull((Object)sourceFolder, (Object)"sourceFolder cannot be null.");
        Preconditions.checkNotNull((Object)shaderFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)outputDir, (Object)"outputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAidlFile() before setTargetInfo() is called.");
        ShaderProcessor processor = new ShaderProcessor(nkdLocation, sourceFolder, outputDir, defaultArgs, scopedArgs, this.mProcessExecutor, processOutputHandler, null);
        processor.call(sourceFolder.toPath(), shaderFile.toPath());
    }

    public void compileAllRenderscriptFiles(Collection<File> sourceFolders, Collection<File> importFolders, File sourceOutputDir, File resOutputDir, File objOutputDir, File libOutputDir, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, boolean useAndroidX, Set<String> abiFilters, ProcessOutputHandler processOutputHandler) throws InterruptedException, ProcessException, IOException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllRenderscriptFiles() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String renderscript = buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(sourceFolders, importFolders, sourceOutputDir, resOutputDir, objOutputDir, libOutputDir, buildToolInfo, targetApi, debugBuild, optimLevel, ndkMode, supportMode, useAndroidX, abiFilters, this.mLogger);
        processor.build(this.mProcessExecutor, processOutputHandler);
    }

    public void packageCodeSplitApk(File androidResPkg, Set<File> dexFiles, SigningConfig signingConfig, File outApkLocation, File incrementalDir, ApkCreatorFactory apkCreatorFactory) throws KeytoolException, PackagerException, IOException {
        boolean v2SigningEnabled;
        boolean v1SigningEnabled;
        X509Certificate certificate;
        PrivateKey key;
        if (signingConfig != null && signingConfig.isSigningReady()) {
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias())));
            key = certificateInfo.getKey();
            certificate = certificateInfo.getCertificate();
            v1SigningEnabled = signingConfig.isV1SigningEnabled();
            v2SigningEnabled = signingConfig.isV2SigningEnabled();
        } else {
            key = null;
            certificate = null;
            v1SigningEnabled = false;
            v2SigningEnabled = false;
        }
        ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(outApkLocation, key, certificate, v1SigningEnabled, v2SigningEnabled, null, this.mCreatedBy, 21, NativeLibrariesPackagingMode.COMPRESSED, s -> false);
        try (IncrementalPackager packager = new IncrementalPackager(creationData, incrementalDir, apkCreatorFactory, new HashSet<String>(), true);){
            ImmutableMap<RelativeFile, FileStatus> androidResources = IncrementalRelativeFileSets.fromZip(androidResPkg);
            packager.updateAndroidResources(androidResources);
            for (File dexFile : dexFiles) {
                RelativeFile dex = new RelativeFile(dexFile.getParentFile(), dexFile);
                packager.updateDex((ImmutableMap<RelativeFile, FileStatus>)ImmutableMap.of((Object)dex, (Object)FileStatus.NEW));
            }
        }
    }

    public String getCreatedBy() {
        return this.mCreatedBy;
    }

    static {
        DEFAULT_BUILD_TOOLS_REVISION = MIN_BUILD_TOOLS_REV = Revision.parseRevision((String)"28.0.3");
    }
}

