/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;

public abstract class TypeLatticeElement {
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean mustBeNull() {
        return false;
    }

    abstract TypeLatticeElement asNullable();

    public TypeLatticeElement asNonNullable() {
        throw new Unreachable("Flipping nullable is not allowed in general.");
    }

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    public static TypeLatticeElement join(AppInfo appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        boolean isNullable;
        if (l1.isBottom()) {
            return l2;
        }
        if (l2.isBottom()) {
            return l1;
        }
        if (l1.isTop() || l2.isTop()) {
            return TopTypeLatticeElement.getInstance();
        }
        if (l1.mustBeNull()) {
            return l2.asNullable();
        }
        if (l2.mustBeNull()) {
            return l1.asNullable();
        }
        if (l1.isPrimitive()) {
            return l2.isPrimitive() ? PrimitiveTypeLatticeElement.join(l1.asPrimitiveTypeLatticeElement(), l2.asPrimitiveTypeLatticeElement()) : TopTypeLatticeElement.getInstance();
        }
        if (l2.isPrimitive()) {
            return TopTypeLatticeElement.getInstance();
        }
        boolean bl = isNullable = l1.isNullable() || l2.isNullable();
        if (l1.getClass() != l2.getClass()) {
            return TypeLatticeElement.objectType(appInfo, isNullable);
        }
        if (l1.isArrayTypeLatticeElement()) {
            assert (l2.isArrayTypeLatticeElement());
            ArrayTypeLatticeElement a1 = l1.asArrayTypeLatticeElement();
            ArrayTypeLatticeElement a2 = l2.asArrayTypeLatticeElement();
            if (a1.getArrayType() == a2.getArrayType()) {
                return a1.isNullable() ? a1 : a2;
            }
            DexType a1BaseReferenceType = a1.getArrayBaseType(appInfo.dexItemFactory);
            int a1Nesting = a1.getNesting();
            if (a1BaseReferenceType.isPrimitiveType()) {
                --a1Nesting;
                a1BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            DexType a2BaseReferenceType = a2.getArrayBaseType(appInfo.dexItemFactory);
            int a2Nesting = a2.getNesting();
            if (a2BaseReferenceType.isPrimitiveType()) {
                --a2Nesting;
                a2BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            assert (a1BaseReferenceType.isClassType() && a2BaseReferenceType.isClassType());
            if (a1Nesting == 0 || a2Nesting == 0) {
                return TypeLatticeElement.objectType(appInfo, isNullable);
            }
            if (a1Nesting != a2Nesting) {
                int min = Math.min(a1Nesting, a2Nesting);
                return TypeLatticeElement.objectArrayType(appInfo, min, isNullable);
            }
            DexType lub = a1BaseReferenceType.computeLeastUpperBoundOfClasses(appInfo, a2BaseReferenceType);
            DexType arrayTypeLub = appInfo.dexItemFactory.createArrayType(a1Nesting, lub);
            return new ArrayTypeLatticeElement(arrayTypeLub, isNullable);
        }
        if (l1.isClassTypeLatticeElement()) {
            assert (l2.isClassTypeLatticeElement());
            ClassTypeLatticeElement c1 = l1.asClassTypeLatticeElement();
            ClassTypeLatticeElement c2 = l2.asClassTypeLatticeElement();
            DexType lubType = c1.getClassType().computeLeastUpperBoundOfClasses(appInfo, c2.getClassType());
            return new ClassTypeLatticeElement(lubType, isNullable, TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, c1.getInterfaces(), c2.getInterfaces()));
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    static Set<DexType> computeLeastUpperBoundOfInterfaces(AppInfo appInfo, Set<DexType> s1, Set<DexType> s2) {
        IdentityHashMap<DexType, Set> seen = new IdentityHashMap<DexType, Set>();
        ArrayDeque<InterfaceWithMarker> worklist = new ArrayDeque<InterfaceWithMarker>();
        for (DexType itf1 : s1) {
            worklist.add(new InterfaceWithMarker(itf1, InterfaceMarker.LEFT));
        }
        for (DexType itf2 : s2) {
            worklist.add(new InterfaceWithMarker(itf2, InterfaceMarker.RIGHT));
        }
        while (!worklist.isEmpty()) {
            InterfaceWithMarker item = (InterfaceWithMarker)worklist.poll();
            DexType itf = item.itf;
            InterfaceMarker interfaceMarker = item.marker;
            Set markers = seen.computeIfAbsent(itf, k -> new HashSet());
            if (markers.contains((Object)interfaceMarker)) continue;
            if (markers.size() == 1) {
                markers.add(interfaceMarker);
                continue;
            }
            markers.add(interfaceMarker);
            DexClass itfClass = appInfo.definitionFor(itf);
            if (itfClass == null) continue;
            for (DexType superItf : itfClass.interfaces.values) {
                markers = seen.computeIfAbsent(superItf, k -> new HashSet());
                if (markers.contains((Object)interfaceMarker)) continue;
                worklist.add(new InterfaceWithMarker(superItf, interfaceMarker));
            }
        }
        ImmutableSet.Builder commonBuilder = ImmutableSet.builder();
        for (Map.Entry entry : seen.entrySet()) {
            if (((Set)entry.getValue()).size() < 2) continue;
            commonBuilder.add((DexType)entry.getKey());
        }
        ImmutableCollection commonlyVisited = commonBuilder.build();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexType itf : commonlyVisited) {
            if (commonlyVisited.stream().anyMatch(other -> other.isStrictSubtypeOf(itf, appInfo))) continue;
            builder.add(itf);
        }
        return builder.build();
    }

    private static Set<DexType> computeLeastUpperBoundOfInterfaces(AppInfo appInfo, Set<DexType> interfaces) {
        return TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, interfaces, interfaces);
    }

    public static BinaryOperator<TypeLatticeElement> joiner(AppInfo appInfo) {
        return (l1, l2) -> TypeLatticeElement.join(appInfo, l1, l2);
    }

    public static TypeLatticeElement join(AppInfo appInfo, Stream<TypeLatticeElement> types) {
        BinaryOperator<TypeLatticeElement> joiner = TypeLatticeElement.joiner(appInfo);
        return types.reduce(BottomTypeLatticeElement.getInstance(), joiner, joiner);
    }

    public static TypeLatticeElement join(AppInfo appInfo, Stream<DexType> types, boolean isNullable) {
        return TypeLatticeElement.join(appInfo, types.map(t -> TypeLatticeElement.fromDexType(appInfo, t, isNullable)));
    }

    public static boolean strictlyLessThan(AppInfo appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        if (l1.equals(l2)) {
            return false;
        }
        TypeLatticeElement lub = TypeLatticeElement.join(appInfo, Stream.of(l1, l2));
        return !l1.equals(lub) && l2.equals(lub);
    }

    public static boolean lessThanOrEqual(AppInfo appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        return l1.equals(l2) || TypeLatticeElement.strictlyLessThan(appInfo, l1, l2);
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isArrayTypeLatticeElement() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassTypeLatticeElement() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean isWide() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayTypeLatticeElement() || this.isClassTypeLatticeElement() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble();
    }

    static ClassTypeLatticeElement objectType(AppInfo appInfo, boolean isNullable) {
        return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable);
    }

    static ArrayTypeLatticeElement objectArrayType(AppInfo appInfo, int nesting, boolean isNullable) {
        return new ArrayTypeLatticeElement(appInfo.dexItemFactory.createArrayType(nesting, appInfo.dexItemFactory.objectType), isNullable);
    }

    public static TypeLatticeElement fromDexType(AppInfo appInfo, DexType type, boolean isNullable) {
        if (type == DexItemFactory.nullValueType) {
            return NullLatticeElement.getInstance();
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.fromDexType(type);
        }
        if (type.isClassType()) {
            if (!type.isUnknown() && type.isInterface()) {
                return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable, ImmutableSet.of(type));
            }
            return new ClassTypeLatticeElement(type, isNullable, TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, type.implementedInterfaces(appInfo)));
        }
        assert (type.isArrayType());
        return new ArrayTypeLatticeElement(type, isNullable);
    }

    public static TypeLatticeElement newArray(DexType arrayType, boolean isNullable) {
        return new ArrayTypeLatticeElement(arrayType, isNullable);
    }

    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return BottomTypeLatticeElement.getInstance();
    }

    public TypeLatticeElement checkCast(AppInfo appInfo, DexType castType) {
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(appInfo, castType, this.isNullable());
        if (this.mustBeNull()) {
            return castTypeLattice;
        }
        if (TypeLatticeElement.lessThanOrEqual(appInfo, this, castTypeLattice)) {
            return this;
        }
        return castTypeLattice;
    }

    public abstract String toString();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TypeLatticeElement otherElement = (TypeLatticeElement)o;
        return otherElement.isNullable() == this.isNullable;
    }

    public int hashCode() {
        return this.isNullable ? 1 : -1;
    }

    private static class InterfaceWithMarker {
        final DexType itf;
        final InterfaceMarker marker;

        InterfaceWithMarker(DexType itf, InterfaceMarker marker) {
            this.itf = itf;
            this.marker = marker;
        }
    }

    private static enum InterfaceMarker {
        LEFT,
        RIGHT;

    }
}

