/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.DoubleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.FloatTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.IntTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.LongTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.SingleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.WideTypeLatticeElement;
import com.android.tools.r8.ir.code.NumericType;

public abstract class PrimitiveTypeLatticeElement
extends TypeLatticeElement {
    PrimitiveTypeLatticeElement() {
        super(false);
    }

    @Override
    TypeLatticeElement asNullable() {
        return TopTypeLatticeElement.getInstance();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return this;
    }

    public static PrimitiveTypeLatticeElement fromDexType(DexType type) {
        assert (type.isPrimitiveType());
        return PrimitiveTypeLatticeElement.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static PrimitiveTypeLatticeElement fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return IntTypeLatticeElement.getInstance();
            }
            case 'F': {
                return FloatTypeLatticeElement.getInstance();
            }
            case 'J': {
                return LongTypeLatticeElement.getInstance();
            }
            case 'D': {
                return DoubleTypeLatticeElement.getInstance();
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static PrimitiveTypeLatticeElement fromNumericType(NumericType numericType) {
        switch (numericType) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return IntTypeLatticeElement.getInstance();
            }
            case FLOAT: {
                return FloatTypeLatticeElement.getInstance();
            }
            case LONG: {
                return LongTypeLatticeElement.getInstance();
            }
            case DOUBLE: {
                return DoubleTypeLatticeElement.getInstance();
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)numericType) + "'");
    }

    public static TypeLatticeElement join(PrimitiveTypeLatticeElement t1, PrimitiveTypeLatticeElement t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1.isSingle()) {
            if (t2.isSingle()) {
                return SingleTypeLatticeElement.getInstance();
            }
            assert (t2.isWide());
            return TopTypeLatticeElement.getInstance();
        }
        assert (t1.isWide());
        if (t2.isWide()) {
            return WideTypeLatticeElement.getInstance();
        }
        assert (t2.isSingle());
        return TopTypeLatticeElement.getInstance();
    }

    public static TypeLatticeElement meet(TypeLatticeElement t1, TypeLatticeElement t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1.isTop()) {
            return t2;
        }
        if (t2.isTop()) {
            return t1;
        }
        if (t1.isPreciseType()) {
            if (t1.isSingle() && t2.isSingle()) {
                return t1;
            }
            if (t1.isWide() && t2.isWide()) {
                return t1;
            }
        }
        if (t2.isPreciseType()) {
            if (t2.isSingle() && t1.isSingle()) {
                return t2;
            }
            if (t2.isWide() && t1.isWide()) {
                return t2;
            }
        }
        return BottomTypeLatticeElement.getInstance();
    }
}

