/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class D8DiagnosticsHandler
implements DiagnosticsHandler {
    private final MessageReceiver messageReceiver;
    private final Set<String> pendingHints = new HashSet<String>();

    public D8DiagnosticsHandler(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public static Origin getOrigin(ClassFileEntry entry) {
        Path root = entry.getInput().getPath();
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return new ArchiveEntryOrigin(entry.getRelativePath(), new PathOrigin(root));
        }
        return new PathOrigin(root.resolve(entry.getRelativePath()));
    }

    public static Origin getOrigin(DexArchiveEntry entry) {
        Path root = entry.getDexArchive().getRootPath();
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return new ArchiveEntryOrigin(entry.getRelativePathInArchive(), new PathOrigin(root));
        }
        return new PathOrigin(root.resolve(entry.getRelativePathInArchive()));
    }

    @Override
    public void error(Diagnostic warning) {
        this.messageReceiver.receiveMessage(this.convertToMessage(Message.Kind.ERROR, warning));
    }

    @Override
    public void warning(Diagnostic warning) {
        this.messageReceiver.receiveMessage(this.convertToMessage(Message.Kind.WARNING, warning));
    }

    @Override
    public void info(Diagnostic info) {
        this.messageReceiver.receiveMessage(this.convertToMessage(Message.Kind.INFO, info));
    }

    public Set<String> getPendingHints() {
        return this.pendingHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHint(String hint) {
        Set<String> set = this.pendingHints;
        synchronized (set) {
            this.pendingHints.add(hint);
        }
    }

    protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
        SourceFilePosition position;
        String textMessage = diagnostic.getDiagnosticMessage();
        Origin origin = diagnostic.getOrigin();
        Position positionInOrigin = diagnostic.getPosition();
        if (origin instanceof PathOrigin) {
            TextPosition endTextPosition;
            TextPosition startTextPosition;
            File originFile = ((PathOrigin)origin).getPath().toFile();
            if (positionInOrigin instanceof TextRange) {
                TextRange textRange = (TextRange)positionInOrigin;
                startTextPosition = textRange.getStart();
                endTextPosition = textRange.getEnd();
            } else if (positionInOrigin instanceof TextPosition) {
                endTextPosition = startTextPosition = (TextPosition)positionInOrigin;
            } else {
                startTextPosition = null;
                endTextPosition = null;
            }
            position = startTextPosition != null ? new SourceFilePosition(originFile, new SourcePosition(startTextPosition.getLine(), startTextPosition.getColumn(), D8DiagnosticsHandler.toIntOffset(startTextPosition.getOffset()), endTextPosition.getLine(), endTextPosition.getColumn(), D8DiagnosticsHandler.toIntOffset(endTextPosition.getOffset()))) : new SourceFilePosition(originFile, SourcePosition.UNKNOWN);
        } else if (origin.parent() instanceof PathOrigin) {
            File originFile = ((PathOrigin)origin.parent()).getPath().toFile();
            position = new SourceFilePosition(originFile, SourcePosition.UNKNOWN);
        } else {
            position = SourceFilePosition.UNKNOWN;
            if (origin != Origin.unknown()) {
                textMessage = origin.toString() + ": " + textMessage;
            }
        }
        return new Message(kind, textMessage, textMessage, "D8", position, new SourceFilePosition[0]);
    }

    private static int toIntOffset(long offset) {
        if (offset >= 0L && offset <= Integer.MAX_VALUE) {
            return (int)offset;
        }
        return -1;
    }
}

