/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatproguard;

import com.android.tools.r8.CompatProguardCommandBuilder;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AbortException;
import java.nio.file.Paths;
import java.util.List;

public class CompatProguard {
    private static void printVersion() {
        Version.printToolVersion("CompatProguard");
    }

    private static void printHelp() {
        CompatProguard.printVersion();
        System.out.println("");
        System.out.println("compatproguard [options] --output <dir> <proguard-config>*");
        System.out.println("");
        System.out.println("Where options are:");
        CompatProguardOptions.print();
    }

    private static void run(String[] args) throws CompilationFailedException {
        CompatProguardOptions options = CompatProguardOptions.parse(args);
        if (options.printHelpAndExit || options.output == null) {
            System.out.println("");
            CompatProguard.printHelp();
            return;
        }
        CompatProguardCommandBuilder builder = new CompatProguardCommandBuilder(options.forceProguardCompatibility, options.disableVerticalClassMerging);
        builder.setOutput(Paths.get(options.output, new String[0]), OutputMode.DexIndexed, options.includeDataResources).addProguardConfiguration(options.proguardConfig, CommandLineOrigin.INSTANCE).setMinApiLevel(options.minApi);
        if (options.mainDexList != null) {
            builder.addMainDexListFiles(Paths.get(options.mainDexList, new String[0]));
        }
        R8.run((R8Command)builder.build());
    }

    public static void main(String[] args) {
        try {
            CompatProguard.run(args);
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
    }

    public static class CompatProguardOptions {
        public final String output;
        public final int minApi;
        public final boolean forceProguardCompatibility;
        public final boolean includeDataResources;
        public final boolean multiDex;
        public final String mainDexList;
        public final List<String> proguardConfig;
        public boolean printHelpAndExit;
        public boolean disableVerticalClassMerging;

        CompatProguardOptions(List<String> proguardConfig, String output, int minApi, boolean multiDex, boolean forceProguardCompatibility, boolean includeDataResources, String mainDexList, boolean printHelpAndExit, boolean disableVerticalClassMerging) {
            this.output = output;
            this.minApi = minApi;
            this.forceProguardCompatibility = forceProguardCompatibility;
            this.includeDataResources = includeDataResources;
            this.multiDex = multiDex;
            this.mainDexList = mainDexList;
            this.proguardConfig = proguardConfig;
            this.printHelpAndExit = printHelpAndExit;
            this.disableVerticalClassMerging = disableVerticalClassMerging;
        }

        public static CompatProguardOptions parse(String[] args) {
            String output = null;
            int minApi = 1;
            boolean forceProguardCompatibility = false;
            boolean includeDataResources = true;
            boolean multiDex = false;
            String mainDexList = null;
            boolean printHelpAndExit = false;
            boolean disableVerticalClassMerging = false;
            boolean minimalMainDex = false;
            boolean coreLibrary = false;
            boolean noLocals = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (args.length > 0) {
                StringBuilder currentLine = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.charAt(0) == '-') {
                        if (arg.equals("-h") || arg.equals("--help")) {
                            printHelpAndExit = true;
                            continue;
                        }
                        if (arg.equals("--min-api")) {
                            minApi = Integer.valueOf(args[++i]);
                            continue;
                        }
                        if (arg.equals("--force-proguard-compatibility")) {
                            forceProguardCompatibility = true;
                            continue;
                        }
                        if (arg.equals("--no-data-resources")) {
                            includeDataResources = false;
                            continue;
                        }
                        if (arg.equals("--output")) {
                            output = args[++i];
                            continue;
                        }
                        if (arg.equals("--multi-dex")) {
                            multiDex = true;
                            continue;
                        }
                        if (arg.equals("--main-dex-list")) {
                            mainDexList = args[++i];
                            continue;
                        }
                        if (arg.startsWith("--main-dex-list=")) {
                            mainDexList = arg.substring("--main-dex-list=".length());
                            continue;
                        }
                        if (arg.equals("--no-vertical-class-merging")) {
                            disableVerticalClassMerging = true;
                            continue;
                        }
                        if (arg.equals("--minimal-main-dex")) {
                            minimalMainDex = true;
                            continue;
                        }
                        if (arg.equals("--core-library")) {
                            coreLibrary = true;
                            continue;
                        }
                        if (arg.equals("--no-locals")) {
                            noLocals = true;
                            continue;
                        }
                        if (arg.equals("-outjars")) {
                            throw new CompilationError("Proguard argument -outjar is not supported. Use R8 compatible --output flag");
                        }
                        if (currentLine.length() > 0) {
                            builder.add(currentLine.toString());
                        }
                        currentLine = new StringBuilder(arg);
                        continue;
                    }
                    if (currentLine.length() > 0) {
                        currentLine.append(' ');
                    }
                    currentLine.append(arg);
                }
                if (currentLine.length() > 0) {
                    builder.add(currentLine.toString());
                }
            }
            return new CompatProguardOptions((List<String>)((Object)builder.build()), output, minApi, multiDex, forceProguardCompatibility, includeDataResources, mainDexList, printHelpAndExit, disableVerticalClassMerging);
        }

        public static void print() {
            System.out.println("-h/--help            : print this help message");
            System.out.println("--min-api n          : specify the targeted min android api level");
            System.out.println("--main-dex-list list : specify main dex list for multi-dexing");
            System.out.println("--minimal-main-dex   : ignored (provided for compatibility)");
            System.out.println("--multi-dex          : ignored (provided for compatibility)");
            System.out.println("--no-locals          : ignored (provided for compatibility)");
            System.out.println("--core-library       : ignored (provided for compatibility)");
            System.out.println("--force-proguard-compatibility : Proguard compatibility mode");
            System.out.println("--no-data-resources  : ignore all data resources");
        }
    }
}

