/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Map;

class IdentifierMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final ProguardClassFilter adaptClassStrings;
    private final NamingLens lens;
    private final Object2BooleanMap<DexReference> identifierNameStrings;

    IdentifierMinifier(Enqueuer.AppInfoWithLiveness appInfo, ProguardClassFilter adaptClassStrings, NamingLens lens) {
        this.appInfo = appInfo;
        this.adaptClassStrings = adaptClassStrings;
        this.lens = lens;
        this.identifierNameStrings = appInfo.identifierNameStrings;
    }

    void run() {
        if (!this.adaptClassStrings.isEmpty()) {
            this.adaptClassStrings();
        }
        if (!this.identifierNameStrings.isEmpty()) {
            this.replaceIdentifierNameString();
        }
    }

    private void adaptClassStrings() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            if (!this.adaptClassStrings.matches(clazz.type)) continue;
            clazz.forEachField(this::adaptClassStringsInField);
            clazz.forEachMethod(this::adaptClassStringsInMethod);
        }
    }

    private void adaptClassStringsInField(DexEncodedField encodedField) {
        if (!encodedField.accessFlags.isStatic()) {
            return;
        }
        DexValue staticValue = encodedField.getStaticValue();
        if (!(staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)staticValue).getValue();
        DexString renamed = this.getRenamedStringLiteral(original);
        if (renamed != original) {
            encodedField.setStaticValue(new DexValue.DexValueString(renamed));
        }
    }

    private void adaptClassStringsInMethod(DexEncodedMethod encodedMethod) {
        if (encodedMethod.shouldNotHaveCode()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        if (code.isDexCode()) {
            DexCode dexCode = code.asDexCode();
            for (Instruction instr : dexCode.instructions) {
                DexString dexString;
                Instruction cnst;
                if (instr instanceof ConstString) {
                    cnst = (ConstString)instr;
                    dexString = ((ConstString)cnst).getString();
                    ((ConstString)cnst).BBBB = this.getRenamedStringLiteral(dexString);
                    continue;
                }
                if (!(instr instanceof ConstStringJumbo)) continue;
                cnst = (ConstStringJumbo)instr;
                dexString = ((ConstStringJumbo)cnst).getString();
                ((ConstStringJumbo)cnst).BBBBBBBB = this.getRenamedStringLiteral(dexString);
            }
        } else {
            assert (code.isCfCode());
            CfCode cfCode = code.asCfCode();
            for (CfInstruction instr : cfCode.getInstructions()) {
                if (!(instr instanceof CfConstString)) continue;
                CfConstString cnst = (CfConstString)instr;
                DexString dexString = cnst.getString();
                cnst.setString(this.getRenamedStringLiteral(dexString));
            }
        }
    }

    private DexString getRenamedStringLiteral(DexString originalLiteral) {
        DexString renamed;
        String originalString = originalLiteral.toString();
        Map<String, DexType> renamedYetMatchedTypes = this.lens.getRenamedItems(DexType.class, type -> type.toSourceString().equals(originalString), DexType::toSourceString);
        DexType type2 = renamedYetMatchedTypes.get(originalString);
        if (type2 != null && (renamed = this.lens.lookupDescriptor(type2)) != originalLiteral) {
            return this.appInfo.dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
        }
        return originalLiteral;
    }

    private void replaceIdentifierNameString() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            clazz.forEachField(this::replaceIdentifierNameStringInField);
            clazz.forEachMethod(this::replaceIdentifierNameStringInMethod);
        }
    }

    private void replaceIdentifierNameStringInField(DexEncodedField encodedField) {
        if (!encodedField.accessFlags.isStatic()) {
            return;
        }
        DexValue staticValue = encodedField.getStaticValue();
        if (!(staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)staticValue).getValue();
        if (original instanceof DexItemBasedString) {
            encodedField.setStaticValue(new DexValue.DexValueString(this.materialize((DexItemBasedString)original)));
        }
    }

    private void replaceIdentifierNameStringInMethod(DexEncodedMethod encodedMethod) {
        if (!encodedMethod.getOptimizationInfo().useIdentifierNameString()) {
            return;
        }
        if (encodedMethod.shouldNotHaveCode()) {
            return;
        }
        Code code = encodedMethod.getCode();
        if (code == null) {
            return;
        }
        if (code.isDexCode()) {
            DexCode dexCode = code.asDexCode();
            for (Instruction instr : dexCode.instructions) {
                DexItemBasedString itemBasedString;
                Instruction cnst;
                if (instr instanceof ConstString && ((ConstString)instr).getString() instanceof DexItemBasedString) {
                    cnst = (ConstString)instr;
                    itemBasedString = (DexItemBasedString)((ConstString)cnst).getString();
                    ((ConstString)cnst).BBBB = this.materialize(itemBasedString);
                    continue;
                }
                if (!(instr instanceof ConstStringJumbo) || !(((ConstStringJumbo)instr).getString() instanceof DexItemBasedString)) continue;
                cnst = (ConstStringJumbo)instr;
                itemBasedString = (DexItemBasedString)((ConstStringJumbo)cnst).getString();
                ((ConstStringJumbo)cnst).BBBBBBBB = this.materialize(itemBasedString);
            }
        } else {
            assert (code.isCfCode());
            CfCode cfCode = code.asCfCode();
            for (CfInstruction instr : cfCode.getInstructions()) {
                if (!(instr instanceof CfConstString) || !(((CfConstString)instr).getString() instanceof DexItemBasedString)) continue;
                CfConstString cnst = (CfConstString)instr;
                DexItemBasedString itemBasedString = (DexItemBasedString)cnst.getString();
                cnst.setString(this.materialize(itemBasedString));
            }
        }
    }

    private DexString materialize(DexItemBasedString itemBasedString) {
        if (itemBasedString.basedOn.isDexType()) {
            DexString renamed = this.lens.lookupDescriptor(itemBasedString.basedOn.asDexType());
            if (!renamed.toString().equals(itemBasedString.toString())) {
                return this.appInfo.dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
            }
            return renamed;
        }
        if (itemBasedString.basedOn.isDexMethod()) {
            return this.lens.lookupName(itemBasedString.basedOn.asDexMethod());
        }
        assert (itemBasedString.basedOn.isDexField());
        return this.lens.lookupName(itemBasedString.basedOn.asDexField());
    }
}

