/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardMemberRule;
import java.util.function.Predicate;

public class MemberValuePropagation {
    private final Enqueuer.AppInfoWithLiveness appInfo;

    public MemberValuePropagation(Enqueuer.AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
    }

    private ProguardMemberRuleLookup lookupMemberRule(DexItem item) {
        ProguardMemberRule rule = this.appInfo.noSideEffects.get(item);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_NO_SIDE_EFFECTS, rule);
        }
        rule = this.appInfo.assumedValues.get(item);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_VALUES, rule);
        }
        return null;
    }

    private Instruction constantReplacementFromProguardRule(ProguardMemberRule rule, IRCode code, Instruction instruction) {
        Instruction replacement = null;
        ValueType valueType = instruction.outValue().outType();
        if (rule != null && rule.hasReturnValue() && rule.getReturnValue().isSingleValue()) {
            Value value = code.createValue(valueType, instruction.getLocalInfo());
            assert (valueType != ValueType.OBJECT || rule.getReturnValue().isNull());
            replacement = new ConstNumber(value, rule.getReturnValue().getSingleValue());
        }
        if (replacement == null && rule != null && rule.hasReturnValue() && rule.getReturnValue().isField()) {
            DexField field = rule.getReturnValue().getField();
            assert (ValueType.fromDexType(field.type) == valueType);
            DexEncodedField staticField = this.appInfo.lookupStaticTarget(field.clazz, field);
            if (staticField != null) {
                Value value = code.createValue(valueType, instruction.getLocalInfo());
                replacement = staticField.getStaticValue().asConstInstruction(false, value);
            } else {
                throw new CompilationError(field.clazz.toSourceString() + "." + field.name.toString() + " used in assumevalues rule does not exist.");
            }
        }
        return replacement;
    }

    private void setValueRangeFromProguardRule(ProguardMemberRule rule, Value value) {
        if (rule.hasReturnValue() && rule.getReturnValue().isValueRange()) {
            assert (!rule.getReturnValue().isSingleValue());
            value.setValueRange(rule.getReturnValue().getValueRange());
        }
    }

    private void replaceInstructionFromProguardRule(RuleType ruleType, InstructionIterator iterator2, Instruction current, Instruction replacement) {
        if (ruleType == RuleType.ASSUME_NO_SIDE_EFFECTS) {
            iterator2.replaceCurrentInstruction(replacement);
        } else {
            if (current.outValue() != null) {
                assert (replacement.outValue() != null);
                current.outValue().replaceUsers(replacement.outValue());
            }
            replacement.setPosition(current.getPosition());
            iterator2.add(replacement);
        }
    }

    public void rewriteWithConstantValues(IRCode code, DexType callingContext, Predicate<DexEncodedMethod> isProcessedConcurrently) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            StaticPut staticPut;
            DexEncodedField target;
            DexField field;
            Instruction current = (Instruction)iterator2.next();
            if (current.isInvokeMethod()) {
                DexEncodedMethod target2;
                InvokeMethod invoke = current.asInvokeMethod();
                DexMethod invokedMethod = invoke.getInvokedMethod();
                DexType invokedHolder = invokedMethod.getHolder();
                if (!invokedHolder.isClassType()) continue;
                DexEncodedMethod definition = this.appInfo.lookup(invoke.getType(), invokedMethod, callingContext);
                boolean invokeReplaced = false;
                ProguardMemberRuleLookup lookup = this.lookupMemberRule(definition);
                if (lookup != null) {
                    if (!(lookup.type != RuleType.ASSUME_NO_SIDE_EFFECTS || invoke.outValue() != null && invoke.outValue().isUsed())) {
                        iterator2.remove();
                        invokeReplaced = true;
                    } else if (invoke.outValue() != null && invoke.outValue().isUsed()) {
                        Instruction replacement = this.constantReplacementFromProguardRule(lookup.rule, code, invoke);
                        if (replacement != null) {
                            this.replaceInstructionFromProguardRule(lookup.type, iterator2, current, replacement);
                            invokeReplaced = true;
                        } else {
                            this.setValueRangeFromProguardRule(lookup.rule, current.outValue());
                        }
                    }
                }
                if (invokeReplaced || invoke.outValue() == null || (target2 = invoke.lookupSingleTarget(this.appInfo, callingContext)) == null) continue;
                if (target2.getOptimizationInfo().neverReturnsNull() && invoke.outValue().canBeNull()) {
                    invoke.outValue().markNeverNull();
                }
                if (!target2.getOptimizationInfo().returnsConstant()) continue;
                long constant = target2.getOptimizationInfo().getReturnedConstant();
                ValueType valueType = invoke.outType();
                Value value = code.createValue(valueType, invoke.getLocalInfo());
                ConstNumber knownConstReturn = new ConstNumber(value, constant);
                invoke.outValue().replaceUsers(value);
                invoke.setOutValue(null);
                knownConstReturn.setPosition(invoke.getPosition());
                invoke.moveDebugValues(knownConstReturn);
                iterator2.add(knownConstReturn);
                continue;
            }
            if (current.isInstancePut()) {
                InstancePut instancePut = current.asInstancePut();
                field = instancePut.getField();
                target = this.appInfo.lookupInstanceTarget(field.getHolder(), field);
                if (target == null || this.isFieldRead(target, false) || !instancePut.object().isNeverNull()) continue;
                iterator2.remove();
                continue;
            }
            if (current.isStaticGet()) {
                DexEncodedMethod.TrivialInitializer info;
                DexClass holderDefinition;
                StaticGet staticGet = current.asStaticGet();
                field = staticGet.getField();
                target = this.appInfo.lookupStaticTarget(field.getHolder(), field);
                ProguardMemberRuleLookup lookup = null;
                if (target == null) continue;
                Instruction replacement = target.valueAsConstInstruction(this.appInfo, staticGet.dest());
                if (replacement == null && (lookup = this.lookupMemberRule(target)) != null) {
                    replacement = this.constantReplacementFromProguardRule(lookup.rule, code, staticGet);
                }
                if (replacement == null && lookup != null) {
                    this.setValueRangeFromProguardRule(lookup.rule, staticGet.dest());
                }
                if (replacement != null) {
                    if (lookup != null && lookup.type == RuleType.ASSUME_VALUES) {
                        this.replaceInstructionFromProguardRule(lookup.type, iterator2, current, replacement);
                        continue;
                    }
                    iterator2.replaceCurrentInstruction(replacement);
                    continue;
                }
                if (staticGet.dest() == null || (holderDefinition = this.appInfo.definitionFor(field.getHolder())) == null || !holderDefinition.accessFlags.isFinal() || this.appInfo.canTriggerStaticInitializer(field.getHolder(), true)) continue;
                Value outValue = staticGet.dest();
                DexEncodedMethod classInitializer = holderDefinition.getClassInitializer();
                if (classInitializer == null || isProcessedConcurrently.test(classInitializer) || (info = classInitializer.getOptimizationInfo().getTrivialInitializerInfo()) == null || ((DexEncodedMethod.TrivialInitializer.TrivialClassInitializer)info).field != field || this.appInfo.isPinned(field) || !outValue.canBeNull()) continue;
                outValue.markNeverNull();
                continue;
            }
            if (!current.isStaticPut() || (target = this.appInfo.lookupStaticTarget((field = (staticPut = current.asStaticPut()).getField()).getHolder(), field)) == null || this.isFieldRead(target, true)) continue;
            iterator2.remove();
        }
        assert (code.isConsistentSSA());
    }

    private boolean isFieldRead(DexEncodedField field, boolean isStatic) {
        if (this.appInfo.fieldsRead.contains(field.field) || this.appInfo.isPinned(field.field)) {
            return true;
        }
        DexClass holder = this.appInfo.definitionFor(field.field.clazz);
        return holder == null || holder.isLibraryClass();
    }

    private static class ProguardMemberRuleLookup {
        final RuleType type;
        final ProguardMemberRule rule;

        ProguardMemberRuleLookup(RuleType type, ProguardMemberRule rule) {
            this.type = type;
            this.rule = rule;
        }
    }

    private static enum RuleType {
        NONE,
        ASSUME_NO_SIDE_EFFECTS,
        ASSUME_VALUES;

    }
}

