/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format31t;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;

public class PackedSwitch
extends Format31t {
    public static final int OPCODE = 43;
    public static final String NAME = "PackedSwitch";
    public static final String SMALI_NAME = "packed-switch";

    PackedSwitch(int high, BytecodeStream stream) {
        super(high, stream);
    }

    public PackedSwitch(int valueRegister) {
        super(valueRegister, -1);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 43;
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder) {
        int offset = this.getOffset();
        int payloadOffset = offset + this.getPayloadOffset();
        int fallthroughOffset = offset + this.getSize();
        builder.resolveAndBuildSwitch(this.AA, fallthroughOffset, payloadOffset);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", :label_" + (this.getOffset() + this.BBBBBBBB));
    }
}

