/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.naming.signature.GenericSignatureAction;
import com.android.tools.r8.naming.signature.GenericSignatureParser;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.Timing;
import java.lang.reflect.GenericSignatureFormatError;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class ClassNameMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final Reporter reporter;
    private final InternalOptions.PackageObfuscationMode packageObfuscationMode;
    private final boolean isAccessModificationAllowed;
    private final Set<String> noObfuscationPrefixes = Sets.newHashSet();
    private final Set<String> usedPackagePrefixes = Sets.newHashSet();
    private final Set<DexString> usedTypeNames = Sets.newIdentityHashSet();
    private final Map<DexType, DexString> renaming = Maps.newIdentityHashMap();
    private final Map<String, Namespace> states = new HashMap<String, Namespace>();
    private final ImmutableList<String> packageDictionary;
    private final ImmutableList<String> classDictionary;
    private final boolean keepInnerClassStructure;
    private final Set<DexType> noObfuscationTypes;
    private final Set<DexType> keepPackageName;
    private final Namespace topLevelState;
    private final GenericSignatureRewriter genericSignatureRewriter = new GenericSignatureRewriter();
    private final GenericSignatureParser<DexType> genericSignatureParser = new GenericSignatureParser<DexType>(this.genericSignatureRewriter);

    ClassNameMinifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        this.appInfo = appInfo;
        this.reporter = options.reporter;
        this.packageObfuscationMode = options.proguardConfiguration.getPackageObfuscationMode();
        this.isAccessModificationAllowed = options.proguardConfiguration.isAccessModificationAllowed();
        this.packageDictionary = options.proguardConfiguration.getPackageObfuscationDictionary();
        this.classDictionary = options.proguardConfiguration.getClassObfuscationDictionary();
        this.keepInnerClassStructure = options.proguardConfiguration.getKeepAttributes().signature;
        this.noObfuscationTypes = DexReference.filterDexType(DexDefinition.mapToReference(rootSet.noObfuscation.stream())).collect(Collectors.toSet());
        this.keepPackageName = DexReference.filterDexType(DexDefinition.mapToReference(rootSet.keepPackageName.stream())).collect(Collectors.toSet());
        this.topLevelState = new Namespace(DescriptorUtils.getPackageBinaryNameFromJavaType(options.proguardConfiguration.getPackagePrefix()));
        this.states.computeIfAbsent("", k -> this.topLevelState);
    }

    ClassRenaming computeRenaming(Timing timing) {
        Iterable<DexProgramClass> classes = this.appInfo.classesWithDeterministicOrder();
        timing.begin("reserve");
        for (DexClass dexClass : classes) {
            if (!this.noObfuscationTypes.contains(dexClass.type)) continue;
            assert (!this.renaming.containsKey(dexClass.type));
            this.registerClassAsUsed(dexClass.type);
        }
        timing.end();
        timing.begin("rename-classes");
        for (DexClass dexClass : classes) {
            if (this.renaming.containsKey(dexClass.type)) continue;
            dexClass.annotations = dexClass.annotations.keepIf(this::isNotKotlinMetadata);
            DexString renamed = this.computeName(dexClass.type);
            this.renaming.put(dexClass.type, renamed);
        }
        timing.end();
        timing.begin("rename-dangling-types");
        for (DexClass dexClass : classes) {
            this.renameDanglingTypes(dexClass);
        }
        timing.end();
        timing.begin("rename-generic");
        this.renameTypesInGenericSignatures();
        timing.end();
        timing.begin("rename-arrays");
        this.appInfo.dexItemFactory.forAllTypes(this::renameArrayTypeIfNeeded);
        timing.end();
        return new ClassRenaming(Collections.unmodifiableMap(this.renaming), this.getPackageRenaming());
    }

    private Map<String, String> getPackageRenaming() {
        ImmutableMap.Builder<String, String> packageRenaming = ImmutableMap.builder();
        for (Map.Entry<String, Namespace> entry : this.states.entrySet()) {
            String originalPackageName = entry.getKey();
            String minifiedPackageName = entry.getValue().getPackageName();
            if (minifiedPackageName.equals(originalPackageName)) continue;
            packageRenaming.put(originalPackageName, minifiedPackageName);
        }
        return packageRenaming.build();
    }

    private void renameDanglingTypes(DexClass clazz) {
        clazz.forEachMethod(this::renameDanglingTypesInMethod);
        clazz.forEachField(this::renameDanglingTypesInField);
    }

    private void renameDanglingTypesInField(DexEncodedField field) {
        this.renameDanglingType(field.field.type);
    }

    private void renameDanglingTypesInMethod(DexEncodedMethod method) {
        DexProto proto = method.method.proto;
        this.renameDanglingType(proto.returnType);
        for (DexType type : proto.parameters.values) {
            this.renameDanglingType(type);
        }
    }

    private void renameDanglingType(DexType type) {
        if (this.appInfo.wasPruned(type) && !this.renaming.containsKey(type) && !this.noObfuscationTypes.contains(type)) {
            assert (this.appInfo.definitionFor(type) == null);
            this.renaming.put(type, this.topLevelState.nextTypeName());
        }
    }

    private void parseError(DexDefinition item, Origin origin, GenericSignatureFormatError e) {
        StringBuilder message = new StringBuilder("Invalid signature for ");
        if (item.isDexClass()) {
            message.append("class ");
            message.append(item.asDexClass().getType().toSourceString());
        } else if (item.isDexEncodedField()) {
            message.append("field ");
            message.append(item.toSourceString());
        } else {
            assert (item.isDexEncodedMethod());
            message.append("method ");
            message.append(item.toSourceString());
        }
        message.append(".\n");
        message.append(e.getMessage());
        this.reporter.warning(new StringDiagnostic(message.toString(), origin));
    }

    private void renameTypesInGenericSignatures() {
        for (DexClass dexClass : this.appInfo.classes()) {
            dexClass.annotations = this.rewriteGenericSignatures(dexClass.annotations, this.genericSignatureParser::parseClassSignature, e -> this.parseError(clazz, clazz.getOrigin(), (GenericSignatureFormatError)e));
            dexClass.forEachField(field -> {
                field.annotations = this.rewriteGenericSignatures(field.annotations, this.genericSignatureParser::parseFieldSignature, e -> this.parseError((DexDefinition)field, clazz.getOrigin(), (GenericSignatureFormatError)e));
            });
            dexClass.forEachMethod(method -> {
                method.annotations = this.rewriteGenericSignatures(method.annotations, this.genericSignatureParser::parseMethodSignature, e -> this.parseError((DexDefinition)method, clazz.getOrigin(), (GenericSignatureFormatError)e));
            });
        }
    }

    private DexAnnotationSet rewriteGenericSignatures(DexAnnotationSet annotations, Consumer<String> parser, Consumer<GenericSignatureFormatError> parseError) {
        int VALID = -1;
        int invalid = -1;
        for (int i = 0; i < annotations.annotations.length && invalid == -1; ++i) {
            DexAnnotation annotation = annotations.annotations[i];
            if (!DexAnnotation.isSignatureAnnotation(annotation, this.appInfo.dexItemFactory)) continue;
            try {
                parser.accept(DexAnnotation.getSignature(annotation));
                annotations.annotations[i] = DexAnnotation.createSignatureAnnotation(this.genericSignatureRewriter.getRenamedSignature(), this.appInfo.dexItemFactory);
                continue;
            }
            catch (GenericSignatureFormatError e) {
                parseError.accept(e);
                invalid = i;
            }
        }
        if (invalid == -1) {
            return annotations;
        }
        DexAnnotation[] prunedAnnotations = new DexAnnotation[annotations.annotations.length - 1];
        int dest = 0;
        for (int i = 0; i < annotations.annotations.length; ++i) {
            if (i == invalid) continue;
            prunedAnnotations[dest++] = annotations.annotations[i];
        }
        assert (dest == prunedAnnotations.length);
        return new DexAnnotationSet(prunedAnnotations);
    }

    private void registerClassAsUsed(DexType type) {
        DexType outerClass;
        this.renaming.put(type, type.descriptor);
        this.registerPackagePrefixesAsUsed(ClassNameMinifier.getParentPackagePrefix(DescriptorUtils.getClassBinaryNameFromDescriptor(type.descriptor.toSourceString())));
        this.usedTypeNames.add(type.descriptor);
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null && !this.renaming.containsKey(outerClass) && !this.noObfuscationTypes.contains(outerClass)) {
            this.registerClassAsUsed(outerClass);
        }
    }

    private void registerPackagePrefixesAsUsed(String packagePrefix) {
        if (!this.isAccessModificationAllowed) {
            this.noObfuscationPrefixes.add(packagePrefix);
        }
        String usedPrefix = packagePrefix;
        while (usedPrefix.length() > 0) {
            this.usedPackagePrefixes.add(usedPrefix);
            usedPrefix = ClassNameMinifier.getParentPackagePrefix(usedPrefix);
        }
    }

    private DexType getOutClassForType(DexType type) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return null;
        }
        if (clazz.getEnclosingMethod() != null) {
            return null;
        }
        for (InnerClassAttribute innerClassAttribute : clazz.getInnerClasses()) {
            if (innerClassAttribute.getInner() != type) continue;
            return innerClassAttribute.getOuter();
        }
        return null;
    }

    private DexString computeName(DexType type) {
        DexType outerClass;
        Namespace state = null;
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null) {
            state = this.getStateForOuterClass(outerClass);
        }
        if (state == null) {
            state = this.getStateForClass(type);
        }
        return state.nextTypeName();
    }

    private Namespace getStateForClass(DexType type) {
        String packageName = DescriptorUtils.getPackageBinaryNameFromJavaType(type.getPackageDescriptor());
        if (this.keepPackageName.contains(type) || this.noObfuscationPrefixes.contains(packageName)) {
            return this.states.computeIfAbsent(packageName, x$0 -> new Namespace((String)x$0));
        }
        Namespace state = this.topLevelState;
        switch (this.packageObfuscationMode) {
            case NONE: {
                state = this.getStateForPackagePrefix(packageName);
                break;
            }
            case REPACKAGE: {
                state = this.topLevelState;
                break;
            }
            case FLATTEN: {
                state = this.states.computeIfAbsent(packageName, k -> {
                    String renamedPackagePrefix = this.topLevelState.nextPackagePrefix();
                    return new Namespace(renamedPackagePrefix);
                });
            }
        }
        return state;
    }

    private Namespace getStateForPackagePrefix(String prefix) {
        Namespace state = this.states.get(prefix);
        if (state == null) {
            String parentPackage = ClassNameMinifier.getParentPackagePrefix(prefix);
            Namespace superState = this.noObfuscationPrefixes.contains(parentPackage) ? this.states.computeIfAbsent(parentPackage, x$0 -> new Namespace((String)x$0)) : this.getStateForPackagePrefix(parentPackage);
            String renamedPackagePrefix = superState.nextPackagePrefix();
            state = new Namespace(renamedPackagePrefix);
            this.states.put(prefix, state);
        }
        return state;
    }

    private Namespace getStateForOuterClass(DexType outer) {
        String prefix = DescriptorUtils.getClassBinaryNameFromDescriptor(outer.toDescriptorString());
        Namespace state = this.states.get(prefix);
        if (state == null) {
            DexString renamed = this.renaming.get(outer);
            if (renamed == null) {
                renamed = this.computeName(outer);
                this.renaming.put(outer, renamed);
            }
            String binaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamed.toString());
            state = new Namespace(binaryName, "$");
            this.states.put(prefix, state);
        }
        return state;
    }

    private void renameArrayTypeIfNeeded(DexType type) {
        DexType base;
        DexString value;
        if (type.isArrayType() && (value = this.renaming.get(base = type.toBaseType(this.appInfo.dexItemFactory))) != null) {
            int dimensions = type.descriptor.numberOfLeadingSquareBrackets();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                builder.append('[');
            }
            builder.append(value.toString());
            DexString descriptor = this.appInfo.dexItemFactory.createString(builder.toString());
            this.renaming.put(type, descriptor);
        }
    }

    static String getParentPackagePrefix(String packagePrefix) {
        int i = packagePrefix.lastIndexOf(47);
        if (i < 0) {
            return "";
        }
        return packagePrefix.substring(0, i);
    }

    private boolean isNotKotlinMetadata(DexAnnotation annotation) {
        return annotation.annotation.type != this.appInfo.dexItemFactory.kotlin.metadata.kotlinMetadataType;
    }

    private class GenericSignatureRewriter
    implements GenericSignatureAction<DexType> {
        private StringBuilder renamedSignature;

        private GenericSignatureRewriter() {
        }

        public String getRenamedSignature() {
            return this.renamedSignature.toString();
        }

        @Override
        public void parsedSymbol(char symbol) {
            this.renamedSignature.append(symbol);
        }

        @Override
        public void parsedIdentifier(String identifier) {
            this.renamedSignature.append(identifier);
        }

        @Override
        public DexType parsedTypeName(String name) {
            DexType type = ((ClassNameMinifier)ClassNameMinifier.this).appInfo.dexItemFactory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(name));
            DexString renamedDescriptor = ClassNameMinifier.this.renaming.getOrDefault(type, type.descriptor);
            this.renamedSignature.append(DescriptorUtils.getClassBinaryNameFromDescriptor(renamedDescriptor.toString()));
            return type;
        }

        @Override
        public DexType parsedInnerTypeName(DexType enclosingType, String name) {
            assert (enclosingType.isClassType());
            String enclosingDescriptor = enclosingType.toDescriptorString();
            DexType type = ((ClassNameMinifier)ClassNameMinifier.this).appInfo.dexItemFactory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(enclosingDescriptor) + '$' + name));
            String enclosingRenamedBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(ClassNameMinifier.this.renaming.getOrDefault(enclosingType, enclosingType.descriptor).toString());
            DexString renamedDescriptor = (DexString)ClassNameMinifier.this.renaming.get(type);
            if (renamedDescriptor != null) {
                String fullRenamedBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamedDescriptor.toString());
                this.renamedSignature.append(fullRenamedBinaryName.substring(enclosingRenamedBinaryName.length() + 1));
            } else {
                this.renamedSignature.append(name);
            }
            return type;
        }

        @Override
        public void start() {
            this.renamedSignature = new StringBuilder();
        }

        @Override
        public void stop() {
        }
    }

    private class Namespace {
        private final String packageName;
        private final char[] packagePrefix;
        private int typeCounter = 1;
        private int packageCounter = 1;
        private final Iterator<String> packageDictionaryIterator;
        private final Iterator<String> classDictionaryIterator;

        Namespace(String packageName) {
            this(packageName, "/");
        }

        Namespace(String packageName, String separator) {
            this.packageName = packageName;
            this.packagePrefix = ("L" + packageName + (packageName.isEmpty() ? "" : separator)).toCharArray();
            this.packageDictionaryIterator = ClassNameMinifier.this.packageDictionary.iterator();
            this.classDictionaryIterator = ClassNameMinifier.this.classDictionary.iterator();
        }

        public String getPackageName() {
            return this.packageName;
        }

        private String nextSuggestedNameForClass() {
            StringBuilder nextName = new StringBuilder();
            if (this.classDictionaryIterator.hasNext()) {
                nextName.append(this.packagePrefix).append(this.classDictionaryIterator.next()).append(';');
                return nextName.toString();
            }
            return StringUtils.numberToIdentifier(this.packagePrefix, this.typeCounter++, true);
        }

        DexString nextTypeName() {
            DexString candidate;
            do {
                candidate = ((ClassNameMinifier)ClassNameMinifier.this).appInfo.dexItemFactory.createString(this.nextSuggestedNameForClass());
            } while (ClassNameMinifier.this.usedTypeNames.contains(candidate));
            ClassNameMinifier.this.usedTypeNames.add(candidate);
            return candidate;
        }

        private String nextSuggestedNameForSubpackage() {
            StringBuilder nextName = new StringBuilder();
            if (this.packageDictionaryIterator.hasNext()) {
                nextName.append(this.packagePrefix).append(this.packageDictionaryIterator.next());
            } else {
                nextName.append(StringUtils.numberToIdentifier(this.packagePrefix, this.packageCounter++, false));
            }
            return nextName.toString().substring(1);
        }

        String nextPackagePrefix() {
            String candidate;
            do {
                candidate = this.nextSuggestedNameForSubpackage();
            } while (ClassNameMinifier.this.usedPackagePrefixes.contains(candidate));
            ClassNameMinifier.this.usedPackagePrefixes.add(candidate);
            return candidate;
        }
    }

    static class ClassRenaming {
        protected final Map<String, String> packageRenaming;
        protected final Map<DexType, DexString> classRenaming;

        private ClassRenaming(Map<DexType, DexString> classRenaming, Map<String, String> packageRenaming) {
            this.classRenaming = classRenaming;
            this.packageRenaming = packageRenaming;
        }
    }
}

