/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.com.google.common.collect.UnmodifiableIterator;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.FileUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReadMainDexList {
    private static final String DOT_CLASS = ".class";

    private String stripDotClass(String name) {
        return name.endsWith(DOT_CLASS) ? name.substring(0, name.length() - DOT_CLASS.length()) : name;
    }

    private String toClassFilePath(String name) {
        return name.replace('.', '/') + DOT_CLASS;
    }

    private String toKeepRule(String className) {
        return "-keep class " + className + " {}";
    }

    private String deobfuscateClassName(String name, ClassNameMapper mapper) {
        if (mapper == null) {
            return name;
        }
        return mapper.deobfuscateClassName(name);
    }

    private void run(String[] args) throws Exception {
        Function<String, String> outputGenerator;
        UnmodifiableIterator<String> arguments;
        String arg;
        if (args.length < 1 || args.length > 3) {
            System.out.println("Usage: command [-k] <main_dex_list> [<proguard_map>]");
            System.exit(0);
        }
        if ((arg = (String)(arguments = Iterators.forArray(args)).next()).equals("-k")) {
            outputGenerator = this::toKeepRule;
            arg = (String)arguments.next();
        } else {
            outputGenerator = this::toClassFilePath;
        }
        Path mainDexList = Paths.get(arg, new String[0]);
        ClassNameMapper mapper = arguments.hasNext() ? ClassNameMapper.mapperFromFile(Paths.get((String)arguments.next(), new String[0])) : null;
        FileUtils.readAllLines(mainDexList).stream().map(this::stripDotClass).map(name -> name.replace('/', '.')).map(name -> this.deobfuscateClassName((String)name, mapper)).map(outputGenerator).sorted().collect(Collectors.toList()).forEach(System.out::println);
    }

    public static void main(String[] args) throws Exception {
        new ReadMainDexList().run(args);
    }
}

