/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ArrayTypeLatticeElement
extends ReferenceTypeLatticeElement {
    ArrayTypeLatticeElement(DexType type, boolean isNullable) {
        super(type, isNullable);
        assert (type.isArrayType());
    }

    public DexType getArrayType() {
        return this.type;
    }

    public int getNesting() {
        return this.type.getNumberOfLeadingSquareBrackets();
    }

    public DexType getArrayElementType(DexItemFactory factory) {
        return this.type.toArrayElementType(factory);
    }

    public DexType getArrayBaseType(DexItemFactory factory) {
        return this.type.toBaseType(factory);
    }

    @Override
    TypeLatticeElement asNullable() {
        return this.isNullable() ? this : new ArrayTypeLatticeElement(this.type, true);
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return this.isNullable() ? new ArrayTypeLatticeElement(this.type, false) : this;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return this;
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return ArrayTypeLatticeElement.fromDexType(appInfo, this.getArrayElementType(appInfo.dexItemFactory), true);
    }

    @Override
    public String toString() {
        return this.isNullableString() + this.type.toString();
    }
}

