/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfIf
extends CfInstruction {
    private final If.Type kind;
    private final ValueType type;
    private final CfLabel target;

    public CfIf(If.Type kind, ValueType type, CfLabel target) {
        this.kind = kind;
        this.type = type;
        this.target = target;
    }

    public ValueType getType() {
        return this.type;
    }

    public If.Type getKind() {
        return this.kind;
    }

    @Override
    public CfLabel getTarget() {
        return this.target;
    }

    public int getOpcode() {
        switch (this.kind) {
            case EQ: {
                return this.type.isObject() ? 198 : 153;
            }
            case GE: {
                return 156;
            }
            case GT: {
                return 157;
            }
            case LE: {
                return 158;
            }
            case LT: {
                return 155;
            }
            case NE: {
                return this.type.isObject() ? 199 : 154;
            }
        }
        throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitJumpInsn(this.getOpcode(), this.target.getLabel());
    }

    @Override
    public boolean isConditionalJump() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int value = state.pop().register;
        int trueTargetOffset = code.getLabelOffset(this.target);
        int falseTargetOffset = code.getCurrentInstructionIndex() + 1;
        builder.addIfZero(this.kind, this.type, value, trueTargetOffset, falseTargetOffset);
    }
}

