/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.desugaring;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class TypePaths {
    private final Map<Path, Set<String>> pathToTypes = Maps.newHashMap();
    private final Map<String, Set<Path>> typeToPaths = Maps.newHashMap();
    boolean isReverseMappingValid = false;

    TypePaths() {
    }

    void add(Path path, String internalName) {
        Set<String> types = this.pathToTypes.getOrDefault(path, TypePaths.getNewSetForPath(path));
        types.add(internalName);
        this.pathToTypes.put(path, types);
        this.invalidateReverseMapping();
    }

    Set<String> getTypes(Path path) {
        return this.pathToTypes.getOrDefault(path, (Set<String>)ImmutableSet.of());
    }

    Set<String> remove(Path path, Set<Path> removedPaths) {
        Set<String> allInPath = this.pathToTypes.remove(path);
        if (allInPath == null) {
            return ImmutableSet.of();
        }
        this.invalidateReverseMapping();
        HashSet<String> toRemove = new HashSet<String>(allInPath.size());
        for (String type : allInPath) {
            Set<Path> definedInPaths = this.getPaths(type);
            if (!Sets.difference(definedInPaths, removedPaths).isEmpty()) continue;
            toRemove.add(type);
        }
        return toRemove;
    }

    Set<Path> getPaths(String internalName) {
        return this.reverseMapping().getOrDefault(internalName, (Set<Path>)ImmutableSet.of());
    }

    private void invalidateReverseMapping() {
        this.isReverseMappingValid = false;
    }

    private Map<String, Set<Path>> reverseMapping() {
        if (this.isReverseMappingValid) {
            return this.typeToPaths;
        }
        this.typeToPaths.clear();
        for (Map.Entry<Path, Set<String>> pathToType : this.pathToTypes.entrySet()) {
            for (String type : pathToType.getValue()) {
                Set<Path> paths = this.typeToPaths.getOrDefault(type, Sets.newHashSetWithExpectedSize((int)1));
                paths.add(pathToType.getKey());
                this.typeToPaths.put(type, paths);
            }
        }
        this.isReverseMappingValid = true;
        return this.typeToPaths;
    }

    private static Set<String> getNewSetForPath(Path path) {
        if (path.toString().endsWith(".class")) {
            return Sets.newHashSetWithExpectedSize((int)1);
        }
        return Sets.newHashSet();
    }
}

