/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.JarCode;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.ir.synthetic.AbstractSynthesizedCode;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.VerticalClassMergerGraphLense;
import com.android.tools.r8.utils.FieldSignatureEquivalence;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class VerticalClassMerger {
    private final DexApplication application;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final ExecutorService executorService;
    private final GraphLense graphLense;
    private final MethodPoolCollection methodPoolCollection;
    private final InternalOptions options;
    private final Timing timing;
    private Collection<DexMethod> invokes;
    private final Set<DexProgramClass> mergeCandidates = new LinkedHashSet<DexProgramClass>();
    private final Map<DexType, DexType> mergedClasses = new HashMap<DexType, DexType>();
    private final Map<DexType, Set<DexType>> mergedClassesInverse = new HashMap<DexType, Set<DexType>>();
    private final Set<DexType> pinnedTypes = new HashSet<DexType>();
    private final VerticalClassMergerGraphLense.Builder renamedMembersLense;
    private final List<SynthesizedBridgeCode> synthesizedBridges = new ArrayList<SynthesizedBridgeCode>();

    public VerticalClassMerger(DexApplication application, AppView<Enqueuer.AppInfoWithLiveness> appView, ExecutorService executorService, InternalOptions options, Timing timing) {
        this.application = application;
        this.appInfo = appView.appInfo();
        this.executorService = executorService;
        this.graphLense = appView.graphLense();
        this.methodPoolCollection = new MethodPoolCollection(application);
        this.options = options;
        this.renamedMembersLense = new VerticalClassMergerGraphLense.Builder();
        this.timing = timing;
        Iterable<DexProgramClass> classes = application.classesWithDeterministicOrder();
        this.initializePinnedTypes(classes);
        this.initializeMergeCandidates(classes);
    }

    public VerticallyMergedClasses getMergedClasses() {
        return new VerticallyMergedClasses(this.mergedClasses);
    }

    private void initializeMergeCandidates(Iterable<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            if (!this.isMergeCandidate(clazz, this.pinnedTypes) || !this.isStillMergeCandidate(clazz)) continue;
            this.mergeCandidates.add(clazz);
        }
    }

    private void initializePinnedTypes(Iterable<DexProgramClass> classes) {
        this.extractPinnedItems(this.appInfo.pinnedItems, AbortReason.PINNED_SOURCE);
        this.extractPinnedItems(this.appInfo.alwaysInline, AbortReason.ALWAYS_INLINE);
        this.extractPinnedItems(DexDefinition.mapToReference(this.appInfo.noSideEffects.keySet().stream())::iterator, AbortReason.NO_SIDE_EFFECTS);
        for (DexProgramClass clazz : classes) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (!method.accessFlags.isNative()) continue;
                this.markTypeAsPinned(clazz.type, AbortReason.NATIVE_METHOD);
            }
        }
        for (DexMethod signature : this.appInfo.brokenSuperInvokes) {
            this.markTypeAsPinned(signature.holder, AbortReason.UNHANDLED_INVOKE_SUPER);
        }
        for (DexMethod signature : this.appInfo.virtualMethodsTargetedByInvokeDirect) {
            this.markTypeAsPinned(signature.holder, AbortReason.UNHANDLED_INVOKE_DIRECT);
        }
    }

    private <T extends DexReference> void extractPinnedItems(Iterable<T> items, AbortReason reason) {
        for (DexReference item : items) {
            if (item.isDexType()) {
                this.markTypeAsPinned(item.asDexType(), reason);
                continue;
            }
            if (item.isDexField()) {
                DexField field = item.asDexField();
                this.markTypeAsPinned(field.clazz, reason);
                this.markTypeAsPinned(field.type, reason);
                continue;
            }
            assert (item.isDexMethod());
            DexMethod method = item.asDexMethod();
            this.markTypeAsPinned(method.holder, reason);
            this.markTypeAsPinned(method.proto.returnType, reason);
            for (DexType parameterType : method.proto.parameters.values) {
                this.markTypeAsPinned(parameterType, reason);
            }
        }
    }

    private void markTypeAsPinned(DexType type, AbortReason reason) {
        if (this.appInfo.isPinned(type)) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz != null && clazz.isProgramClass()) {
            boolean bl = this.pinnedTypes.add(type);
        }
    }

    private boolean isMergeCandidate(DexProgramClass clazz, Set<DexType> pinnedTypes) {
        if (this.appInfo.instantiatedTypes.contains(clazz.type) || this.appInfo.instantiatedLambdas.contains(clazz.type) || this.appInfo.isPinned(clazz.type) || pinnedTypes.contains(clazz.type)) {
            return false;
        }
        DexType singleSubtype = clazz.type.getSingleSubtype();
        if (singleSubtype == null) {
            return false;
        }
        for (DexEncodedField field : clazz.fields()) {
            if (!this.appInfo.isPinned(field.field)) continue;
            return false;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (this.appInfo.isPinned(method.method)) {
                return false;
            }
            if (!method.isInstanceInitializer() || !this.disallowInlining(method, singleSubtype)) continue;
            return false;
        }
        return clazz.getEnclosingMethod() == null && clazz.getInnerClasses().isEmpty();
    }

    private boolean isStillMergeCandidate(DexProgramClass clazz) {
        assert (this.isMergeCandidate(clazz, this.pinnedTypes));
        if (this.mergedClassesInverse.containsKey(clazz.type)) {
            return false;
        }
        DexClass targetClass = this.appInfo.definitionFor(clazz.type.getSingleSubtype());
        if (clazz.hasClassInitializer() && targetClass.hasClassInitializer()) {
            return false;
        }
        if (targetClass.getEnclosingMethod() != null || !targetClass.getInnerClasses().isEmpty()) {
            return false;
        }
        if (this.mergeMayLeadToIllegalAccesses(clazz, targetClass)) {
            return false;
        }
        if (this.methodResolutionMayChange(clazz, targetClass)) {
            return false;
        }
        return !this.fieldResolutionMayChange(clazz, targetClass);
    }

    private boolean mergeMayLeadToIllegalAccesses(DexClass source, DexClass target) {
        if (source.type.isSamePackage(target.type)) {
            int accessLevel;
            int n = source.accessFlags.isPrivate() ? 0 : (accessLevel = source.accessFlags.isPublic() ? 2 : 1);
            int otherAccessLevel = target.accessFlags.isPrivate() ? 0 : (target.accessFlags.isPublic() ? 2 : 1);
            return accessLevel > otherAccessLevel;
        }
        if (!target.accessFlags.isPublic()) {
            return true;
        }
        for (DexEncodedField field : source.fields()) {
            if (field.accessFlags.isPublic() || field.accessFlags.isPrivate()) continue;
            return true;
        }
        for (DexEncodedMethod method : source.methods()) {
            if (method.accessFlags.isPublic() || method.accessFlags.isPrivate()) continue;
            return true;
        }
        IllegalAccessDetector registry = new IllegalAccessDetector(this.options.itemFactory, source);
        for (DexEncodedMethod method : source.methods()) {
            method.registerCodeReferences(registry);
            if (!registry.foundIllegalAccess()) continue;
            return true;
        }
        return false;
    }

    private Collection<DexMethod> getInvokes() {
        if (this.invokes == null) {
            this.invokes = new OverloadedMethodSignaturesRetriever().get();
        }
        return this.invokes;
    }

    public GraphLense run() throws ExecutionException {
        this.timing.begin("merge");
        GraphLense mergingGraphLense = this.mergeClasses(this.graphLense);
        this.timing.end();
        this.timing.begin("fixup");
        GraphLense result = new TreeFixer().fixupTypeReferences(mergingGraphLense);
        this.timing.end();
        assert (result.assertDefinitionNotModified(this.appInfo.alwaysInline.stream().map(this.appInfo::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        assert (result.assertDefinitionNotModified(this.appInfo.noSideEffects.keySet()));
        return result;
    }

    private void addCandidateAncestorsToWorklist(DexProgramClass clazz, Deque<DexProgramClass> worklist, Set<DexProgramClass> seenBefore) {
        DexClass definition;
        if (seenBefore.contains(clazz)) {
            return;
        }
        if (this.mergeCandidates.contains(clazz)) {
            worklist.addFirst(clazz);
        }
        if (clazz.superType != null && (definition = this.appInfo.definitionFor(clazz.superType)) != null && definition.isProgramClass()) {
            this.addCandidateAncestorsToWorklist(definition.asProgramClass(), worklist, seenBefore);
        }
        for (DexType interfaceType : clazz.interfaces.values) {
            DexClass definition2 = this.appInfo.definitionFor(interfaceType);
            if (definition2 == null || !definition2.isProgramClass()) continue;
            this.addCandidateAncestorsToWorklist(definition2.asProgramClass(), worklist, seenBefore);
        }
    }

    private GraphLense mergeClasses(GraphLense graphLense) throws ExecutionException {
        ArrayDeque<DexProgramClass> worklist = new ArrayDeque<DexProgramClass>();
        HashSet<DexProgramClass> seenBefore = new HashSet<DexProgramClass>();
        boolean numberOfMerges = false;
        Iterator<DexProgramClass> candidatesIterator = this.mergeCandidates.iterator();
        while (candidatesIterator.hasNext() || !worklist.isEmpty()) {
            ClassMerger merger;
            boolean merged;
            boolean clazzOrTargetClassHasBeenMerged;
            if (worklist.isEmpty()) {
                this.addCandidateAncestorsToWorklist(candidatesIterator.next(), worklist, seenBefore);
                if (worklist.isEmpty()) continue;
            }
            DexProgramClass clazz = (DexProgramClass)worklist.removeFirst();
            assert (this.isMergeCandidate(clazz, this.pinnedTypes));
            if (!seenBefore.add(clazz)) continue;
            DexProgramClass targetClass = this.appInfo.definitionFor(clazz.type.getSingleSubtype()).asProgramClass();
            assert (!this.mergedClasses.containsKey(targetClass.type));
            boolean bl = clazzOrTargetClassHasBeenMerged = this.mergedClassesInverse.containsKey(clazz.type) || this.mergedClassesInverse.containsKey(targetClass.type);
            if (clazzOrTargetClassHasBeenMerged) {
                if (!this.isStillMergeCandidate(clazz)) {
                    continue;
                }
            } else assert (this.isStillMergeCandidate(clazz));
            if (new CollisionDetector(clazz.type, targetClass.type).mayCollide() || !(merged = (merger = new ClassMerger(clazz, targetClass)).merge())) continue;
            this.renamedMembersLense.merge(merger.getRenamings());
            this.synthesizedBridges.addAll(merger.getSynthesizedBridges());
        }
        return this.renamedMembersLense.build(graphLense, this.mergedClasses, this.synthesizedBridges, this.appInfo);
    }

    private boolean methodResolutionMayChange(DexClass source, DexClass target) {
        for (DexEncodedMethod virtualSourceMethod : source.virtualMethods()) {
            DexEncodedMethod directTargetMethod = target.lookupDirectMethod(virtualSourceMethod.method);
            if (directTargetMethod == null) continue;
            return true;
        }
        if (source.isInterface() && !target.isInterface()) {
            ArrayList<DexEncodedMethod> defaultMethods = new ArrayList<DexEncodedMethod>();
            for (DexEncodedMethod virtualMethod : source.virtualMethods()) {
                if (virtualMethod.accessFlags.isAbstract()) continue;
                defaultMethods.add(virtualMethod);
            }
            for (DexEncodedMethod method : defaultMethods) {
                Set<DexEncodedMethod> interfaceTargets = this.appInfo.lookupInterfaceTargets(method.method);
                if (!interfaceTargets.remove(method)) continue;
                for (DexEncodedMethod interfaceTarget : interfaceTargets) {
                    DexClass enclosingClass = this.appInfo.definitionFor(interfaceTarget.method.holder);
                    if (enclosingClass == null || !enclosingClass.isInterface()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean fieldResolutionMayChange(DexClass source, DexClass target) {
        if (source.type == target.superType) {
            FieldSignatureEquivalence equivalence = FieldSignatureEquivalence.get();
            HashSet<Equivalence.Wrapper<DexField>> staticFieldsInInterfacesOfTarget = new HashSet<Equivalence.Wrapper<DexField>>();
            for (DexType dexType : target.interfaces.values) {
                DexClass clazz = this.appInfo.definitionFor(dexType);
                for (DexEncodedField staticField : clazz.staticFields()) {
                    staticFieldsInInterfacesOfTarget.add(equivalence.wrap(staticField.field));
                }
            }
            for (DexItem dexItem : source.instanceFields()) {
                if (!staticFieldsInInterfacesOfTarget.contains(equivalence.wrap(((DexEncodedField)dexItem).field))) continue;
                return true;
            }
        }
        return false;
    }

    private static void makePrivate(DexEncodedMethod method) {
        assert (!method.accessFlags.isAbstract());
        method.accessFlags.unsetPublic();
        method.accessFlags.unsetProtected();
        method.accessFlags.setPrivate();
    }

    private DexProto getStaticProto(DexType receiverType, DexProto proto) {
        DexType[] parameterTypes = new DexType[proto.parameters.size() + 1];
        parameterTypes[0] = receiverType;
        System.arraycopy(proto.parameters.values, 0, parameterTypes, 1, proto.parameters.size());
        return this.appInfo.dexItemFactory.createProto(proto.returnType, parameterTypes);
    }

    private boolean disallowInlining(DexEncodedMethod method, DexType invocationContext) {
        if (this.options.enableInlining && method.getCode().isJarCode()) {
            JarCode jarCode = method.getCode().asJarCode();
            Inliner.ConstraintWithTarget constraint = jarCode.computeInliningConstraint(method, this.appInfo, new SingleTypeMapperGraphLense(method.method.holder, invocationContext), invocationContext);
            return constraint == Inliner.ConstraintWithTarget.NEVER;
        }
        return true;
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.mergedClasses.keySet());
    }

    static /* synthetic */ Collection access$1600(VerticalClassMerger x0) {
        return x0.getInvokes();
    }

    protected static class SynthesizedBridgeCode
    extends AbstractSynthesizedCode {
        private DexMethod method;
        private DexMethod invocationTarget;
        private Invoke.Type type;

        public SynthesizedBridgeCode(DexMethod method, DexMethod invocationTarget, Invoke.Type type) {
            this.method = method;
            this.invocationTarget = invocationTarget;
            this.type = type;
        }

        public void updateMethodSignatures(Function<DexMethod, DexMethod> transformer) {
            this.method = transformer.apply(this.method);
            this.invocationTarget = transformer.apply(this.invocationTarget);
        }

        @Override
        public AbstractSynthesizedCode.SourceCodeProvider getSourceCodeProvider() {
            return callerPosition -> new ForwardMethodSourceCode(this.method.holder, this.method, this.type == Invoke.Type.DIRECT ? this.method.holder : null, this.invocationTarget, this.type, callerPosition);
        }

        @Override
        public Consumer<UseRegistry> getRegistryCallback() {
            return registry -> {
                switch (this.type) {
                    case DIRECT: {
                        registry.registerInvokeDirect(this.invocationTarget);
                        break;
                    }
                    case STATIC: {
                        registry.registerInvokeStatic(this.invocationTarget);
                        break;
                    }
                    default: {
                        throw new Unreachable("Unexpected invocation type: " + (Object)((Object)this.type));
                    }
                }
            };
        }
    }

    private class IllegalAccessDetector
    extends UseRegistry {
        private boolean foundIllegalAccess;
        private DexClass source;

        public IllegalAccessDetector(DexItemFactory factory, DexClass source) {
            super(factory);
            this.foundIllegalAccess = false;
            this.source = source;
        }

        public boolean foundIllegalAccess() {
            return this.foundIllegalAccess;
        }

        private boolean checkFieldReference(DexField field) {
            if (!this.foundIllegalAccess && field.clazz.isSamePackage(this.source.type)) {
                this.checkTypeReference(field.clazz);
                this.checkTypeReference(field.type);
                DexEncodedField definition = VerticalClassMerger.this.appInfo.definitionFor(field);
                if (definition == null || !definition.accessFlags.isPublic()) {
                    this.foundIllegalAccess = true;
                }
            }
            return true;
        }

        private boolean checkMethodReference(DexMethod method) {
            if (!this.foundIllegalAccess && method.holder.isSamePackage(this.source.type)) {
                this.checkTypeReference(method.holder);
                this.checkTypeReference(method.proto.returnType);
                for (DexType type : method.proto.parameters.values) {
                    this.checkTypeReference(type);
                }
                DexEncodedMethod definition = VerticalClassMerger.this.appInfo.definitionFor(method);
                if (definition == null || !definition.accessFlags.isPublic()) {
                    this.foundIllegalAccess = true;
                }
            }
            return true;
        }

        private boolean checkTypeReference(DexType type) {
            DexClass clazz;
            if (!this.foundIllegalAccess && type.isClassType() && type.isSamePackage(this.source.type) && ((clazz = VerticalClassMerger.this.appInfo.definitionFor(type)) == null || !clazz.accessFlags.isPublic())) {
                this.foundIllegalAccess = true;
            }
            return true;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.checkMethodReference(method);
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.checkTypeReference(type);
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.checkFieldReference(field);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return this.checkTypeReference(type);
        }
    }

    private class SingleTypeMapperGraphLense
    extends GraphLense {
        private final DexType source;
        private final DexType target;

        public SingleTypeMapperGraphLense(DexType source, DexType target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            throw new Unreachable();
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            throw new Unreachable();
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField) {
            throw new Unreachable();
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
            throw new Unreachable();
        }

        @Override
        public DexType lookupType(DexType type) {
            return type == this.source ? this.target : VerticalClassMerger.this.mergedClasses.getOrDefault(type, type);
        }

        @Override
        public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            GraphLense.GraphLenseLookupResult lookup = VerticalClassMerger.this.graphLense.lookupMethod(method, context, type);
            DexMethod previousMethod = lookup.getMethod();
            Invoke.Type previousType = lookup.getType();
            DexMethod newMethod = ((VerticalClassMerger)VerticalClassMerger.this).renamedMembersLense.methodMap.get(previousMethod);
            if (newMethod != null) {
                DexClass clazz;
                if (previousType == Invoke.Type.INTERFACE && (clazz = VerticalClassMerger.this.appInfo.definitionFor(newMethod.holder)) != null && !clazz.accessFlags.isInterface()) {
                    assert (((VerticalClassMerger)VerticalClassMerger.this).appInfo.definitionFor((DexType)method.holder).accessFlags.isInterface());
                    return new GraphLense.GraphLenseLookupResult(newMethod, Invoke.Type.VIRTUAL);
                }
                return new GraphLense.GraphLenseLookupResult(newMethod, previousType);
            }
            return new GraphLense.GraphLenseLookupResult(previousMethod, previousType);
        }

        @Override
        public DexField lookupField(DexField field) {
            return ((VerticalClassMerger)VerticalClassMerger.this).renamedMembersLense.fieldMap.getOrDefault(field, field);
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }
    }

    private class CollisionDetector {
        private static final int NOT_FOUND = Integer.MIN_VALUE;
        private final Map<DexString, Int2IntMap> seenPositions = new IdentityHashMap<DexString, Int2IntMap>();
        private final Reference2IntMap<DexProto> targetProtoCache;
        private final Reference2IntMap<DexProto> sourceProtoCache;
        private final DexType source;
        private final DexType target;
        private final Collection<DexMethod> invokes = VerticalClassMerger.access$1600(VerticalClassMerger.this);

        private CollisionDetector(DexType source, DexType target) {
            this.source = source;
            this.target = target;
            this.targetProtoCache = new Reference2IntOpenHashMap<DexProto>(this.invokes.size() / 2);
            this.targetProtoCache.defaultReturnValue(Integer.MIN_VALUE);
            this.sourceProtoCache = new Reference2IntOpenHashMap<DexProto>(this.invokes.size() / 2);
            this.sourceProtoCache.defaultReturnValue(Integer.MIN_VALUE);
        }

        boolean mayCollide() {
            VerticalClassMerger.this.timing.begin("collision detection");
            this.fillSeenPositions();
            boolean result = false;
            if (!this.seenPositions.isEmpty()) {
                for (DexMethod method : this.invokes) {
                    int arity;
                    int previous;
                    Int2IntMap positionsMap = this.seenPositions.get(method.name);
                    if (positionsMap == null || (previous = positionsMap.get(arity = method.getArity())) == Integer.MIN_VALUE) continue;
                    assert (previous != 0);
                    int positions = this.computePositionsFor(method.proto, this.source, this.sourceProtoCache);
                    if ((positions & previous) == 0) continue;
                    result = true;
                    break;
                }
            }
            VerticalClassMerger.this.timing.end();
            return result;
        }

        private void fillSeenPositions() {
            for (DexMethod method : this.invokes) {
                DexType[] parameters = method.proto.parameters.values;
                int arity = parameters.length;
                int positions = this.computePositionsFor(method.proto, this.target, this.targetProtoCache);
                if (positions == 0) continue;
                Int2IntMap positionsMap = this.seenPositions.computeIfAbsent(method.name, k -> {
                    Int2IntOpenHashMap result = new Int2IntOpenHashMap();
                    result.defaultReturnValue(Integer.MIN_VALUE);
                    return result;
                });
                int value = 0;
                int previous = positionsMap.get(arity);
                if (previous != Integer.MIN_VALUE) {
                    value = previous;
                }
                positionsMap.put(arity, value |= positions);
            }
        }

        private int computePositionsFor(DexProto proto, DexType type, Reference2IntMap<DexProto> cache) {
            int result = cache.getInt(proto);
            if (result != Integer.MIN_VALUE) {
                return result;
            }
            result = 0;
            int bitsUsed = 0;
            int accumulator = 0;
            for (DexType aType : proto.parameters.values) {
                aType = VerticalClassMerger.this.mergedClasses.getOrDefault(aType, aType);
                accumulator <<= 1;
                ++bitsUsed;
                if (aType == type) {
                    accumulator |= 1;
                }
                if (bitsUsed != 31) continue;
                result |= accumulator;
                accumulator = 0;
                bitsUsed = 0;
            }
            DexType returnType = VerticalClassMerger.this.mergedClasses.getOrDefault(proto.returnType, proto.returnType);
            accumulator <<= 1;
            if (returnType == type) {
                accumulator |= 1;
            }
            cache.put(proto, result |= accumulator);
            return result;
        }
    }

    private class TreeFixer {
        private final GraphLense.Builder lense = GraphLense.builder();
        Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        private TreeFixer() {
        }

        private GraphLense fixupTypeReferences(GraphLense graphLense) {
            for (DexProgramClass clazz : VerticalClassMerger.this.appInfo.classes()) {
                clazz.setDirectMethods(this.substituteTypesIn(clazz.directMethods()));
                clazz.setVirtualMethods(this.substituteTypesIn(clazz.virtualMethods()));
                clazz.setVirtualMethods(this.removeDupes(clazz.virtualMethods()));
                clazz.setStaticFields(this.substituteTypesIn(clazz.staticFields()));
                clazz.setInstanceFields(this.substituteTypesIn(clazz.instanceFields()));
            }
            for (DexType type : VerticalClassMerger.this.mergedClasses.keySet()) {
                DexType fixed = this.fixupType(type);
                this.lense.map(type, fixed);
            }
            return this.lense.build(((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory, graphLense);
        }

        private DexEncodedMethod[] removeDupes(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            IdentityHashMap<DexMethod, DexEncodedMethod> filtered = new IdentityHashMap<DexMethod, DexEncodedMethod>();
            for (DexEncodedMethod method : methods) {
                DexEncodedMethod previous = filtered.put(method.method, method);
                if (previous == null || previous.accessFlags.isBridge()) continue;
                if (!method.accessFlags.isBridge()) {
                    throw new CompilationError("Class merging produced invalid result on: " + previous.toSourceString());
                }
                filtered.put(previous.method, previous);
            }
            if (filtered.size() == methods.length) {
                return methods;
            }
            return filtered.values().toArray(DexEncodedMethod.EMPTY_ARRAY);
        }

        private DexEncodedMethod[] substituteTypesIn(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            for (int i = 0; i < methods.length; ++i) {
                DexEncodedMethod encodedMethod = methods[i];
                DexMethod method = encodedMethod.method;
                DexProto newProto = this.getUpdatedProto(method.proto);
                DexType newHolder = this.fixupType(method.holder);
                DexMethod newMethod = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(newHolder, newProto, method.name);
                if (newMethod == encodedMethod.method) continue;
                this.lense.map(encodedMethod.method, newMethod);
                methods[i] = encodedMethod.toTypeSubstitutedMethod(newMethod);
            }
            return methods;
        }

        private DexEncodedField[] substituteTypesIn(DexEncodedField[] fields) {
            if (fields == null) {
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                DexEncodedField encodedField = fields[i];
                DexField field = encodedField.field;
                DexType newType = this.fixupType(field.type);
                DexType newHolder = this.fixupType(field.clazz);
                DexField newField = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(newHolder, newType, field.name);
                if (newField == encodedField.field) continue;
                this.lense.map(encodedField.field, newField);
                fields[i] = encodedField.toTypeSubstitutedField(newField);
            }
            return fields;
        }

        private DexProto getUpdatedProto(DexProto proto) {
            DexProto result = this.protoFixupCache.get(proto);
            if (result == null) {
                DexType returnType = this.fixupType(proto.returnType);
                DexType[] arguments = this.fixupTypes(proto.parameters.values);
                result = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createProto(returnType, arguments);
                this.protoFixupCache.put(proto, result);
            }
            return result;
        }

        private DexType fixupType(DexType type) {
            if (type.isArrayType()) {
                DexType fixed;
                DexType base = type.toBaseType(((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory);
                if (base == (fixed = this.fixupType(base))) {
                    return type;
                }
                return type.replaceBaseType(fixed, ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory);
            }
            while (VerticalClassMerger.this.mergedClasses.containsKey(type)) {
                type = (DexType)VerticalClassMerger.this.mergedClasses.get(type);
            }
            return type;
        }

        private DexType[] fixupTypes(DexType[] types) {
            DexType[] result = new DexType[types.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.fixupType(types[i]);
            }
            return result;
        }
    }

    private class ClassMerger {
        private static final String CONSTRUCTOR_NAME = "constructor";
        private final DexClass source;
        private final DexClass target;
        private final VerticalClassMergerGraphLense.Builder deferredRenamings = new VerticalClassMergerGraphLense.Builder();
        private final List<SynthesizedBridgeCode> synthesizedBridges = new ArrayList<SynthesizedBridgeCode>();
        private boolean abortMerge = false;

        private ClassMerger(DexClass source, DexClass target) {
            this.source = source;
            this.target = target;
        }

        public boolean merge() throws ExecutionException {
            HashSet existingMethods = new HashSet();
            this.addAll(existingMethods, this.target.methods(), MethodSignatureEquivalence.get());
            HashMap directMethods = new HashMap();
            HashMap virtualMethods = new HashMap();
            Predicate<DexMethod> availableMethodSignatures = method -> {
                Equivalence.Wrapper<DexMethod> wrapped = MethodSignatureEquivalence.get().wrap(method);
                return !existingMethods.contains(wrapped) && !directMethods.containsKey(wrapped) && !virtualMethods.containsKey(wrapped);
            };
            for (DexEncodedMethod directMethod : this.source.directMethods()) {
                if (directMethod.isInstanceInitializer()) {
                    this.add(directMethods, this.renameConstructor(directMethod, availableMethodSignatures), MethodSignatureEquivalence.get());
                    continue;
                }
                DexEncodedMethod resultingDirectMethod = this.renameMethod(directMethod, availableMethodSignatures, directMethod.isClassInitializer() ? Rename.NEVER : Rename.IF_NEEDED);
                this.add(directMethods, resultingDirectMethod, MethodSignatureEquivalence.get());
                this.deferredRenamings.map(directMethod.method, resultingDirectMethod.method);
                this.deferredRenamings.recordMove(directMethod.method, resultingDirectMethod.method);
                if (directMethod.isStatic()) continue;
                this.blockRedirectionOfSuperCalls(resultingDirectMethod.method);
            }
            for (DexEncodedMethod virtualMethod : this.source.virtualMethods()) {
                DexEncodedMethod resultingDirectMethod;
                DexEncodedMethod shadowedBy = this.findMethodInTarget(virtualMethod);
                if (shadowedBy != null) {
                    if (virtualMethod.accessFlags.isAbstract()) {
                        this.deferredRenamings.map(virtualMethod.method, shadowedBy.method);
                        continue;
                    }
                } else {
                    if (this.abortMerge) {
                        return false;
                    }
                    if (virtualMethod.accessFlags.isAbstract()) {
                        DexEncodedMethod resultingVirtualMethod = this.renameMethod(virtualMethod, availableMethodSignatures, Rename.NEVER);
                        this.deferredRenamings.map(virtualMethod.method, resultingVirtualMethod.method);
                        this.deferredRenamings.recordMove(virtualMethod.method, resultingVirtualMethod.method);
                        this.add(virtualMethods, resultingVirtualMethod, MethodSignatureEquivalence.get());
                        continue;
                    }
                }
                if (this.source.accessFlags.isInterface()) {
                    MethodPoolCollection.MethodPool methodPoolForTarget = VerticalClassMerger.this.methodPoolCollection.buildForHierarchy(this.target, VerticalClassMerger.this.executorService, VerticalClassMerger.this.timing);
                    resultingDirectMethod = this.renameMethod(virtualMethod, method -> availableMethodSignatures.test((DexMethod)method) && !methodPoolForTarget.hasSeen(MethodSignatureEquivalence.get().wrap(method)), Rename.ALWAYS, VerticalClassMerger.this.getStaticProto(virtualMethod.method.holder, virtualMethod.method.proto));
                    this.makeStatic(resultingDirectMethod);
                    methodPoolForTarget.seen(resultingDirectMethod.method);
                } else {
                    resultingDirectMethod = this.renameMethod(virtualMethod, availableMethodSignatures, Rename.ALWAYS);
                    VerticalClassMerger.makePrivate(resultingDirectMethod);
                }
                this.add(directMethods, resultingDirectMethod, MethodSignatureEquivalence.get());
                this.redirectSuperCallsInTarget(virtualMethod.method, resultingDirectMethod.method);
                this.blockRedirectionOfSuperCalls(resultingDirectMethod.method);
                if (shadowedBy == null) {
                    shadowedBy = this.buildBridgeMethod(virtualMethod, resultingDirectMethod);
                    this.add(virtualMethods, shadowedBy, MethodSignatureEquivalence.get());
                }
                this.deferredRenamings.map(virtualMethod.method, shadowedBy.method);
                this.deferredRenamings.recordMove(virtualMethod.method, resultingDirectMethod.method);
            }
            if (this.abortMerge) {
                return false;
            }
            DexEncodedMethod[] mergedDirectMethods = this.mergeMethods(directMethods.values(), this.target.directMethods());
            DexEncodedMethod[] mergedVirtualMethods = this.mergeMethods(virtualMethods.values(), this.target.virtualMethods());
            HashSet<DexString> existingFieldNames = new HashSet<DexString>();
            for (DexEncodedField field2 : this.target.fields()) {
                existingFieldNames.add(field2.field.name);
            }
            Predicate<DexField> availableFieldSignatures = field -> !existingFieldNames.contains(field.name);
            DexEncodedField[] mergedInstanceFields = this.mergeFields(this.source.instanceFields(), this.target.instanceFields(), availableFieldSignatures, existingFieldNames);
            DexEncodedField[] mergedStaticFields = this.mergeFields(this.source.staticFields(), this.target.staticFields(), availableFieldSignatures, existingFieldNames);
            Set<DexType> interfaces = this.mergeArrays(this.target.interfaces.values, this.source.interfaces.values);
            if (this.source.isInterface()) {
                interfaces.remove(this.source.type);
            } else {
                assert (!this.target.isInterface());
                this.target.superType = this.source.superType;
            }
            this.target.interfaces = interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(new DexType[0]));
            this.target.setDirectMethods(mergedDirectMethods);
            this.target.setVirtualMethods(mergedVirtualMethods);
            this.target.setInstanceFields(mergedInstanceFields);
            this.target.setStaticFields(mergedStaticFields);
            this.source.superType = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.objectType;
            this.source.setDirectMethods(null);
            this.source.setVirtualMethods(null);
            this.source.setInstanceFields(null);
            this.source.setStaticFields(null);
            this.source.interfaces = DexTypeList.empty();
            VerticalClassMerger.this.mergedClasses.put(this.source.type, this.target.type);
            VerticalClassMerger.this.mergedClassesInverse.computeIfAbsent(this.target.type, key -> new HashSet()).add(this.source.type);
            assert (!this.abortMerge);
            return true;
        }

        public VerticalClassMergerGraphLense.Builder getRenamings() {
            return this.deferredRenamings;
        }

        public List<SynthesizedBridgeCode> getSynthesizedBridges() {
            return this.synthesizedBridges;
        }

        private void redirectSuperCallsInTarget(DexMethod oldTarget, DexMethod newTarget) {
            if (this.source.accessFlags.isInterface()) {
                this.deferredRenamings.mapVirtualMethodToDirectInType(oldTarget, new GraphLense.GraphLenseLookupResult(newTarget, Invoke.Type.STATIC), this.target.type);
            } else {
                DexClass holder = this.target;
                while (holder != null && holder.isProgramClass()) {
                    boolean resolutionSucceeds;
                    DexMethod signatureInHolder = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(holder.type, oldTarget.proto, oldTarget.name);
                    boolean bl = resolutionSucceeds = holder.lookupVirtualMethod(signatureInHolder) != null || VerticalClassMerger.this.appInfo.lookupSuperTarget(signatureInHolder, holder.type) != null;
                    if (!resolutionSucceeds) break;
                    this.deferredRenamings.mapVirtualMethodToDirectInType(signatureInHolder, new GraphLense.GraphLenseLookupResult(newTarget, Invoke.Type.DIRECT), this.target.type);
                    Set mergedTypes = (Set)VerticalClassMerger.this.mergedClassesInverse.get(holder.type);
                    if (mergedTypes != null) {
                        for (DexType type : mergedTypes) {
                            DexMethod signatureInType = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(type, oldTarget.proto, oldTarget.name);
                            boolean resolutionSucceededBeforeMerge = VerticalClassMerger.this.renamedMembersLense.hasMappingForSignatureInContext(holder.type, signatureInType) || VerticalClassMerger.this.appInfo.lookupSuperTarget(signatureInHolder, holder.type) != null;
                            if (!resolutionSucceededBeforeMerge) continue;
                            this.deferredRenamings.mapVirtualMethodToDirectInType(signatureInType, new GraphLense.GraphLenseLookupResult(newTarget, Invoke.Type.DIRECT), this.target.type);
                        }
                    }
                    holder = holder.superType != null ? VerticalClassMerger.this.appInfo.definitionFor(holder.superType) : null;
                }
            }
        }

        private void blockRedirectionOfSuperCalls(DexMethod method) {
            this.deferredRenamings.markMethodAsMerged(method);
        }

        private DexEncodedMethod buildBridgeMethod(DexEncodedMethod method, DexEncodedMethod invocationTarget) {
            DexType holder = this.target.type;
            DexProto proto = method.method.proto;
            DexString name = method.method.name;
            DexMethod newMethod = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(holder, proto, name);
            MethodAccessFlags accessFlags = method.accessFlags.copy();
            accessFlags.setBridge();
            accessFlags.setSynthetic();
            accessFlags.unsetAbstract();
            assert (invocationTarget.isPrivateMethod() == !invocationTarget.isStatic());
            SynthesizedBridgeCode code = new SynthesizedBridgeCode(newMethod, invocationTarget.method, invocationTarget.isPrivateMethod() ? Invoke.Type.DIRECT : Invoke.Type.STATIC);
            this.synthesizedBridges.add(code);
            DexEncodedMethod bridge = new DexEncodedMethod(newMethod, accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code, method.hasClassFileVersion() ? method.getClassFileVersion() : -1);
            if (method.getOptimizationInfo().isPublicized()) {
                bridge.markPublicized();
                method.unsetPublicized();
            }
            return bridge;
        }

        private DexEncodedMethod findMethodInTarget(DexEncodedMethod method) {
            AppInfo.ResolutionResult resolutionResult = VerticalClassMerger.this.appInfo.resolveMethod(this.target.type, method.method);
            if (!resolutionResult.hasSingleTarget()) {
                this.abortMerge = true;
                return null;
            }
            DexEncodedMethod actual = resolutionResult.asSingleTarget();
            if (actual != method) {
                assert (actual.isVirtualMethod() == method.isVirtualMethod());
                return actual;
            }
            assert (!method.accessFlags.isAbstract() || this.target.accessFlags.isAbstract());
            return null;
        }

        private <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> void add(Map<Equivalence.Wrapper<S>, T> map2, T item, Equivalence<S> equivalence) {
            map2.put(equivalence.wrap(item.getKey()), item);
        }

        private <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> void addAll(Collection<Equivalence.Wrapper<S>> collection, Iterable<T> items, Equivalence<S> equivalence) {
            for (KeyedDexItem item : items) {
                collection.add(equivalence.wrap(item.getKey()));
            }
        }

        private <T> Set<T> mergeArrays(T[] one, T[] other) {
            LinkedHashSet merged = new LinkedHashSet();
            Collections.addAll(merged, one);
            Collections.addAll(merged, other);
            return merged;
        }

        private DexEncodedField[] mergeFields(DexEncodedField[] sourceFields, DexEncodedField[] targetFields, Predicate<DexField> availableFieldSignatures, Set<DexString> existingFieldNames) {
            DexEncodedField[] result = new DexEncodedField[sourceFields.length + targetFields.length];
            int i = 0;
            for (DexEncodedField field : sourceFields) {
                DexEncodedField resultingField = this.renameFieldIfNeeded(field, availableFieldSignatures);
                existingFieldNames.add(resultingField.field.name);
                this.deferredRenamings.map(field.field, resultingField.field);
                result[i] = resultingField;
                ++i;
            }
            System.arraycopy(targetFields, 0, result, i, targetFields.length);
            return result;
        }

        private DexEncodedMethod[] mergeMethods(Collection<DexEncodedMethod> sourceMethods, DexEncodedMethod[] targetMethods) {
            DexEncodedMethod[] result = new DexEncodedMethod[sourceMethods.size() + targetMethods.length];
            int i = 0;
            Iterator<DexEncodedMethod> iterator2 = sourceMethods.iterator();
            while (iterator2.hasNext()) {
                DexEncodedMethod method;
                result[i] = method = iterator2.next();
                ++i;
            }
            System.arraycopy(targetMethods, 0, result, i, targetMethods.length);
            return result;
        }

        private DexString getFreshName(String nameString, int index, DexType holder) {
            String freshName = nameString + "$" + holder.toSourceString().replace('.', '$');
            if (index > 1) {
                freshName = freshName + index;
            }
            return ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createString(freshName);
        }

        private DexEncodedMethod renameConstructor(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures) {
            DexMethod newSignature;
            assert (method.isInstanceInitializer());
            DexType oldHolder = method.method.holder;
            int count = 1;
            do {
                DexString newName = this.getFreshName(CONSTRUCTOR_NAME, count, oldHolder);
                newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, method.method.proto, newName);
                ++count;
            } while (!availableMethodSignatures.test(newSignature));
            DexEncodedMethod result = method.toTypeSubstitutedMethod(newSignature);
            result.markForceInline();
            this.deferredRenamings.map(method.method, result.method);
            this.deferredRenamings.recordMove(method.method, result.method);
            result.accessFlags.unsetConstructor();
            VerticalClassMerger.makePrivate(result);
            return result;
        }

        private DexEncodedMethod renameMethod(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures, Rename strategy) {
            return this.renameMethod(method, availableMethodSignatures, strategy, method.method.proto);
        }

        private DexEncodedMethod renameMethod(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures, Rename strategy, DexProto newProto) {
            DexMethod newSignature;
            assert (!method.accessFlags.isConstructor() || strategy == Rename.NEVER);
            DexString oldName = method.method.name;
            DexType oldHolder = method.method.holder;
            switch (strategy) {
                case IF_NEEDED: {
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, newProto, oldName);
                    if (availableMethodSignatures.test(newSignature)) break;
                }
                case ALWAYS: {
                    int count = 1;
                    do {
                        DexString newName = this.getFreshName(oldName.toSourceString(), count, oldHolder);
                        newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, newProto, newName);
                        ++count;
                    } while (!availableMethodSignatures.test(newSignature));
                    break;
                }
                case NEVER: {
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, newProto, oldName);
                    assert (availableMethodSignatures.test(newSignature));
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            return method.toTypeSubstitutedMethod(newSignature);
        }

        private DexEncodedField renameFieldIfNeeded(DexEncodedField field, Predicate<DexField> availableFieldSignatures) {
            DexString oldName = field.field.name;
            DexType oldHolder = field.field.clazz;
            DexField newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(this.target.type, field.field.type, oldName);
            if (!availableFieldSignatures.test(newSignature)) {
                int count = 1;
                do {
                    DexString newName = this.getFreshName(oldName.toSourceString(), count, oldHolder);
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(this.target.type, field.field.type, newName);
                    ++count;
                } while (!availableFieldSignatures.test(newSignature));
            }
            return field.toTypeSubstitutedField(newSignature);
        }

        private void makeStatic(DexEncodedMethod method) {
            method.accessFlags.setStatic();
            Code code = method.getCode();
            if (code.isJarCode()) {
                MethodNode node = code.asJarCode().getNode();
                node.access |= 8;
                node.desc = method.method.proto.toDescriptorString();
            } else {
                this.abortMerge = true;
            }
        }
    }

    private class OverloadedMethodSignaturesRetriever {
        private final Reference2BooleanOpenHashMap<DexProto> cache = new Reference2BooleanOpenHashMap();
        private final Equivalence<DexMethod> equivalence = MethodSignatureEquivalence.get();
        private final Set<DexType> mergeeCandidates = new HashSet<DexType>();

        public OverloadedMethodSignaturesRetriever() {
            for (DexProgramClass mergeCandidate : VerticalClassMerger.this.mergeCandidates) {
                this.mergeeCandidates.add(mergeCandidate.type.getSingleSubtype());
            }
        }

        public Collection<DexMethod> get() {
            HashMap<DexString, DexProto> overloadingInfo = new HashMap<DexString, DexProto>();
            HashSet<Equivalence.Wrapper<DexMethod>> filteredSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();
            for (DexMethod signature : ((VerticalClassMerger)VerticalClassMerger.this).appInfo.targetedMethods) {
                DexClass dexClass = VerticalClassMerger.this.appInfo.definitionFor(signature.holder);
                if (dexClass == null || !dexClass.isProgramClass() || !this.protoMayReferenceMergedSourceOrTarget(signature.proto)) continue;
                filteredSignatures.add(this.equivalence.wrap(signature));
                DexProto existing = overloadingInfo.computeIfAbsent(signature.name, key -> signature.proto);
                if (existing == DexProto.SENTINEL || existing.equals(signature.proto)) continue;
                overloadingInfo.put(signature.name, DexProto.SENTINEL);
            }
            ArrayList<DexMethod> result = new ArrayList<DexMethod>();
            for (Equivalence.Wrapper wrapper : filteredSignatures) {
                DexMethod signature = (DexMethod)wrapper.get();
                if (overloadingInfo.get(signature.name) != DexProto.SENTINEL) continue;
                result.add(signature);
            }
            return result;
        }

        private boolean protoMayReferenceMergedSourceOrTarget(DexProto proto) {
            boolean result;
            if (this.cache.containsKey(proto)) {
                result = this.cache.getBoolean(proto);
            } else {
                result = false;
                if (this.typeMayReferenceMergedSourceOrTarget(proto.returnType)) {
                    result = true;
                } else {
                    for (DexType type : proto.parameters.values) {
                        if (!this.typeMayReferenceMergedSourceOrTarget(type)) continue;
                        result = true;
                        break;
                    }
                }
                this.cache.put(proto, result);
            }
            return result;
        }

        private boolean typeMayReferenceMergedSourceOrTarget(DexType type) {
            if ((type = type.toBaseType(((VerticalClassMerger)VerticalClassMerger.this).appInfo.dexItemFactory)).isClassType()) {
                if (this.mergeeCandidates.contains(type)) {
                    return true;
                }
                DexClass clazz = VerticalClassMerger.this.appInfo.definitionFor(type);
                if (clazz != null && clazz.isProgramClass()) {
                    return VerticalClassMerger.this.mergeCandidates.contains(clazz.asProgramClass());
                }
            }
            return false;
        }
    }

    private static enum Rename {
        ALWAYS,
        IF_NEEDED,
        NEVER;

    }

    private static final class AbortReason
    extends Enum<AbortReason> {
        public static final /* enum */ AbortReason ALREADY_MERGED = new AbortReason();
        public static final /* enum */ AbortReason ALWAYS_INLINE = new AbortReason();
        public static final /* enum */ AbortReason CONFLICT = new AbortReason();
        public static final /* enum */ AbortReason ILLEGAL_ACCESS = new AbortReason();
        public static final /* enum */ AbortReason NATIVE_METHOD = new AbortReason();
        public static final /* enum */ AbortReason NO_SIDE_EFFECTS = new AbortReason();
        public static final /* enum */ AbortReason PINNED_SOURCE = new AbortReason();
        public static final /* enum */ AbortReason RESOLUTION_FOR_FIELDS_MAY_CHANGE = new AbortReason();
        public static final /* enum */ AbortReason RESOLUTION_FOR_METHODS_MAY_CHANGE = new AbortReason();
        public static final /* enum */ AbortReason STATIC_INITIALIZERS = new AbortReason();
        public static final /* enum */ AbortReason UNHANDLED_INVOKE_DIRECT = new AbortReason();
        public static final /* enum */ AbortReason UNHANDLED_INVOKE_SUPER = new AbortReason();
        public static final /* enum */ AbortReason UNSAFE_INLINING = new AbortReason();
        public static final /* enum */ AbortReason UNSUPPORTED_ATTRIBUTES = new AbortReason();
        private static final /* synthetic */ AbortReason[] $VALUES;

        public static AbortReason[] values() {
            return (AbortReason[])$VALUES.clone();
        }

        public static AbortReason valueOf(String name) {
            return Enum.valueOf(AbortReason.class, name);
        }

        public void printLogMessageForClass(DexClass clazz) {
            Log.info(VerticalClassMerger.class, this.getMessageForClass(clazz), new Object[0]);
        }

        private String getMessageForClass(DexClass clazz) {
            String message = null;
            switch (this) {
                case ALREADY_MERGED: {
                    message = "it has already been merged with its superclass";
                    break;
                }
                case ALWAYS_INLINE: {
                    message = "it is mentioned in appInfo.alwaysInline";
                    break;
                }
                case CONFLICT: {
                    message = "it is conflicting with its subclass";
                    break;
                }
                case ILLEGAL_ACCESS: {
                    message = "it could lead to illegal accesses";
                    break;
                }
                case NATIVE_METHOD: {
                    message = "it has a native method";
                    break;
                }
                case NO_SIDE_EFFECTS: {
                    message = "it is mentioned in appInfo.noSideEffects";
                    break;
                }
                case PINNED_SOURCE: {
                    message = "it should be kept";
                    break;
                }
                case RESOLUTION_FOR_FIELDS_MAY_CHANGE: {
                    message = "it could affect field resolution";
                    break;
                }
                case RESOLUTION_FOR_METHODS_MAY_CHANGE: {
                    message = "it could affect method resolution";
                    break;
                }
                case STATIC_INITIALIZERS: {
                    message = "merging of static initializers are not supported";
                    break;
                }
                case UNHANDLED_INVOKE_DIRECT: {
                    message = "a virtual method is targeted by an invoke-direct instruction";
                    break;
                }
                case UNHANDLED_INVOKE_SUPER: {
                    message = "it may change the semantics of an invoke-super instruction";
                    break;
                }
                case UNSAFE_INLINING: {
                    message = "force-inlining might fail";
                    break;
                }
                case UNSUPPORTED_ATTRIBUTES: {
                    message = "since inner-class attributes are not supported";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return String.format("Cannot merge %s since %s.", clazz.toSourceString(), message);
        }

        static {
            $VALUES = new AbortReason[]{ALREADY_MERGED, ALWAYS_INLINE, CONFLICT, ILLEGAL_ACCESS, NATIVE_METHOD, NO_SIDE_EFFECTS, PINNED_SOURCE, RESOLUTION_FOR_FIELDS_MAY_CHANGE, RESOLUTION_FOR_METHODS_MAY_CHANGE, STATIC_INITIALIZERS, UNHANDLED_INVOKE_DIRECT, UNHANDLED_INVOKE_SUPER, UNSAFE_INLINING, UNSUPPORTED_ATTRIBUTES};
        }
    }

    public static class VerticallyMergedClasses {
        private final Map<DexType, DexType> mergedClasses;
        private final Map<DexType, List<DexType>> sources;

        private VerticallyMergedClasses(Map<DexType, DexType> mergedClasses) {
            IdentityHashMap<DexType, List<DexType>> sources = Maps.newIdentityHashMap();
            mergedClasses.forEach((source, target) -> sources.computeIfAbsent((DexType)target, key -> new ArrayList()).add(source));
            this.mergedClasses = mergedClasses;
            this.sources = sources;
        }

        public List<DexType> getSourcesFor(DexType type) {
            return this.sources.getOrDefault(type, ImmutableList.of());
        }

        public DexType getTargetFor(DexType type) {
            assert (this.mergedClasses.containsKey(type));
            return this.mergedClasses.get(type);
        }

        public boolean hasBeenMergedIntoSubtype(DexType type) {
            return this.mergedClasses.containsKey(type);
        }
    }
}

