/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.MoreObjects;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.origin.Origin;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class DexClass
extends DexDefinition {
    private static final DexEncodedMethod[] NO_METHODS = new DexEncodedMethod[0];
    private static final DexEncodedField[] NO_FIELDS = new DexEncodedField[0];
    public final Origin origin;
    public DexType type;
    public final ClassAccessFlags accessFlags;
    public DexType superType;
    public DexTypeList interfaces;
    public DexString sourceFile;
    protected DexEncodedField[] staticFields;
    protected DexEncodedField[] instanceFields;
    protected DexEncodedMethod[] directMethods;
    protected DexEncodedMethod[] virtualMethods;
    private EnclosingMethodAttribute enclosingMethod;
    private final List<InnerClassAttribute> innerClasses;
    public DexAnnotationSet annotations;

    public DexClass(DexString sourceFile, DexTypeList interfaces, ClassAccessFlags accessFlags, DexType superType, DexType type, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, EnclosingMethodAttribute enclosingMethod, List<InnerClassAttribute> innerClasses, DexAnnotationSet annotations, Origin origin, boolean skipNameValidationForTesting) {
        assert (origin != null);
        this.origin = origin;
        this.sourceFile = sourceFile;
        this.interfaces = interfaces;
        this.accessFlags = accessFlags;
        this.superType = superType;
        this.type = type;
        this.setStaticFields(staticFields);
        this.setInstanceFields(instanceFields);
        this.setDirectMethods(directMethods);
        this.setVirtualMethods(virtualMethods);
        this.enclosingMethod = enclosingMethod;
        this.innerClasses = innerClasses;
        this.annotations = annotations;
        if (type == superType) {
            throw new CompilationError("Class " + type.toString() + " cannot extend itself");
        }
        for (DexType interfaceType : interfaces.values) {
            if (type != interfaceType) continue;
            throw new CompilationError("Interface " + type.toString() + " cannot implement itself");
        }
        if (!skipNameValidationForTesting && !type.descriptor.isValidClassDescriptor()) {
            throw new CompilationError("Class descriptor '" + type.descriptor.toString() + "' cannot be represented in dex format.");
        }
    }

    public Iterable<DexEncodedField> fields() {
        return this.fields(Predicates.alwaysTrue());
    }

    public Iterable<DexEncodedField> fields(Predicate<? super DexEncodedField> predicate) {
        return Iterables.concat(Iterables.filter(Arrays.asList(this.instanceFields), predicate::test), Iterables.filter(Arrays.asList(this.staticFields), predicate::test));
    }

    public Iterable<DexEncodedMethod> methods() {
        return this.methods(Predicates.alwaysTrue());
    }

    public Iterable<DexEncodedMethod> methods(Predicate<? super DexEncodedMethod> predicate) {
        return Iterables.concat(Iterables.filter(Arrays.asList(this.directMethods), predicate::test), Iterables.filter(Arrays.asList(this.virtualMethods), predicate::test));
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        throw new Unreachable();
    }

    public DexEncodedMethod[] directMethods() {
        return this.directMethods;
    }

    public void setDirectMethods(DexEncodedMethod[] values2) {
        this.directMethods = MoreObjects.firstNonNull(values2, NO_METHODS);
    }

    public DexEncodedMethod[] virtualMethods() {
        return this.virtualMethods;
    }

    public void setVirtualMethods(DexEncodedMethod[] values2) {
        this.virtualMethods = MoreObjects.firstNonNull(values2, NO_METHODS);
    }

    public void forEachMethod(Consumer<DexEncodedMethod> consumer) {
        for (DexEncodedMethod method : this.directMethods()) {
            consumer.accept(method);
        }
        for (DexEncodedMethod method : this.virtualMethods()) {
            consumer.accept(method);
        }
    }

    public DexEncodedMethod[] allMethodsSorted() {
        int vLen = this.virtualMethods.length;
        int dLen = this.directMethods.length;
        DexEncodedMethod[] result = new DexEncodedMethod[vLen + dLen];
        System.arraycopy(this.virtualMethods, 0, result, 0, vLen);
        System.arraycopy(this.directMethods, 0, result, vLen, dLen);
        Arrays.sort(result, (a, b) -> a.method.slowCompareTo(b.method));
        return result;
    }

    public void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        int vLen = this.virtualMethods.length;
        int dLen = this.directMethods.length;
        int mLen = privateInstanceMethods.size();
        assert (mLen <= dLen);
        DexEncodedMethod[] newDirectMethods = new DexEncodedMethod[dLen - mLen];
        int index = 0;
        for (int i = 0; i < dLen; ++i) {
            DexEncodedMethod encodedMethod = this.directMethods[i];
            if (privateInstanceMethods.contains(encodedMethod)) continue;
            newDirectMethods[index++] = encodedMethod;
        }
        assert (index == dLen - mLen);
        this.setDirectMethods(newDirectMethods);
        DexEncodedMethod[] newVirtualMethods = new DexEncodedMethod[vLen + mLen];
        System.arraycopy(this.virtualMethods, 0, newVirtualMethods, 0, vLen);
        index = vLen;
        for (DexEncodedMethod encodedMethod : privateInstanceMethods) {
            newVirtualMethods[index++] = encodedMethod;
        }
        this.setVirtualMethods(newVirtualMethods);
    }

    public void forEachAnnotation(Consumer<DexAnnotation> consumer) {
        for (DexAnnotation dexAnnotation : this.annotations.annotations) {
            consumer.accept(dexAnnotation);
        }
        for (DexItem dexItem : this.directMethods()) {
            for (DexAnnotation annotation : ((DexEncodedMethod)dexItem).annotations.annotations) {
                consumer.accept(annotation);
            }
            ((DexEncodedMethod)dexItem).parameterAnnotationsList.forEachAnnotation(consumer);
        }
        for (DexItem dexItem : this.virtualMethods()) {
            for (DexAnnotation annotation : ((DexEncodedMethod)dexItem).annotations.annotations) {
                consumer.accept(annotation);
            }
            ((DexEncodedMethod)dexItem).parameterAnnotationsList.forEachAnnotation(consumer);
        }
        for (DexItem dexItem : this.instanceFields()) {
            for (DexAnnotation annotation : ((DexEncodedField)dexItem).annotations.annotations) {
                consumer.accept(annotation);
            }
        }
        for (DexItem dexItem : this.staticFields()) {
            for (DexAnnotation annotation : ((DexEncodedField)dexItem).annotations.annotations) {
                consumer.accept(annotation);
            }
        }
    }

    public void forEachField(Consumer<DexEncodedField> consumer) {
        for (DexEncodedField field : this.staticFields()) {
            consumer.accept(field);
        }
        for (DexEncodedField field : this.instanceFields()) {
            consumer.accept(field);
        }
    }

    public DexEncodedField[] staticFields() {
        return this.staticFields;
    }

    public void setStaticFields(DexEncodedField[] values2) {
        this.staticFields = MoreObjects.firstNonNull(values2, NO_FIELDS);
    }

    public boolean definesStaticField(DexField field) {
        for (DexEncodedField encodedField : this.staticFields()) {
            if (encodedField.field != field) continue;
            return true;
        }
        return false;
    }

    public DexEncodedField[] instanceFields() {
        return this.instanceFields;
    }

    public void setInstanceFields(DexEncodedField[] values2) {
        this.instanceFields = MoreObjects.firstNonNull(values2, NO_FIELDS);
    }

    public DexEncodedField[] allFieldsSorted() {
        int iLen = this.instanceFields.length;
        int sLen = this.staticFields.length;
        DexEncodedField[] result = new DexEncodedField[iLen + sLen];
        System.arraycopy(this.instanceFields, 0, result, 0, iLen);
        System.arraycopy(this.staticFields, 0, result, iLen, sLen);
        Arrays.sort(result, (a, b) -> a.field.slowCompareTo(b.field));
        return result;
    }

    public DexEncodedField lookupStaticField(DexField field) {
        return (DexEncodedField)this.lookupTarget(this.staticFields(), field);
    }

    public DexEncodedField lookupInstanceField(DexField field) {
        return (DexEncodedField)this.lookupTarget(this.instanceFields(), field);
    }

    public DexEncodedField lookupField(DexField field) {
        DexEncodedField result = this.lookupInstanceField(field);
        return result == null ? this.lookupStaticField(field) : result;
    }

    public DexEncodedMethod lookupDirectMethod(DexMethod method) {
        return (DexEncodedMethod)this.lookupTarget(this.directMethods(), method);
    }

    public DexEncodedMethod lookupVirtualMethod(DexMethod method) {
        return (DexEncodedMethod)this.lookupTarget(this.virtualMethods(), method);
    }

    public DexEncodedMethod lookupMethod(DexMethod method) {
        DexEncodedMethod result = this.lookupDirectMethod(method);
        return result == null ? this.lookupVirtualMethod(method) : result;
    }

    private <T extends DexItem, S extends Descriptor<T, S>> T lookupTarget(T[] items, S descriptor) {
        for (T entry : items) {
            if (!descriptor.match(entry)) continue;
            return entry;
        }
        return null;
    }

    public boolean isInterface() {
        return this.accessFlags.isInterface();
    }

    public abstract void addDependencies(MixedSectionCollection var1);

    @Override
    public DexReference toReference() {
        return this.getType();
    }

    @Override
    public boolean isDexClass() {
        return true;
    }

    @Override
    public DexClass asDexClass() {
        return this;
    }

    public boolean isProgramClass() {
        return false;
    }

    public DexProgramClass asProgramClass() {
        return null;
    }

    public boolean isClasspathClass() {
        return false;
    }

    public DexClasspathClass asClasspathClass() {
        return null;
    }

    public boolean isLibraryClass() {
        return false;
    }

    public DexLibraryClass asLibraryClass() {
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        return false;
    }

    public DexEncodedMethod getClassInitializer() {
        return Arrays.stream(this.directMethods()).filter(DexEncodedMethod::isClassInitializer).findAny().orElse(null);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public DexType getType() {
        return this.type;
    }

    public boolean hasClassInitializer() {
        return this.getClassInitializer() != null;
    }

    public boolean hasTrivialClassInitializer() {
        if (this.isLibraryClass()) {
            return this.superType == null;
        }
        DexEncodedMethod clinit = this.getClassInitializer();
        return clinit != null && clinit.getCode() != null && clinit.getCode().isEmptyVoidMethod();
    }

    public boolean hasNonTrivialClassInitializer() {
        if (this.isLibraryClass()) {
            return this.superType != null;
        }
        DexEncodedMethod clinit = this.getClassInitializer();
        if (clinit == null || clinit.getCode() == null) {
            return false;
        }
        return !clinit.getCode().isEmptyVoidMethod();
    }

    public boolean hasDefaultInitializer() {
        return this.getDefaultInitializer() != null;
    }

    public DexEncodedMethod getDefaultInitializer() {
        for (DexEncodedMethod method : this.directMethods()) {
            if (!method.isDefaultInitializer()) continue;
            return method;
        }
        return null;
    }

    public boolean isSerializable(AppInfo appInfo) {
        return this.type.isSerializable(appInfo);
    }

    public boolean isExternalizable(AppInfo appInfo) {
        return this.type.isExternalizable(appInfo);
    }

    public boolean classInitializationMayHaveSideEffects(AppInfo appInfo) {
        if (this.hasNonTrivialClassInitializer()) {
            return true;
        }
        if (this.defaultValuesForStaticFieldsMayTriggerAllocation()) {
            return true;
        }
        for (DexType iface : this.interfaces.values) {
            if (!iface.classInitializationMayHaveSideEffects(appInfo)) continue;
            return true;
        }
        return this.superType != null && this.superType.classInitializationMayHaveSideEffects(appInfo);
    }

    public boolean defaultValuesForStaticFieldsMayTriggerAllocation() {
        return Arrays.stream(this.staticFields()).anyMatch(field -> !field.getStaticValue().mayTriggerAllocation());
    }

    public List<InnerClassAttribute> getInnerClasses() {
        return this.innerClasses;
    }

    public EnclosingMethodAttribute getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public void clearEnclosingMethod() {
        this.enclosingMethod = null;
    }

    public void clearInnerClasses() {
        this.innerClasses.clear();
    }

    public void removeInnerClasses(Predicate<InnerClassAttribute> predicate) {
        this.innerClasses.removeIf(predicate::test);
    }

    public abstract KotlinInfo getKotlinInfo();

    public final boolean hasKotlinInfo() {
        return this.getKotlinInfo() != null;
    }
}

