/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.ClassProcessor;
import com.android.tools.r8.ir.desugar.DefaultMethodsHelper;
import com.android.tools.r8.ir.desugar.InterfaceMethodDesugaringLense;
import com.android.tools.r8.ir.desugar.InterfaceProcessor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class InterfaceMethodRewriter {
    public static final String DISPATCH_CLASS_NAME_SUFFIX = "$-DC";
    public static final String COMPANION_CLASS_NAME_SUFFIX = "$-CC";
    public static final String DEFAULT_METHOD_PREFIX = "$default$";
    public static final String PRIVATE_METHOD_PREFIX = "$private$";
    private final IRConverter converter;
    private final InternalOptions options;
    final DexItemFactory factory;
    private final Set<DexEncodedMethod> synthesizedMethods = Sets.newIdentityHashSet();
    private final Map<DexType, DefaultMethodsHelper.Collection> cache = new ConcurrentHashMap<DexType, DefaultMethodsHelper.Collection>();
    private final ConcurrentMap<DexLibraryClass, Set<DexProgramClass>> requiredDispatchClasses = new ConcurrentHashMap<DexLibraryClass, Set<DexProgramClass>>();
    private final Set<DexItem> reportedMissing = Sets.newConcurrentHashSet();

    public InterfaceMethodRewriter(IRConverter converter, InternalOptions options) {
        assert (converter != null);
        this.converter = converter;
        this.options = options;
        this.factory = options.itemFactory;
    }

    public void rewriteMethodReferences(DexEncodedMethod encodedMethod, IRCode code) {
        if (this.synthesizedMethods.contains(encodedMethod)) {
            return;
        }
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                InvokeDirect invokeDirect;
                DexClass clazz;
                DexMethod method;
                Instruction instruction = (Instruction)instructions.next();
                if (instruction.isInvokeCustom()) {
                    DexCallSite callSite = instruction.asInvokeCustom().getCallSite();
                    this.reportStaticInterfaceMethodHandle(encodedMethod.method, callSite.bootstrapMethod);
                    for (DexValue arg : callSite.bootstrapArgs) {
                        if (!(arg instanceof DexValue.DexValueMethodHandle)) continue;
                        this.reportStaticInterfaceMethodHandle(encodedMethod.method, (DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value);
                    }
                    continue;
                }
                if (instruction.isInvokeStatic()) {
                    InvokeStatic invokeStatic = instruction.asInvokeStatic();
                    method = invokeStatic.getInvokedMethod();
                    clazz = this.findDefinitionFor(method.holder);
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, method.holder);
                        continue;
                    }
                    if (!clazz.isInterface()) continue;
                    if (clazz.isLibraryClass()) {
                        if (this.options.canLeaveStaticInterfaceMethodInvokes()) continue;
                        instructions.replaceCurrentInstruction(new InvokeStatic(this.staticAsMethodOfDispatchClass(method), invokeStatic.outValue(), invokeStatic.arguments()));
                        this.requiredDispatchClasses.computeIfAbsent(clazz.asLibraryClass(), k -> Sets.newConcurrentHashSet()).add(this.findDefinitionFor(encodedMethod.method.holder).asProgramClass());
                        continue;
                    }
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.staticAsMethodOfCompanionClass(method), invokeStatic.outValue(), invokeStatic.arguments()));
                    continue;
                }
                if (instruction.isInvokeSuper()) {
                    InvokeSuper invokeSuper = instruction.asInvokeSuper();
                    method = invokeSuper.getInvokedMethod();
                    clazz = this.findDefinitionFor(method.holder);
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, method.holder);
                        continue;
                    }
                    if (!clazz.isInterface() || clazz.isLibraryClass()) continue;
                    DexMethod amendedMethod = this.amendDefaultMethod(this.findDefinitionFor(encodedMethod.method.holder), method);
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.defaultAsMethodOfCompanionClass(amendedMethod), invokeSuper.outValue(), invokeSuper.arguments()));
                    continue;
                }
                if (!instruction.isInvokeDirect() || this.factory.isConstructor(method = (invokeDirect = instruction.asInvokeDirect()).getInvokedMethod())) continue;
                clazz = this.findDefinitionFor(method.holder);
                if (clazz == null) {
                    this.warnMissingType(encodedMethod.method, method.holder);
                    continue;
                }
                if (!clazz.isInterface()) continue;
                if (clazz.isLibraryClass()) {
                    throw new CompilationError("Unexpected call to a private method defined in library class " + clazz.toSourceString(), this.getMethodOrigin(encodedMethod.method));
                }
                DexEncodedMethod virtualTarget = null;
                for (DexEncodedMethod candidate : clazz.virtualMethods()) {
                    if (candidate.method != method) continue;
                    virtualTarget = candidate;
                    break;
                }
                if (virtualTarget != null) {
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.defaultAsMethodOfCompanionClass(method), invokeDirect.outValue(), invokeDirect.arguments()));
                    continue;
                }
                instructions.replaceCurrentInstruction(new InvokeStatic(this.privateAsMethodOfCompanionClass(method), invokeDirect.outValue(), invokeDirect.arguments()));
            }
        }
    }

    private void reportStaticInterfaceMethodHandle(DexMethod referencedFrom, DexMethodHandle handle) {
        if (handle.type.isInvokeStatic()) {
            DexClass holderClass = this.findDefinitionFor(handle.asMethod().holder);
            if (holderClass == null) {
                this.warnMissingType(referencedFrom, handle.asMethod().holder);
            } else if (holderClass.isInterface()) {
                throw new Unimplemented("Desugaring of static interface method handle as in `" + referencedFrom.toSourceString() + "` in is not yet supported.");
            }
        }
    }

    final DexClass findDefinitionFor(DexType type) {
        return this.converter.definitionFor(type);
    }

    final DexType getCompanionClassType(DexType type) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String ccTypeDescriptor = descriptor.substring(0, descriptor.length() - 1) + COMPANION_CLASS_NAME_SUFFIX + ";";
        return this.factory.createType(ccTypeDescriptor);
    }

    final DexType getDispatchClassType(DexType type) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String dcTypeDescriptor = descriptor.substring(0, descriptor.length() - 1) + DISPATCH_CLASS_NAME_SUFFIX + ";";
        return this.factory.createType(dcTypeDescriptor);
    }

    private boolean isCompanionClassType(DexType type) {
        return type.descriptor.toString().endsWith("$-CC;");
    }

    private DexType getInterfaceClassType(DexType type) {
        assert (this.isCompanionClassType(type));
        String descriptor = type.descriptor.toString();
        String interfaceTypeDescriptor = descriptor.substring(0, descriptor.length() - 1 - COMPANION_CLASS_NAME_SUFFIX.length()) + ";";
        return this.factory.createType(interfaceTypeDescriptor);
    }

    private boolean isInMainDexList(DexType iface) {
        return this.converter.appInfo.isInMainDexList(iface);
    }

    final DexMethod staticAsMethodOfCompanionClass(DexMethod method) {
        return this.factory.createMethod(this.getCompanionClassType(method.holder), method.proto, method.name);
    }

    final DexMethod staticAsMethodOfDispatchClass(DexMethod method) {
        return this.factory.createMethod(this.getDispatchClassType(method.holder), method.proto, method.name);
    }

    public static boolean hasDispatchClassSuffix(DexType clazz) {
        return clazz.getName().endsWith(DISPATCH_CLASS_NAME_SUFFIX);
    }

    private DexMethod instanceAsMethodOfCompanionClass(DexMethod method, String prefix) {
        DexType[] params = method.proto.parameters.values;
        DexType[] newParams = new DexType[params.length + 1];
        newParams[0] = method.holder;
        System.arraycopy(params, 0, newParams, 1, params.length);
        return this.factory.createMethod(this.getCompanionClassType(method.holder), this.factory.createProto(method.proto.returnType, newParams), this.factory.createString(prefix + method.name.toString()));
    }

    private DexMethod amendDefaultMethod(DexClass classToDesugar, DexMethod method) {
        DexMethod singleCandidate = this.getOrCreateInterfaceInfo(classToDesugar, classToDesugar, method.holder).getSingleCandidate(method);
        return singleCandidate != null ? singleCandidate : method;
    }

    final DexMethod defaultAsMethodOfCompanionClass(DexMethod method) {
        return this.instanceAsMethodOfCompanionClass(method, DEFAULT_METHOD_PREFIX);
    }

    final DexMethod privateAsMethodOfCompanionClass(DexMethod method) {
        return this.instanceAsMethodOfCompanionClass(method, PRIVATE_METHOD_PREFIX);
    }

    public void desugarInterfaceMethods(DexApplication.Builder<?> builder, Flavor flavour) {
        this.synthesizedMethods.addAll(this.processClasses(builder, flavour));
        Map<DexType, DexProgramClass> synthesizedClasses = this.processInterfaces(builder, flavour);
        for (Map.Entry<DexType, DexProgramClass> entry : synthesizedClasses.entrySet()) {
            builder.addSynthesizedClass(entry.getValue(), this.isInMainDexList(entry.getKey()));
        }
        for (DexEncodedMethod method : this.synthesizedMethods) {
            this.converter.optimizeSynthesizedMethod(method);
        }
        this.clear();
    }

    private void clear() {
        this.cache.clear();
        this.synthesizedMethods.clear();
        this.requiredDispatchClasses.clear();
    }

    private static boolean shouldProcess(DexProgramClass clazz, Flavor flavour, boolean mustBeInterface) {
        return (!clazz.originatesFromDexResource() || flavour == Flavor.IncludeAllResources) && clazz.isInterface() == mustBeInterface;
    }

    private Map<DexType, DexProgramClass> processInterfaces(DexApplication.Builder<?> builder, Flavor flavour) {
        InterfaceProcessor processor = new InterfaceProcessor(this);
        for (DexProgramClass dexProgramClass : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(dexProgramClass, flavour, true)) continue;
            processor.process(dexProgramClass.asProgramClass());
        }
        for (Map.Entry entry : this.requiredDispatchClasses.entrySet()) {
            this.synthesizedMethods.addAll(processor.process((DexLibraryClass)entry.getKey(), (Set)entry.getValue()));
        }
        if (!(!this.converter.enableWholeProgramOptimizations || processor.methodsWithMovedCode.isEmpty() && processor.movedMethods.isEmpty())) {
            this.converter.appView.setGraphLense(new InterfaceMethodDesugaringLense(processor.movedMethods, processor.methodsWithMovedCode, this.converter.appView.graphLense(), this.factory));
        }
        return processor.syntheticClasses;
    }

    private Set<DexEncodedMethod> processClasses(DexApplication.Builder<?> builder, Flavor flavour) {
        ClassProcessor processor = new ClassProcessor(this);
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(clazz, flavour, false)) continue;
            processor.process(clazz);
        }
        return processor.getForwardMethods();
    }

    final boolean isDefaultMethod(DexEncodedMethod method) {
        assert (!method.accessFlags.isConstructor());
        assert (!method.accessFlags.isStatic());
        if (method.accessFlags.isAbstract()) {
            return false;
        }
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native default interface methods are not yet supported.");
        }
        if (!method.accessFlags.isPublic()) {
            throw new Unimplemented("Non public default interface methods are not yet supported.");
        }
        return true;
    }

    public void warnMissingInterface(DexClass classToDesugar, DexClass implementing, DexType missing) {
        if (!this.reportedMissing.add(missing)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Interface `").append(missing.toSourceString()).append("` not found. It's needed to make sure desugaring of `").append(classToDesugar.toSourceString()).append("` is correct. Desugaring will assume that this interface has no default method.");
        if (classToDesugar != implementing) {
            builder.append(" This missing interface is declared in the direct hierarchy of `").append(implementing).append("`");
        }
        this.options.reporter.warning(new StringDiagnostic(builder.toString(), classToDesugar.getOrigin()));
    }

    private void warnMissingType(DexMethod referencedFrom, DexType missing) {
        if (!this.reportedMissing.add(missing)) {
            return;
        }
        DexMethod originalReferencedFrom = this.converter.graphLense().getOriginalMethodSignature(referencedFrom);
        StringBuilder builder = new StringBuilder();
        builder.append("Type `").append(missing.toSourceString()).append("` was not found, ").append("it is required for default or static interface methods desugaring of `").append(originalReferencedFrom.toSourceString()).append("`");
        this.options.reporter.warning(new StringDiagnostic(builder.toString(), this.getMethodOrigin(originalReferencedFrom)));
    }

    private Origin getMethodOrigin(DexMethod method) {
        DexClass clazz;
        DexType holder = method.getHolder();
        if (this.isCompanionClassType(holder)) {
            holder = this.getInterfaceClassType(holder);
        }
        return (clazz = this.converter.appInfo.definitionFor(holder)) == null ? Origin.unknown() : clazz.getOrigin();
    }

    final DefaultMethodsHelper.Collection getOrCreateInterfaceInfo(DexClass classToDesugar, DexClass implementing, DexType iface) {
        DefaultMethodsHelper.Collection collection = this.cache.get(iface);
        if (collection != null) {
            return collection;
        }
        collection = this.createInterfaceInfo(classToDesugar, implementing, iface);
        DefaultMethodsHelper.Collection existing = this.cache.putIfAbsent(iface, collection);
        return existing != null ? existing : collection;
    }

    private DefaultMethodsHelper.Collection createInterfaceInfo(DexClass classToDesugar, DexClass implementing, DexType iface) {
        DefaultMethodsHelper helper = new DefaultMethodsHelper();
        DexClass definedInterface = this.findDefinitionFor(iface);
        if (definedInterface == null) {
            this.warnMissingInterface(classToDesugar, implementing, iface);
            return helper.wrapInCollection();
        }
        if (!definedInterface.isInterface()) {
            throw new CompilationError("Type " + iface.toSourceString() + " is referenced as an interface from `" + implementing.toString() + "`.");
        }
        if (definedInterface.isLibraryClass()) {
            return helper.wrapInCollection();
        }
        for (DexType dexType : definedInterface.interfaces.values) {
            helper.merge(this.getOrCreateInterfaceInfo(classToDesugar, definedInterface, dexType));
        }
        for (DexItem dexItem : definedInterface.virtualMethods()) {
            helper.hideMatches(((DexEncodedMethod)dexItem).method);
        }
        for (DexItem dexItem : definedInterface.virtualMethods()) {
            if (!this.isDefaultMethod((DexEncodedMethod)dexItem)) continue;
            helper.addDefaultMethod((DexEncodedMethod)dexItem);
        }
        return helper.wrapInCollection();
    }

    public static enum Flavor {
        IncludeAllResources,
        ExcludeDexResources;

    }
}

