/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.InternalOptions;

public class DexItemBasedConstString
extends ConstInstruction {
    private final DexReference item;

    public DexItemBasedConstString(Value dest, DexReference item) {
        super(dest);
        dest.markNeverNull();
        this.item = item;
    }

    public static DexItemBasedConstString copyOf(Value newValue, DexItemBasedConstString original) {
        return new DexItemBasedConstString(newValue, original.getItem());
    }

    public DexReference getItem() {
        return this.item;
    }

    @Override
    public boolean isDexItemBasedConstString() {
        return true;
    }

    @Override
    public DexItemBasedConstString asDexItemBasedConstString() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.outValue(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.DexItemBasedConstString(dest, this.item));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isDexItemBasedConstString() && other.asDexItemBasedConstString().item == this.item;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "DexItemBasedConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.item.toSourceString() + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return false;
    }

    @Override
    public boolean canBeDeadCode(IRCode code, InternalOptions options) {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfDexItemBasedConstString(this.item));
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return helper.getFactory().stringType;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.stringType, false, appInfo);
    }
}

