/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.code.MoveObject;
import com.android.tools.r8.code.MoveObjectFrom16;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class CheckCast
extends Instruction {
    private final DexType type;

    public CheckCast(Value dest, Value value, DexType type) {
        super(dest, value);
        if (value.isNeverNull()) {
            dest.markNeverNull();
        }
        this.type = type;
    }

    @Override
    boolean computeNeverNull() {
        return this.object().isNeverNull();
    }

    public DexType getType() {
        return this.type;
    }

    public Value object() {
        return this.inValues().get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int inRegister = builder.allocatedRegister((Value)this.inValues.get(0), this.getNumber());
        if (this.outValue == null) {
            builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.CheckCast(inRegister, this.type));
        } else {
            int outRegister = builder.allocatedRegister(this.outValue, this.getNumber());
            if (inRegister == outRegister) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.CheckCast(outRegister, this.type));
            } else {
                com.android.tools.r8.code.CheckCast cast = new com.android.tools.r8.code.CheckCast(outRegister, this.type);
                if (outRegister <= 15 && inRegister <= 15) {
                    builder.add((Instruction)this, new MoveObject(outRegister, inRegister), cast);
                } else {
                    builder.add((Instruction)this, new MoveObjectFrom16(outRegister, inRegister), cast);
                }
            }
        }
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isCheckCast() && other.asCheckCast().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isCheckCast() {
        return true;
    }

    @Override
    public CheckCast asCheckCast() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; " + this.type;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forCheckCast(this.type, invocationContext);
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return this.object().getTypeLattice().checkCast(appInfo, this.type);
    }

    @Override
    public boolean verifyTypes(AppInfo appInfo, GraphLense graphLense) {
        assert (super.verifyTypes(appInfo, graphLense));
        TypeLatticeElement inType = this.object().getTypeLattice();
        assert (inType.isPreciseType());
        TypeLatticeElement outType = this.outValue().getTypeLattice();
        TypeLatticeElement castType = TypeLatticeElement.fromDexType(this.getType(), inType.isNullable(), appInfo);
        if (inType.lessThanOrEqual(castType, appInfo)) {
            assert (inType.lessThanOrEqual(outType, appInfo));
        } else {
            assert (castType.asNullable().equals(outType.asNullable()));
            assert (inType.nullElement().lessThanOrEqual(outType.nullElement()));
            assert (!inType.isNull());
        }
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfCheckCast(this.type));
    }
}

