/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.base.Objects;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class BasicBlockInstructionsEquivalence
extends Equivalence<BasicBlock> {
    private static final int UNKNOW_HASH = -1;
    private static final int MAX_HASH_INSTRUCTIONS = 5;
    private final RegisterAllocator allocator;
    private final int[] hashes;

    BasicBlockInstructionsEquivalence(IRCode code, RegisterAllocator allocator) {
        this.allocator = allocator;
        this.hashes = new int[code.getHighestBlockNumber() + 1];
        Arrays.fill(this.hashes, -1);
    }

    private boolean hasIdenticalInstructions(BasicBlock first, BasicBlock second) {
        CatchHandlers<BasicBlock> handlers1;
        LinkedList<Instruction> instructions0 = first.getInstructions();
        LinkedList<Instruction> instructions1 = second.getInstructions();
        if (instructions0.size() != instructions1.size()) {
            return false;
        }
        for (int i = 0; i < instructions0.size(); ++i) {
            Instruction i1;
            Instruction i0 = (Instruction)instructions0.get(i);
            if (i0.identicalAfterRegisterAllocation(i1 = (Instruction)instructions1.get(i), this.allocator)) continue;
            return false;
        }
        if (!Objects.equal(first.getLocalsAtEntry(), second.getLocalsAtEntry())) {
            return false;
        }
        CatchHandlers<BasicBlock> handlers0 = first.getCatchHandlers();
        if (!handlers0.equals(handlers1 = second.getCatchHandlers())) {
            return false;
        }
        assert (this.verifyAllSuccessors(first.getSuccessors(), second.getSuccessors()));
        return true;
    }

    private boolean verifyAllSuccessors(List<BasicBlock> successors0, List<BasicBlock> successors1) {
        if (successors0.size() != successors1.size()) {
            return false;
        }
        for (int i = 0; i < successors0.size(); ++i) {
            if (successors0.get(i) == successors1.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean doEquivalent(BasicBlock a, BasicBlock b) {
        return this.hasIdenticalInstructions(a, b);
    }

    void clearComputedHash(BasicBlock basicBlock) {
        this.hashes[basicBlock.getNumber()] = -1;
    }

    @Override
    protected int doHash(BasicBlock basicBlock) {
        int hash = this.hashes[basicBlock.getNumber()];
        if (hash != -1) {
            assert (hash == this.computeHash(basicBlock));
            return hash;
        }
        this.hashes[basicBlock.getNumber()] = hash = this.computeHash(basicBlock);
        return hash;
    }

    private int computeHash(BasicBlock basicBlock) {
        LinkedList<Instruction> instructions = basicBlock.getInstructions();
        int hash = instructions.size();
        for (int i = 0; i < instructions.size() && i < 5; ++i) {
            Instruction instruction = (Instruction)instructions.get(i);
            int hashPart = 0;
            if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
                hashPart += this.allocator.getRegisterForValue(instruction.outValue(), instruction.getNumber());
            }
            for (Value inValue : instruction.inValues()) {
                hashPart <<= 4;
                if (!inValue.needsRegister()) continue;
                hashPart += this.allocator.getRegisterForValue(inValue, instruction.getNumber());
            }
            hash = hash * 3 + hashPart;
        }
        return hash;
    }
}

