/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.DescriptorUtils;

public class ReflectionOptimizer {
    public static String computeClassName(DexString descriptor, DexClass holder, ClassNameComputationInfo classNameComputationInfo) {
        return ReflectionOptimizer.computeClassName(descriptor.toString(), holder, classNameComputationInfo.classNameComputationOption, classNameComputationInfo.arrayDepth);
    }

    public static String computeClassName(String descriptor, DexClass holder, ClassNameComputationInfo.ClassNameComputationOption classNameComputationOption, int arrayDepth) {
        String name;
        switch (classNameComputationOption) {
            case NAME: {
                name = DescriptorUtils.getClassNameFromDescriptor(descriptor);
                if (arrayDepth <= 0) break;
                name = Strings.repeat("[", arrayDepth) + "L" + name + ";";
                break;
            }
            case TYPE_NAME: {
                throw new Unreachable("Type#getTypeName not supported yet");
            }
            case CANONICAL_NAME: {
                name = DescriptorUtils.getCanonicalNameFromDescriptor(descriptor);
                if (arrayDepth <= 0) break;
                name = name + Strings.repeat("[]", arrayDepth);
                break;
            }
            case SIMPLE_NAME: {
                assert (holder != null);
                boolean renamed = !descriptor.equals(holder.type.toDescriptorString());
                boolean needsToRetrieveInnerName = holder.isMemberClass() || holder.isLocalClass();
                name = !renamed && needsToRetrieveInnerName ? holder.getInnerClassAttributeForThisClass().getInnerName().toString() : DescriptorUtils.getSimpleClassNameFromDescriptor(descriptor);
                if (arrayDepth <= 0) break;
                name = name + Strings.repeat("[]", arrayDepth);
                break;
            }
            default: {
                throw new Unreachable("Unexpected ClassNameComputationOption: '" + (Object)((Object)classNameComputationOption) + "'");
            }
        }
        return name;
    }

    public static class ClassNameComputationInfo {
        private static final ClassNameComputationInfo DEFAULT_INSTANCE = new ClassNameComputationInfo(ClassNameComputationOption.NONE, 0);
        final ClassNameComputationOption classNameComputationOption;
        final int arrayDepth;

        public ClassNameComputationInfo(ClassNameComputationOption classNameComputationOption, int arrayDepth) {
            this.classNameComputationOption = classNameComputationOption;
            this.arrayDepth = arrayDepth;
        }

        public static ClassNameComputationInfo none() {
            return DEFAULT_INSTANCE;
        }

        public boolean needsToComputeClassName() {
            return this.classNameComputationOption.needsToComputeClassName();
        }

        public boolean needsToRegisterTypeReference() {
            return this.classNameComputationOption.needsToRegisterTypeReference();
        }

        public static enum ClassNameComputationOption {
            NONE,
            NAME,
            TYPE_NAME,
            CANONICAL_NAME,
            SIMPLE_NAME;


            boolean needsToComputeClassName() {
                return this != NONE;
            }

            boolean needsToRegisterTypeReference() {
                return this == SIMPLE_NAME;
            }
        }
    }
}

