/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ArgumentUse;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.optimize.ArgumentRemovalUtils;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class UnusedArgumentsCollector {
    private final AppView<Enqueuer.AppInfoWithLiveness> appView;
    private final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments = new IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo>();

    public UnusedArgumentsCollector(AppView<Enqueuer.AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public GraphLense run() {
        this.appView.appInfo().classes().forEach(this::processClass);
        if (!this.methodMapping.isEmpty()) {
            return new UnusedArgumentsGraphLense(ImmutableMap.of(), this.methodMapping, ImmutableMap.of(), ImmutableBiMap.of(), this.methodMapping.inverse(), this.appView.graphLense(), this.appView.dexItemFactory(), this.removedArguments);
        }
        return this.appView.graphLense();
    }

    private void processClass(DexProgramClass clazz) {
        UsedSignatures signatures = new UsedSignatures();
        for (DexEncodedMethod method : clazz.methods()) {
            signatures.markSignatureAsUsed(method.method);
        }
        for (int i = 0; i < clazz.directMethods().length; ++i) {
            DexEncodedMethod newMethod;
            DexEncodedMethod method;
            method = clazz.directMethods()[i];
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused = this.collectUnusedArguments(method);
            if (unused == null) continue;
            clazz.directMethods()[i] = newMethod = signatures.removeArguments(method, unused);
            this.methodMapping.put(method.method, newMethod.method);
            this.removedArguments.put(newMethod.method, unused);
        }
    }

    private GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo collectUnusedArguments(DexEncodedMethod method) {
        if (ArgumentRemovalUtils.isPinned(method, this.appView)) {
            return null;
        }
        if (method.getCode() == null || !method.getCode().isJarCode()) {
            return null;
        }
        assert (method.getCode().getOwner() == method);
        int argumentCount = method.method.proto.parameters.size() + (method.accessFlags.isStatic() ? 0 : 1);
        if (!method.accessFlags.isStatic()) {
            return null;
        }
        CollectUsedArguments collector = new CollectUsedArguments();
        method.getCode().registerArgumentReferences(collector);
        BitSet used = collector.getUsedArguments();
        if (used.cardinality() < argumentCount) {
            ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo> unused = new ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo>();
            for (int i = 0; i < argumentCount; ++i) {
                if (used.get(i)) continue;
                unused.add(GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo.builder().setArgumentIndex(i).build());
            }
            return new GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo(unused);
        }
        return null;
    }

    private static class CollectUsedArguments
    extends ArgumentUse {
        private final BitSet used = new BitSet();

        private CollectUsedArguments() {
        }

        BitSet getUsedArguments() {
            return this.used;
        }

        @Override
        public boolean register(int argument) {
            this.used.set(argument);
            return true;
        }
    }

    private class UsedSignatures {
        private final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        private final Set<Equivalence.Wrapper<DexMethod>> usedSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();

        private UsedSignatures() {
        }

        private DexProto protoWithRemovedArguments(DexMethod method, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
            DexType[] parameters = new DexType[method.proto.parameters.size() - unused.numberOfRemovedArguments()];
            if (parameters.length > 0) {
                int newIndex = 0;
                for (int j = 0; j < method.proto.parameters.size(); ++j) {
                    if (unused.isArgumentRemoved(j)) continue;
                    parameters[newIndex++] = method.proto.parameters.values[j];
                }
                assert (newIndex == parameters.length);
            }
            return ((Enqueuer.AppInfoWithLiveness)((UnusedArgumentsCollector)UnusedArgumentsCollector.this).appView.appInfo()).dexItemFactory.createProto(method.proto.returnType, parameters);
        }

        private boolean isMethodSignatureAvailable(DexMethod method) {
            return !this.usedSignatures.contains(this.equivalence.wrap(method));
        }

        private void markSignatureAsUsed(DexMethod method) {
            this.usedSignatures.add(this.equivalence.wrap(method));
        }

        DexEncodedMethod removeArguments(DexEncodedMethod method, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
            DexMethod newSignature;
            boolean removed = this.usedSignatures.remove(this.equivalence.wrap(method.method));
            assert (removed);
            DexProto newProto = this.protoWithRemovedArguments(method.method, unused);
            int count = 0;
            DexString newName = null;
            do {
                newName = newName == null ? method.method.name : UnusedArgumentsCollector.this.appView.dexItemFactory().createString(method.method.name.toSourceString() + count);
                newSignature = UnusedArgumentsCollector.this.appView.dexItemFactory().createMethod(method.method.holder, newProto, newName);
                ++count;
            } while (!this.isMethodSignatureAvailable(newSignature));
            this.markSignatureAsUsed(newSignature);
            return method.toTypeSubstitutedMethod(newSignature);
        }
    }

    static class UnusedArgumentsGraphLense
    extends GraphLense.NestedGraphLense {
        private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments;

        UnusedArgumentsGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory, Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments) {
            super(typeMap, methodMap, fieldMap, originalFieldSignatures, originalMethodSignatures, previousLense, dexItemFactory);
            this.removedArguments = removedArguments;
        }

        @Override
        public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(method, method) : method;
            GraphLense.RewrittenPrototypeDescription result = this.previousLense.lookupPrototypeChanges(originalMethod);
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArguments = this.removedArguments.get(method);
            return removedArguments != null ? result.withRemovedArguments(removedArguments) : result;
        }
    }
}

