/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.shaking.VerticalClassMerger;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class VerticalClassMergerGraphLense
extends GraphLense.NestedGraphLense {
    private final AppInfo appInfo;
    private final Map<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>> contextualVirtualToDirectMethodMaps;
    private final Set<DexMethod> mergedMethods;
    private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges;

    public VerticalClassMergerGraphLense(AppInfo appInfo, Map<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, Set<DexMethod> mergedMethods, Map<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>> contextualVirtualToDirectMethodMaps, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, Map<DexMethod, DexMethod> originalMethodSignaturesForBridges, GraphLense previousLense) {
        super(ImmutableMap.of(), methodMap, fieldMap, originalFieldSignatures, originalMethodSignatures, previousLense, appInfo.dexItemFactory);
        this.appInfo = appInfo;
        this.contextualVirtualToDirectMethodMaps = contextualVirtualToDirectMethodMaps;
        this.mergedMethods = mergedMethods;
        this.originalMethodSignaturesForBridges = originalMethodSignaturesForBridges;
    }

    @Override
    public DexMethod getOriginalMethodSignature(DexMethod method) {
        return super.getOriginalMethodSignature(this.originalMethodSignaturesForBridges.getOrDefault(method, method));
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
        GraphLense.GraphLenseLookupResult lookup;
        Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap;
        assert (this.isContextFreeForMethod(method) || context != null && type != null);
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
        if (previous.getType() == Invoke.Type.SUPER && !this.mergedMethods.contains(context.method) && (virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context.method.holder)) != null && (lookup = virtualToDirectMethodMap.get(previous.getMethod())) != null) {
            return lookup;
        }
        return super.lookupMethod(previous.getMethod(), context, previous.getType());
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
        return super.mapVirtualInterfaceInvocationTypes(this.appInfo, newMethod, originalMethod, context, type);
    }

    @Override
    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
            builder.add(this.methodMap.getOrDefault(previous, previous));
            for (Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
                GraphLense.GraphLenseLookupResult lookup = virtualToDirectMethodMap.get(previous);
                if (lookup == null) continue;
                builder.add(lookup.getMethod());
            }
        }
        return builder.build();
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.contextualVirtualToDirectMethodMaps.isEmpty() && this.previousLense.isContextFreeForMethods();
    }

    @Override
    public boolean isContextFreeForMethod(DexMethod method) {
        if (!this.previousLense.isContextFreeForMethod(method)) {
            return false;
        }
        DexMethod previous = this.previousLense.lookupMethod(method);
        for (Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
            if (!virtualToDirectMethodMap.containsKey(previous)) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        protected final BiMap<DexField, DexField> fieldMap = HashBiMap.create();
        protected final Map<DexMethod, DexMethod> methodMap = new HashMap<DexMethod, DexMethod>();
        private final ImmutableSet.Builder<DexMethod> mergedMethodsBuilder = ImmutableSet.builder();
        private final Map<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>> contextualVirtualToDirectMethodMaps = new HashMap<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>>();
        private final BiMap<DexMethod, DexMethod> originalMethodSignatures = HashBiMap.create();
        private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges = new IdentityHashMap<DexMethod, DexMethod>();

        public GraphLense build(GraphLense previousLense, Map<DexType, DexType> mergedClasses, List<VerticalClassMerger.SynthesizedBridgeCode> synthesizedBridges, AppInfo appInfo) {
            if (this.fieldMap.isEmpty() && this.methodMap.isEmpty() && this.contextualVirtualToDirectMethodMaps.isEmpty()) {
                return previousLense;
            }
            HashMap<DexProto, DexProto> cache = new HashMap<DexProto, DexProto>();
            BiMap<DexField, DexField> originalFieldSignatures = this.fieldMap.inverse();
            Function<DexMethod, DexMethod> synthesizedBridgeTransformer = method -> Builder.getMethodSignatureAfterClassMerging(method, mergedClasses, appInfo.dexItemFactory, cache);
            for (VerticalClassMerger.SynthesizedBridgeCode synthesizedBridge : synthesizedBridges) {
                synthesizedBridge.updateMethodSignatures(synthesizedBridgeTransformer);
            }
            return new VerticalClassMergerGraphLense(appInfo, this.fieldMap, this.methodMap, Builder.getMergedMethodSignaturesAfterClassMerging((Set<DexMethod>)((Object)this.mergedMethodsBuilder.build()), mergedClasses, appInfo.dexItemFactory, cache), this.contextualVirtualToDirectMethodMaps, originalFieldSignatures, this.originalMethodSignatures, this.originalMethodSignaturesForBridges, previousLense);
        }

        private static Set<DexMethod> getMergedMethodSignaturesAfterClassMerging(Set<DexMethod> mergedMethods, Map<DexType, DexType> mergedClasses, DexItemFactory dexItemFactory, Map<DexProto, DexProto> cache) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (DexMethod signature : mergedMethods) {
                result.add(Builder.getMethodSignatureAfterClassMerging(signature, mergedClasses, dexItemFactory, cache));
            }
            return result.build();
        }

        private static DexMethod getMethodSignatureAfterClassMerging(DexMethod signature, Map<DexType, DexType> mergedClasses, DexItemFactory dexItemFactory, Map<DexProto, DexProto> cache) {
            DexType newHolder = mergedClasses.getOrDefault(signature.holder, signature.holder);
            DexProto newProto = dexItemFactory.applyClassMappingToProto(signature.proto, type -> mergedClasses.getOrDefault(type, (DexType)type), cache);
            if (signature.holder.equals(newHolder) && signature.proto.equals(newProto)) {
                return signature;
            }
            return dexItemFactory.createMethod(newHolder, newProto, signature.name);
        }

        public boolean hasMappingForSignatureInContext(DexType context, DexMethod signature) {
            Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context);
            if (virtualToDirectMethodMap != null) {
                return virtualToDirectMethodMap.containsKey(signature);
            }
            return false;
        }

        public void markMethodAsMerged(DexMethod method) {
            this.mergedMethodsBuilder.add((Object)method);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
        }

        public void recordMove(DexMethod from, DexMethod to) {
            this.originalMethodSignatures.put(to, from);
        }

        public void recordCreationOfBridgeMethod(DexMethod from, DexMethod to) {
            this.originalMethodSignaturesForBridges.put(to, from);
        }

        public void mapVirtualMethodToDirectInType(DexMethod from, GraphLense.GraphLenseLookupResult to, DexType type) {
            Map virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.computeIfAbsent(type, key -> new HashMap());
            virtualToDirectMethodMap.put(from, to);
        }

        public void merge(Builder builder) {
            this.fieldMap.putAll(builder.fieldMap);
            this.methodMap.putAll(builder.methodMap);
            this.mergedMethodsBuilder.addAll((Iterable)builder.mergedMethodsBuilder.build());
            this.originalMethodSignatures.putAll(builder.originalMethodSignatures);
            this.originalMethodSignaturesForBridges.putAll(builder.originalMethodSignaturesForBridges);
            for (DexType context : builder.contextualVirtualToDirectMethodMaps.keySet()) {
                Map<DexMethod, GraphLense.GraphLenseLookupResult> current = this.contextualVirtualToDirectMethodMaps.get(context);
                Map<DexMethod, GraphLense.GraphLenseLookupResult> other = builder.contextualVirtualToDirectMethodMaps.get(context);
                if (current != null) {
                    current.putAll(other);
                    continue;
                }
                this.contextualVirtualToDirectMethodMaps.put(context, other);
            }
        }
    }
}

