/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DirectMappedDexApplication
extends DexApplication {
    private final LazyLoadedDexApplication.AllClasses allClasses;
    private final ImmutableMap<DexType, DexLibraryClass> libraryClasses;

    private DirectMappedDexApplication(ClassNameMapper proguardMap, LazyLoadedDexApplication.AllClasses allClasses, ProgramClassCollection programClasses, ImmutableList<ProgramResourceProvider> programResourceProviders, ImmutableMap<DexType, DexLibraryClass> libraryClasses, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, programClasses, programResourceProviders, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.allClasses = allClasses;
        this.libraryClasses = libraryClasses;
    }

    public Collection<DexLibraryClass> libraryClasses() {
        return this.libraryClasses.values();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        Object result = this.programClasses.get(type);
        if (result == null) {
            result = this.libraryClasses.get(type);
        }
        return result;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return this;
    }

    @Override
    public DirectMappedDexApplication asDirect() {
        return this;
    }

    @Override
    public String toString() {
        return "DexApplication (direct)";
    }

    public DirectMappedDexApplication rewrittenWithLense(GraphLense graphLense) {
        assert (this.mappingIsValid(graphLense, this.programClasses.getAllTypes()));
        assert (this.mappingIsValid(graphLense, this.libraryClasses.keySet()));
        return this.builder().build().asDirect();
    }

    private boolean mappingIsValid(GraphLense graphLense, Iterable<DexType> types) {
        for (DexType type : types) {
            DexType renamed = graphLense.lookupType(type);
            if (renamed == type || this.definitionFor((DexType)type).type == renamed || this.definitionFor(renamed) != null) continue;
            return false;
        }
        return true;
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private final LazyLoadedDexApplication.AllClasses allClasses;
        private final List<DexLibraryClass> libraryClasses = new ArrayList<DexLibraryClass>();

        Builder(LazyLoadedDexApplication application) {
            super(application);
            this.allClasses = application.loadAllClasses();
            Map<DexType, DexClass> allClasses = this.allClasses.getClasses();
            Iterables.filter(allClasses.values(), DexLibraryClass.class).forEach(this.libraryClasses::add);
        }

        private Builder(DirectMappedDexApplication application) {
            super(application);
            this.allClasses = application.allClasses;
            this.libraryClasses.addAll(application.libraryClasses.values());
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public DexApplication build() {
            return new DirectMappedDexApplication(this.proguardMap, this.allClasses, ProgramClassCollection.create(this.programClasses, ProgramClassCollection::resolveClassConflictImpl), ImmutableList.copyOf(this.programResourceProviders), this.libraryClasses.stream().collect(ImmutableMap.toImmutableMap(c -> c.type, c -> c)), ImmutableSet.copyOf(this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }
}

