/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Arrays;
import java.util.List;

public class AnnotationRemover {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense lense;
    private final ProguardKeepAttributes keep;
    private final InternalOptions options;

    public AnnotationRemover(Enqueuer.AppInfoWithLiveness appInfo, GraphLense lense, InternalOptions options) {
        this.appInfo = appInfo;
        this.lense = lense;
        this.keep = options.getProguardConfiguration().getKeepAttributes();
        this.options = options;
    }

    private boolean filterAnnotations(DexAnnotation annotation) {
        return AnnotationRemover.shouldKeepAnnotation(annotation, this.isAnnotationTypeLive(annotation), this.appInfo.dexItemFactory, this.options);
    }

    static boolean shouldKeepAnnotation(DexAnnotation annotation, boolean isAnnotationTypeLive, DexItemFactory dexItemFactory, InternalOptions options) {
        ProguardKeepAttributes config = options.getProguardConfiguration() != null ? options.getProguardConfiguration().getKeepAttributes() : ProguardKeepAttributes.fromPatterns(ImmutableList.of());
        switch (annotation.visibility) {
            case 2: {
                assert (!DexAnnotation.isInnerClassAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isMemberClassesAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isEnclosingMethodAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isEnclosingClassAnnotation(annotation, dexItemFactory));
                if (config.exceptions && DexAnnotation.isThrowingAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (config.signature && DexAnnotation.isSignatureAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (config.sourceDebugExtension && DexAnnotation.isSourceDebugExtension(annotation, dexItemFactory)) {
                    return true;
                }
                if (options.canUseParameterNameAnnotations() && DexAnnotation.isParameterNameAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                return DexAnnotation.isAnnotationDefaultAnnotation(annotation, dexItemFactory);
            }
            case 1: {
                if (!config.runtimeVisibleAnnotations) {
                    return false;
                }
                return isAnnotationTypeLive;
            }
            case 0: {
                if (DexAnnotation.isSynthesizedClassMapAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (!config.runtimeInvisibleAnnotations) {
                    return false;
                }
                return isAnnotationTypeLive;
            }
        }
        throw new Unreachable("Unexpected annotation visibility.");
    }

    private boolean isAnnotationTypeLive(DexAnnotation annotation) {
        DexType annotationType = annotation.annotation.type.toBaseType(this.appInfo.dexItemFactory);
        DexClass definition = this.appInfo.definitionFor(annotationType);
        if (this.options.enableTreeShaking && definition == null) {
            return false;
        }
        return definition == null || definition.isLibraryClass() || this.appInfo.liveTypes.contains(annotationType);
    }

    private boolean filterParameterAnnotations(DexAnnotation annotation) {
        switch (annotation.visibility) {
            case 2: {
                return false;
            }
            case 1: {
                if (this.keep.runtimeVisibleParameterAnnotations) break;
                return false;
            }
            case 0: {
                if (this.keep.runtimeInvisibleParameterAnnotations) break;
                return false;
            }
            default: {
                throw new Unreachable("Unexpected annotation visibility.");
            }
        }
        return this.isAnnotationTypeLive(annotation);
    }

    public AnnotationRemover ensureValid(ProguardConfiguration.Builder compatibility) {
        this.keep.ensureValid(this.options.forceProguardCompatibility, compatibility);
        return this;
    }

    public void run() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            this.stripAttributes(clazz);
            clazz.annotations = clazz.annotations.rewrite(this::rewriteAnnotation);
            clazz.forEachMethod(this::processMethod);
            clazz.forEachField(this::processField);
        }
    }

    private void processMethod(DexEncodedMethod method) {
        method.annotations = method.annotations.rewrite(this::rewriteAnnotation);
        method.parameterAnnotationsList = method.parameterAnnotationsList.keepIf(this::filterParameterAnnotations);
    }

    private void processField(DexEncodedField field) {
        field.annotations = field.annotations.rewrite(this::rewriteAnnotation);
    }

    private DexAnnotation rewriteAnnotation(DexAnnotation original) {
        if (!this.filterAnnotations(original)) {
            return null;
        }
        return original.rewrite(this::rewriteEncodedAnnotation);
    }

    private DexEncodedAnnotation rewriteEncodedAnnotation(DexEncodedAnnotation original) {
        DexType annotationType = original.type.toBaseType(this.appInfo.dexItemFactory);
        return original.rewrite(this.lense::lookupType, element -> this.rewriteAnnotationElement(this.lense.lookupType(annotationType), (DexAnnotationElement)element));
    }

    private DexAnnotationElement rewriteAnnotationElement(DexType annotationType, DexAnnotationElement original) {
        DexClass definition = this.appInfo.definitionFor(annotationType);
        if (definition == null) {
            return original;
        }
        assert (definition.isInterface());
        boolean liveGetter = Arrays.stream(definition.virtualMethods()).anyMatch(method -> method.method.name == original.name);
        return liveGetter ? original : null;
    }

    private boolean enclosingMethodPinned(DexClass clazz) {
        return clazz.getEnclosingMethod() != null && clazz.getEnclosingMethod().getEnclosingClass() != null && this.appInfo.isPinned(clazz.getEnclosingMethod().getEnclosingClass());
    }

    private boolean innerClassPinned(DexClass clazz) {
        List<InnerClassAttribute> innerClasses = clazz.getInnerClasses();
        for (InnerClassAttribute innerClass : innerClasses) {
            if (this.appInfo.isPinned(innerClass.getInner())) {
                return true;
            }
            if (!this.appInfo.isPinned(innerClass.getOuter())) continue;
            return true;
        }
        return false;
    }

    private void stripAttributes(DexProgramClass clazz) {
        if (this.appInfo.isPinned(clazz.type) || this.enclosingMethodPinned(clazz) || this.innerClassPinned(clazz) || this.options.forceProguardCompatibility) {
            if (!this.keep.enclosingMethod) {
                clazz.clearEnclosingMethod();
            }
            if (!this.keep.innerClasses) {
                clazz.clearInnerClasses();
            }
        } else {
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }
}

