/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class ProguardClassSpecification {
    private final Origin origin;
    private final Position position;
    private final String source;
    private final ProguardTypeMatcher classAnnotation;
    private final ProguardAccessFlags classAccessFlags;
    private final ProguardAccessFlags negatedClassAccessFlags;
    private final boolean classTypeNegated;
    private final ProguardClassType classType;
    private final ProguardClassNameList classNames;
    private final ProguardTypeMatcher inheritanceAnnotation;
    private final ProguardTypeMatcher inheritanceClassName;
    private final boolean inheritanceIsExtends;
    private final List<ProguardMemberRule> memberRules;

    protected ProguardClassSpecification(Origin origin, Position position, String source, ProguardTypeMatcher classAnnotation, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, ProguardTypeMatcher inheritanceAnnotation, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules) {
        assert (origin != null);
        assert (position != null);
        assert (source != null || origin != Origin.unknown());
        this.origin = origin;
        this.position = position;
        this.source = source;
        this.classAnnotation = classAnnotation;
        this.classAccessFlags = classAccessFlags;
        this.negatedClassAccessFlags = negatedClassAccessFlags;
        this.classTypeNegated = classTypeNegated;
        this.classType = classType;
        assert (classType != null);
        this.classNames = classNames;
        this.inheritanceAnnotation = inheritanceAnnotation;
        this.inheritanceClassName = inheritanceClassName;
        this.inheritanceIsExtends = inheritanceIsExtends;
        this.memberRules = memberRules;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getSource() {
        return this.source;
    }

    public List<ProguardMemberRule> getMemberRules() {
        return this.memberRules;
    }

    public boolean getInheritanceIsExtends() {
        return this.inheritanceIsExtends;
    }

    public boolean getInheritanceIsImplements() {
        return !this.inheritanceIsExtends;
    }

    public boolean hasInheritanceClassName() {
        return this.inheritanceClassName != null;
    }

    public ProguardTypeMatcher getInheritanceClassName() {
        return this.inheritanceClassName;
    }

    public ProguardTypeMatcher getInheritanceAnnotation() {
        return this.inheritanceAnnotation;
    }

    public ProguardClassNameList getClassNames() {
        return this.classNames;
    }

    public ProguardClassType getClassType() {
        return this.classType;
    }

    public boolean getClassTypeNegated() {
        return this.classTypeNegated;
    }

    public ProguardAccessFlags getClassAccessFlags() {
        return this.classAccessFlags;
    }

    public ProguardAccessFlags getNegatedClassAccessFlags() {
        return this.negatedClassAccessFlags;
    }

    public ProguardTypeMatcher getClassAnnotation() {
        return this.classAnnotation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProguardClassSpecification)) {
            return false;
        }
        ProguardClassSpecification that = (ProguardClassSpecification)o;
        if (this.classTypeNegated != that.classTypeNegated) {
            return false;
        }
        if (this.inheritanceIsExtends != that.inheritanceIsExtends) {
            return false;
        }
        if (!Objects.equals(this.classAnnotation, that.classAnnotation)) {
            return false;
        }
        if (!this.classAccessFlags.equals(that.classAccessFlags)) {
            return false;
        }
        if (!this.negatedClassAccessFlags.equals(that.negatedClassAccessFlags)) {
            return false;
        }
        if (this.classType != that.classType) {
            return false;
        }
        if (!this.classNames.equals(that.classNames)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceAnnotation, that.inheritanceAnnotation)) {
            return false;
        }
        if (!Objects.equals(this.inheritanceClassName, that.inheritanceClassName)) {
            return false;
        }
        return this.memberRules.equals(that.memberRules);
    }

    public int hashCode() {
        int result = this.classAnnotation != null ? this.classAnnotation.hashCode() : 0;
        result = 3 * result + this.classAccessFlags.hashCode();
        result = 3 * result + this.negatedClassAccessFlags.hashCode();
        result = 3 * result + (this.classTypeNegated ? 1 : 0);
        result = 3 * result + (this.classType != null ? this.classType.hashCode() : 0);
        result = 3 * result + this.classNames.hashCode();
        result = 3 * result + (this.inheritanceAnnotation != null ? this.inheritanceAnnotation.hashCode() : 0);
        result = 3 * result + (this.inheritanceClassName != null ? this.inheritanceClassName.hashCode() : 0);
        result = 3 * result + (this.inheritanceIsExtends ? 1 : 0);
        result = 3 * result + this.memberRules.hashCode();
        return result;
    }

    protected StringBuilder append(StringBuilder builder, boolean includeMemberRules) {
        boolean needsSpaceBeforeClassType = StringUtils.appendNonEmpty(builder, "@", this.classAnnotation, null) | StringUtils.appendNonEmpty(builder, "", this.classAccessFlags, null) | StringUtils.appendNonEmpty(builder, "!", this.negatedClassAccessFlags.toString().replace(" ", " !"), null);
        if (needsSpaceBeforeClassType) {
            builder.append(' ');
        }
        if (this.classTypeNegated) {
            builder.append('!');
        }
        builder.append((Object)this.classType);
        builder.append(' ');
        this.classNames.writeTo(builder);
        if (this.hasInheritanceClassName()) {
            builder.append(' ').append(this.inheritanceIsExtends ? "extends" : "implements");
            StringUtils.appendNonEmpty(builder, "@", this.inheritanceAnnotation, null);
            builder.append(' ');
            builder.append(this.inheritanceClassName);
        }
        if (includeMemberRules && !this.memberRules.isEmpty()) {
            builder.append(" {").append(System.lineSeparator());
            this.memberRules.forEach(memberRule -> {
                builder.append("  ");
                builder.append(memberRule);
                builder.append(";").append(System.lineSeparator());
            });
            builder.append("}");
        }
        return builder;
    }

    public String toShortString() {
        return this.append(new StringBuilder(), false).toString();
    }

    public String toString() {
        return this.append(new StringBuilder(), true).toString();
    }

    public static abstract class Builder<C extends ProguardClassSpecification, B extends Builder<C, B>> {
        protected Origin origin;
        protected Position start;
        protected Position end;
        protected String source;
        protected ProguardTypeMatcher classAnnotation;
        protected ProguardAccessFlags classAccessFlags = new ProguardAccessFlags();
        protected ProguardAccessFlags negatedClassAccessFlags = new ProguardAccessFlags();
        protected boolean classTypeNegated = false;
        protected ProguardClassType classType = ProguardClassType.UNSPECIFIED;
        protected ProguardClassNameList classNames;
        protected ProguardTypeMatcher inheritanceAnnotation;
        protected ProguardTypeMatcher inheritanceClassName;
        protected boolean inheritanceIsExtends = false;
        protected List<ProguardMemberRule> memberRules = new LinkedList<ProguardMemberRule>();

        protected Builder() {
            this(Origin.unknown(), Position.UNKNOWN);
        }

        protected Builder(Origin origin, Position start) {
            this.origin = origin;
            this.start = start;
        }

        public abstract C build();

        public abstract B self();

        public B setOrigin(Origin origin) {
            this.origin = origin;
            return this.self();
        }

        public B setStart(Position start) {
            this.start = start;
            return this.self();
        }

        public B setEnd(Position end) {
            this.end = end;
            return this.self();
        }

        public B setSource(String source) {
            this.source = source;
            return this.self();
        }

        public Position getPosition() {
            if (this.start == null) {
                return Position.UNKNOWN;
            }
            if (this.end == null || !(this.start instanceof TextPosition) || !(this.end instanceof TextPosition)) {
                return this.start;
            }
            return new TextRange((TextPosition)this.start, (TextPosition)this.end);
        }

        public List<ProguardMemberRule> getMemberRules() {
            return this.memberRules;
        }

        public B setMemberRules(List<ProguardMemberRule> memberRules) {
            this.memberRules = memberRules;
            return this.self();
        }

        public boolean getInheritanceIsExtends() {
            return this.inheritanceIsExtends;
        }

        public void setInheritanceIsExtends(boolean inheritanceIsExtends) {
            this.inheritanceIsExtends = inheritanceIsExtends;
        }

        public boolean hasInheritanceClassName() {
            return this.inheritanceClassName != null;
        }

        public ProguardTypeMatcher getInheritanceClassName() {
            return this.inheritanceClassName;
        }

        public void setInheritanceClassName(ProguardTypeMatcher inheritanceClassName) {
            this.inheritanceClassName = inheritanceClassName;
        }

        public ProguardTypeMatcher getInheritanceAnnotation() {
            return this.inheritanceAnnotation;
        }

        public void setInheritanceAnnotation(ProguardTypeMatcher inheritanceAnnotation) {
            this.inheritanceAnnotation = inheritanceAnnotation;
        }

        public ProguardClassNameList getClassNames() {
            return this.classNames;
        }

        public B setClassNames(ProguardClassNameList classNames) {
            this.classNames = classNames;
            return this.self();
        }

        public ProguardClassType getClassType() {
            return this.classType;
        }

        public B setClassType(ProguardClassType classType) {
            this.classType = classType;
            return this.self();
        }

        public boolean getClassTypeNegated() {
            return this.classTypeNegated;
        }

        public void setClassTypeNegated(boolean classTypeNegated) {
            this.classTypeNegated = classTypeNegated;
        }

        public ProguardAccessFlags getClassAccessFlags() {
            return this.classAccessFlags;
        }

        public void setClassAccessFlags(ProguardAccessFlags flags) {
            this.classAccessFlags = flags;
        }

        public ProguardAccessFlags getNegatedClassAccessFlags() {
            return this.negatedClassAccessFlags;
        }

        public void setNegatedClassAccessFlags(ProguardAccessFlags flags) {
            this.negatedClassAccessFlags = flags;
        }

        public ProguardTypeMatcher getClassAnnotation() {
            return this.classAnnotation;
        }

        public void setClassAnnotation(ProguardTypeMatcher classAnnotation) {
            this.classAnnotation = classAnnotation;
        }

        protected void matchAllSpecification() {
            this.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.defaultAllMatcher()));
            this.setMemberRules(ImmutableList.of(ProguardMemberRule.defaultKeepAllRule()));
        }
    }
}

