/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;

public class DexProto
extends IndexedDexItem
implements PresortedComparable<DexProto> {
    public static final DexProto SENTINEL = new DexProto(null, null, null);
    public final DexString shorty;
    public final DexType returnType;
    public final DexTypeList parameters;

    DexProto(DexString shorty, DexType returnType, DexTypeList parameters) {
        this.shorty = shorty;
        this.returnType = returnType;
        this.parameters = parameters;
    }

    @Override
    public int computeHashCode() {
        return this.shorty.hashCode() + this.returnType.hashCode() * 7 + this.parameters.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexProto) {
            DexProto o = (DexProto)other;
            return this.shorty.equals(o.shorty) && this.returnType.equals(o.returnType) && this.parameters.equals(o.parameters);
        }
        return false;
    }

    public String toString() {
        return "Proto " + this.shorty + " " + this.returnType + " " + this.parameters;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        if (indexedItems.addProto(this)) {
            this.shorty.collectIndexedItems(indexedItems, method, instructionOffset);
            this.returnType.collectIndexedItems(indexedItems, method, instructionOffset);
            this.parameters.collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public int compareTo(DexProto other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexProto other) {
        int result = this.returnType.slowCompareTo(other.returnType);
        if (result == 0) {
            result = this.parameters.slowCompareTo(other.parameters);
        }
        return result;
    }

    @Override
    public int slowCompareTo(DexProto other, NamingLens namingLens) {
        int result = this.returnType.slowCompareTo(other.returnType, namingLens);
        if (result == 0) {
            result = this.parameters.slowCompareTo(other.parameters, namingLens);
        }
        return result;
    }

    @Override
    public int layeredCompareTo(DexProto other, NamingLens namingLens) {
        int result = this.returnType.compareTo(other.returnType);
        if (result == 0) {
            result = this.parameters.compareTo(other.parameters);
        }
        return result;
    }

    @Override
    public String toSmaliString() {
        return this.toDescriptorString();
    }

    public String toDescriptorString() {
        return this.toDescriptorString(NamingLens.getIdentityLens());
    }

    public String toDescriptorString(NamingLens lens) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < this.parameters.values.length; ++i) {
            builder.append(lens.lookupDescriptor(this.parameters.values[i]));
        }
        builder.append(")");
        builder.append(lens.lookupDescriptor(this.returnType));
        return builder.toString();
    }
}

