/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;
import java.util.List;

public abstract class InvokeMethod
extends Invoke {
    private final DexMethod method;

    public InvokeMethod(DexMethod target, Value result, List<Value> arguments) {
        super(result, arguments);
        this.method = target;
    }

    @Override
    public DexType getReturnType() {
        return this.method.proto.returnType;
    }

    public DexMethod getInvokedMethod() {
        return this.method;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeMethod() && this.method == other.asInvokeMethod().getInvokedMethod();
    }

    @Override
    public String toString() {
        return super.toString() + "; method: " + this.method.toSourceString();
    }

    @Override
    public boolean isInvokeMethod() {
        return true;
    }

    @Override
    public InvokeMethod asInvokeMethod() {
        return this;
    }

    public abstract DexEncodedMethod lookupSingleTarget(Enqueuer.AppInfoWithLiveness var1, DexType var2);

    public abstract Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping var1, DexType var2);

    public abstract Inliner.InlineAction computeInlining(InliningOracle var1, DexType var2);

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        if (!super.identicalAfterRegisterAllocation(other, allocator)) {
            return false;
        }
        if (allocator.getOptions().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            InvokeMethod invoke = other.asInvokeMethod();
            for (int i = 0; i < this.arguments().size(); ++i) {
                Value argument = this.arguments().get(i);
                if (!argument.getTypeLattice().isArrayType() || argument == invoke.arguments().get(i)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        if (this.getReturnType().isVoidType()) {
            return;
        }
        if (this.outValue == null) {
            helper.popOutType(this.getReturnType(), this, it);
        } else {
            assert (this.outValue.isUsed());
            helper.storeOutValue(this, it);
        }
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.getReturnType();
    }
}

