/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public class MethodPoolCollection {
    private static final Equivalence<DexMethod> equivalence = MethodSignatureEquivalence.get();
    private final AppView<? extends AppInfo> appView;
    private final Map<DexClass, MethodPool> methodPools = new ConcurrentHashMap<DexClass, MethodPool>();

    public MethodPoolCollection(AppView<? extends AppInfo> appView) {
        this.appView = appView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAll(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building method pool collection");
        try {
            ArrayList futures = new ArrayList();
            Iterable<DexProgramClass> classes = this.appView.appInfo().classes();
            this.submitAll(classes, futures, executorService);
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodPool buildForHierarchy(DexClass clazz, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building method pool collection");
        try {
            ArrayList futures = new ArrayList();
            this.submitAll(this.getAllSuperTypesInclusive(clazz, this.methodPools::containsKey), futures, executorService);
            this.submitAll(this.getAllSubTypesExclusive(clazz, this.methodPools::containsKey), futures, executorService);
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
        return this.get(clazz);
    }

    public MethodPool get(DexClass clazz) {
        assert (this.methodPools.containsKey(clazz));
        return this.methodPools.get(clazz);
    }

    public boolean markIfNotSeen(DexClass clazz, DexMethod method) {
        Equivalence.Wrapper<DexMethod> key;
        MethodPool methodPool = this.get(clazz);
        if (methodPool.hasSeen(key = equivalence.wrap(method))) {
            return true;
        }
        methodPool.seen(key);
        return false;
    }

    private void submitAll(Iterable<? extends DexClass> classes, List<Future<?>> futures, ExecutorService executorService) {
        for (DexClass dexClass : classes) {
            futures.add(executorService.submit(this.computeMethodPoolPerClass(dexClass)));
        }
    }

    private Runnable computeMethodPoolPerClass(DexClass clazz) {
        return () -> {
            DexClass superClazz;
            MethodPool methodPool = this.methodPools.computeIfAbsent(clazz, k -> new MethodPool());
            clazz.forEachMethod(encodedMethod -> {
                if (!encodedMethod.isPrivateMethod() || encodedMethod.isStatic()) {
                    methodPool.seen(equivalence.wrap(encodedMethod.method));
                }
            });
            if (clazz.superType != null && (superClazz = this.appView.definitionFor(clazz.superType)) != null) {
                MethodPool superPool = this.methodPools.computeIfAbsent(superClazz, k -> new MethodPool());
                superPool.linkSubtype(methodPool);
                methodPool.linkSupertype(superPool);
            }
            if (clazz.isInterface()) {
                for (DexType subtype : clazz.type.allImmediateSubtypes()) {
                    DexClass subClazz = this.appView.definitionFor(subtype);
                    if (subClazz == null) continue;
                    MethodPool childPool = this.methodPools.computeIfAbsent(subClazz, k -> new MethodPool());
                    methodPool.linkSubtype(childPool);
                    childPool.linkInterface(methodPool);
                }
            }
        };
    }

    private Set<DexClass> getAllSuperTypesInclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> superTypes = new HashSet<DexClass>();
        ArrayDeque<DexClass> worklist = new ArrayDeque<DexClass>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !superTypes.add(clazz)) continue;
            if (clazz.superType != null) {
                MethodPoolCollection.addNonNull(worklist, this.appView.definitionFor(clazz.superType));
            }
            for (DexType interfaceType : clazz.interfaces.values) {
                MethodPoolCollection.addNonNull(worklist, this.appView.definitionFor(interfaceType));
            }
        }
        return superTypes;
    }

    private Set<DexClass> getAllSubTypesExclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> subTypes = new HashSet<DexClass>();
        ArrayDeque worklist = new ArrayDeque();
        subject.type.forAllExtendsSubtypes(type -> MethodPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        subject.type.forAllImplementsSubtypes(type -> MethodPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !subTypes.add(clazz)) continue;
            clazz.type.forAllExtendsSubtypes(type -> MethodPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
            clazz.type.forAllImplementsSubtypes(type -> MethodPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        }
        return subTypes;
    }

    private static <T> void addNonNull(Collection<T> collection, T item) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static class MethodPool {
        private MethodPool superType;
        private final Set<MethodPool> interfaces = new HashSet<MethodPool>();
        private final Set<MethodPool> subTypes = new HashSet<MethodPool>();
        private final Set<Equivalence.Wrapper<DexMethod>> methodPool = new HashSet<Equivalence.Wrapper<DexMethod>>();

        private MethodPool() {
        }

        synchronized void linkSupertype(MethodPool superType) {
            assert (this.superType == null);
            this.superType = superType;
        }

        synchronized void linkSubtype(MethodPool subType) {
            boolean added = this.subTypes.add(subType);
            assert (added);
        }

        synchronized void linkInterface(MethodPool itf) {
            boolean added = this.interfaces.add(itf);
            assert (added);
        }

        public void seen(DexMethod method) {
            this.seen(MethodSignatureEquivalence.get().wrap(method));
        }

        public synchronized void seen(Equivalence.Wrapper<DexMethod> method) {
            boolean added = this.methodPool.add(method);
            assert (added);
        }

        public boolean hasSeen(Equivalence.Wrapper<DexMethod> method) {
            return this.hasSeenUpwardRecursive(method) || this.hasSeenDownwardRecursive(method);
        }

        public boolean hasSeenDirectly(Equivalence.Wrapper<DexMethod> method) {
            return this.methodPool.contains(method);
        }

        private boolean hasSeenUpwardRecursive(Equivalence.Wrapper<DexMethod> method) {
            return this.methodPool.contains(method) || this.superType != null && this.superType.hasSeenUpwardRecursive(method) || this.interfaces.stream().anyMatch(itf -> itf.hasSeenUpwardRecursive(method));
        }

        private boolean hasSeenDownwardRecursive(Equivalence.Wrapper<DexMethod> method) {
            return this.methodPool.contains(method) || this.subTypes.stream().anyMatch(subType -> subType.hasSeenDownwardRecursive(method));
        }
    }
}

