/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.naming.ClassNamingForMapApplier;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMapError;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.ThrowingConsumer;
import com.android.tools.r8.utils.Timing;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ProguardMapApplier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense previousLense;
    private final SeedMapper seedMapper;

    public ProguardMapApplier(AppView<Enqueuer.AppInfoWithLiveness> appView, SeedMapper seedMapper) {
        assert (appView.graphLense().isContextFreeForMethods());
        this.appInfo = appView.appInfo();
        this.previousLense = appView.graphLense();
        this.seedMapper = seedMapper;
    }

    public GraphLense run(Timing timing) {
        timing.begin("from-pg-map-to-lense");
        GraphLense lenseFromMap = new MapToLenseConverter().run();
        timing.end();
        timing.begin("fix-types-in-programs");
        GraphLense typeFixedLense = new TreeFixer(lenseFromMap).run();
        timing.end();
        return typeFixedLense;
    }

    private static class ConflictFreeBuilder
    extends GraphLense.Builder {
        ConflictFreeBuilder() {
        }

        @Override
        public void map(DexType from, DexType to) {
            String keptName;
            if (this.typeMap.containsKey(from) && !(keptName = ((DexType)this.typeMap.get(from)).getName()).equals(to.getName())) {
                throw ProguardMapError.keptTypeWasRenamed(from, keptName, to.getName());
            }
            super.map(from, to);
        }

        @Override
        public void map(DexMethod from, DexMethod to) {
            String keptName;
            if (this.methodMap.containsKey(from) && !(keptName = ((DexMethod)this.methodMap.get((Object)from)).name.toString()).equals(to.name.toString())) {
                throw ProguardMapError.keptMethodWasRenamed(from, keptName, to.name.toString());
            }
            super.map(from, to);
        }

        @Override
        public void map(DexField from, DexField to) {
            String keptName;
            if (this.fieldMap.containsKey(from) && !(keptName = ((DexField)this.fieldMap.get((Object)from)).name.toString()).equals(to.name.toString())) {
                throw ProguardMapError.keptFieldWasRenamed(from, keptName, to.name.toString());
            }
            super.map(from, to);
        }

        DexType lookup(DexType from) {
            return this.typeMap.getOrDefault(from, from);
        }
    }

    class TreeFixer {
        private final ConflictFreeBuilder lenseBuilder;
        private final GraphLense appliedLense;
        private final Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        TreeFixer(GraphLense appliedLense) {
            this.lenseBuilder = new ConflictFreeBuilder();
            this.appliedLense = appliedLense;
        }

        private GraphLense run() {
            ProguardMapApplier.this.appInfo.classes().forEach(this::fixClass);
            ProguardMapApplier.this.appInfo.libraryClasses().forEach(this::fixClass);
            return this.lenseBuilder.build(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, this.appliedLense);
        }

        private void fixClass(DexClass clazz) {
            clazz.type = this.substituteType(clazz.type, null);
            clazz.superType = this.substituteType(clazz.superType, null);
            clazz.interfaces = this.substituteTypesIn(clazz.interfaces);
            clazz.annotations = this.substituteTypesIn(clazz.annotations);
            this.fixupMethods(clazz.directMethods(), clazz::setDirectMethod);
            this.fixupMethods(clazz.virtualMethods(), clazz::setVirtualMethod);
            this.fixupFields(clazz.staticFields(), clazz::setStaticField);
            this.fixupFields(clazz.instanceFields(), clazz::setInstanceField);
        }

        private void fixupMethods(List<DexEncodedMethod> methods, DexClass.MethodSetter setter) {
            if (methods == null) {
                return;
            }
            for (int i = 0; i < methods.size(); ++i) {
                DexMethod newMethod;
                DexEncodedMethod encodedMethod = methods.get(i);
                DexMethod appliedMethod = this.appliedLense.lookupMethod(encodedMethod.method);
                DexType newHolderType = this.substituteType(appliedMethod.holder, encodedMethod);
                DexProto newProto = this.substituteTypesIn(appliedMethod.proto, encodedMethod);
                if (newHolderType != appliedMethod.holder || newProto != appliedMethod.proto) {
                    newMethod = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createMethod(this.substituteType(newHolderType, encodedMethod), newProto, appliedMethod.name);
                    this.lenseBuilder.move(encodedMethod.method, newMethod);
                } else {
                    newMethod = appliedMethod;
                }
                setter.setMethod(i, encodedMethod.toTypeSubstitutedMethod(newMethod));
            }
        }

        private void fixupFields(List<DexEncodedField> fields, DexClass.FieldSetter setter) {
            if (fields == null) {
                return;
            }
            for (int i = 0; i < fields.size(); ++i) {
                DexField newField;
                DexEncodedField encodedField = fields.get(i);
                DexField appliedField = this.appliedLense.lookupField(encodedField.field);
                DexType newHolderType = this.substituteType(appliedField.clazz, null);
                DexType newFieldType = this.substituteType(appliedField.type, null);
                if (newHolderType != appliedField.clazz || newFieldType != appliedField.type) {
                    newField = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createField(this.substituteType(newHolderType, null), newFieldType, appliedField.name);
                    this.lenseBuilder.move(encodedField.field, newField);
                } else {
                    newField = appliedField;
                }
                setter.setField(i, encodedField.toTypeSubstitutedField(newField));
            }
        }

        private DexProto substituteTypesIn(DexProto proto, DexEncodedMethod context) {
            DexProto result = this.protoFixupCache.get(proto);
            if (result == null) {
                DexType returnType = this.substituteType(proto.returnType, context);
                DexType[] arguments = this.substituteTypesIn(proto.parameters.values, context);
                if (arguments != null || returnType != proto.returnType) {
                    arguments = arguments == null ? proto.parameters.values : arguments;
                    result = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createProto(returnType, arguments);
                } else {
                    result = proto;
                }
                this.protoFixupCache.put(proto, result);
            }
            return result;
        }

        private DexAnnotationSet substituteTypesIn(DexAnnotationSet annotations) {
            return annotations.rewrite(this::substituteTypesIn);
        }

        private DexAnnotation substituteTypesIn(DexAnnotation annotation) {
            return annotation.rewrite(this::substituteTypesIn);
        }

        private DexEncodedAnnotation substituteTypesIn(DexEncodedAnnotation annotation) {
            return annotation.rewrite(type -> this.substituteType((DexType)type, null), Function.identity());
        }

        private DexTypeList substituteTypesIn(DexTypeList types) {
            if (types.isEmpty()) {
                return types;
            }
            DexType[] result = this.substituteTypesIn(types.values, null);
            return result == null ? types : new DexTypeList(result);
        }

        private DexType[] substituteTypesIn(DexType[] types, DexEncodedMethod context) {
            Int2ObjectArrayMap<DexType> changed = new Int2ObjectArrayMap<DexType>();
            for (int i = 0; i < types.length; ++i) {
                DexType applied = this.substituteType(types[i], context);
                if (applied == types[i]) continue;
                changed.put(Integer.valueOf(i), applied);
            }
            return changed.isEmpty() ? null : ArrayUtils.copyWithSparseChanges(DexType[].class, types, changed);
        }

        private DexType substituteType(DexType type, DexEncodedMethod context) {
            if (type == null) {
                return null;
            }
            if (type.isArrayType()) {
                DexType fixed;
                DexType base = type.toBaseType(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory);
                if (base == (fixed = this.substituteType(base, context))) {
                    return type;
                }
                return type.replaceBaseType(fixed, ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory);
            }
            return this.appliedLense.lookupType(type);
        }
    }

    static class ChainedClassNaming
    extends ClassNamingForMapApplier {
        final ChainedClassNaming superClassNaming;

        ChainedClassNaming(ChainedClassNaming superClassNaming, ClassNamingForMapApplier thisClassNaming) {
            super(thisClassNaming);
            this.superClassNaming = superClassNaming;
        }

        @Override
        public <T extends Throwable> void forAllMethodNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
            super.forAllMethodNaming(consumer);
            if (this.superClassNaming != null) {
                this.superClassNaming.forAllMethodNaming(consumer);
            }
        }

        protected MemberNaming lookupByOriginalItem(DexMethod method, boolean isPrivate) {
            if (!isPrivate) {
                return this.lookupByOriginalItem(method);
            }
            return super.lookupByOriginalItem(method);
        }

        @Override
        protected MemberNaming lookupByOriginalItem(DexMethod method) {
            MemberNaming memberNaming = super.lookupByOriginalItem(method);
            if (memberNaming != null) {
                return memberNaming;
            }
            if (this.superClassNaming != null) {
                return this.superClassNaming.lookupByOriginalItem(method);
            }
            return null;
        }
    }

    class MapToLenseConverter {
        private final ConflictFreeBuilder lenseBuilder;
        private final Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        MapToLenseConverter() {
            this.lenseBuilder = new ConflictFreeBuilder();
        }

        private GraphLense run() {
            this.applyClassMappingForClasses(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.objectType, null);
            DexType.forAllInterfaces(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, itf -> this.applyClassMappingForInterfaces((DexType)itf, null));
            return this.lenseBuilder.build(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, ProguardMapApplier.this.previousLense);
        }

        private void applyClassMappingForClasses(DexType type, ChainedClassNaming classNamingFromSuperType) {
            ChainedClassNaming classNaming = this.chainClassNaming(type, classNamingFromSuperType);
            this.applyClassMapping(type, classNaming);
            type.forAllExtendsSubtypes(subtype -> this.applyClassMappingForClasses((DexType)subtype, classNaming));
        }

        private void applyClassMappingForInterfaces(DexType type, ChainedClassNaming classNamingFromSuperType) {
            ChainedClassNaming classNaming = this.chainClassNaming(type, classNamingFromSuperType);
            DexClass clazz = ProguardMapApplier.this.appInfo.definitionFor(type);
            if (clazz != null && clazz.isProgramClass()) {
                this.applyClassMapping(type, classNaming);
            }
            type.forAllExtendsSubtypes(subtype -> this.applyClassMappingForInterfaces((DexType)subtype, classNaming));
            type.forAllImplementsSubtypes(subtype -> this.applyClassMappingForInterfaces((DexType)subtype, classNaming));
        }

        private ChainedClassNaming chainClassNaming(DexType type, ChainedClassNaming classNamingFromSuperType) {
            return ProguardMapApplier.this.seedMapper.hasMapping(type) ? new ChainedClassNaming(classNamingFromSuperType, ProguardMapApplier.this.seedMapper.getClassNaming(type)) : classNamingFromSuperType;
        }

        private void applyClassMapping(DexType type, ChainedClassNaming classNaming) {
            if (classNaming != null) {
                if (ProguardMapApplier.this.seedMapper.hasMapping(type) && this.lenseBuilder.lookup(type) == type) {
                    DexType appliedType = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createType(classNaming.renamedName);
                    this.lenseBuilder.map(type, appliedType);
                }
                this.applyMemberMapping(type, classNaming);
            }
        }

        private void applyMemberMapping(DexType from, ChainedClassNaming classNaming) {
            DexClass clazz = ProguardMapApplier.this.appInfo.definitionFor(from);
            if (clazz == null) {
                return;
            }
            HashSet appliedMemberSignature = new HashSet();
            clazz.forEachField(encodedField -> {
                MemberNaming memberNaming = classNaming.lookupByOriginalItem(encodedField.field);
                if (memberNaming != null) {
                    appliedMemberSignature.add(memberNaming.getOriginalSignature());
                    this.applyFieldMapping(encodedField.field, memberNaming);
                }
            });
            clazz.forEachMethod(encodedMethod -> {
                MemberNaming memberNaming = classNaming.lookupByOriginalItem(encodedMethod.method, encodedMethod.isPrivateMethod());
                if (memberNaming != null) {
                    appliedMemberSignature.add(memberNaming.getOriginalSignature());
                    this.applyMethodMapping(encodedMethod.method, memberNaming);
                }
            });
            classNaming.forAllFieldNaming(memberNaming -> {
                MemberNaming.FieldSignature signature = (MemberNaming.FieldSignature)memberNaming.getOriginalSignature();
                if (!signature.isQualified() && !appliedMemberSignature.contains(signature)) {
                    DexField pretendedOriginalField = signature.toDexField(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, from);
                    if (ProguardMapApplier.this.appInfo.definitionFor(pretendedOriginalField) == null) {
                        this.applyFieldMapping(pretendedOriginalField, (MemberNaming)memberNaming);
                    }
                }
            });
            classNaming.forAllMethodNaming(memberNaming -> {
                MemberNaming.MethodSignature signature = (MemberNaming.MethodSignature)memberNaming.getOriginalSignature();
                if (!signature.isQualified() && !appliedMemberSignature.contains(signature)) {
                    DexMethod pretendedOriginalMethod = signature.toDexMethod(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, from);
                    if (ProguardMapApplier.this.appInfo.definitionFor(pretendedOriginalMethod) == null) {
                        this.applyMethodMapping(pretendedOriginalMethod, (MemberNaming)memberNaming);
                    }
                }
            });
        }

        private void applyFieldMapping(DexField originalField, MemberNaming memberNaming) {
            MemberNaming.FieldSignature appliedSignature = (MemberNaming.FieldSignature)memberNaming.getRenamedSignature();
            DexField appliedField = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createField(this.applyClassMappingOnTheFly(originalField.clazz), this.applyClassMappingOnTheFly(originalField.type), ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createString(appliedSignature.name));
            this.lenseBuilder.move(originalField, appliedField);
        }

        private void applyMethodMapping(DexMethod originalMethod, MemberNaming memberNaming) {
            MemberNaming.MethodSignature appliedSignature = (MemberNaming.MethodSignature)memberNaming.getRenamedSignature();
            DexMethod appliedMethod = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createMethod(this.applyClassMappingOnTheFly(originalMethod.holder), this.applyClassMappingOnTheFly(originalMethod.proto), ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createString(appliedSignature.name));
            this.lenseBuilder.move(originalMethod, appliedMethod);
        }

        private DexType applyClassMappingOnTheFly(DexType from) {
            if (from.isArrayType()) {
                DexType baseType = from.toBaseType(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory);
                DexType appliedBaseType = this.applyClassMappingOnTheFly(baseType);
                return from.replaceBaseType(appliedBaseType, ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory);
            }
            if (ProguardMapApplier.this.seedMapper.hasMapping(from)) {
                DexType appliedType = this.lenseBuilder.lookup(from);
                if (appliedType != from) {
                    return appliedType;
                }
                ClassNamingForMapApplier classNaming = ProguardMapApplier.this.seedMapper.getClassNaming(from);
                appliedType = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createType(classNaming.renamedName);
                this.lenseBuilder.map(from, appliedType);
                return appliedType;
            }
            return from;
        }

        private DexProto applyClassMappingOnTheFly(DexProto proto) {
            return ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.applyClassMappingToProto(proto, this::applyClassMappingOnTheFly, this.protoFixupCache);
        }
    }
}

