/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format21c;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.OffsetToObjectMapping;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import java.nio.ShortBuffer;

public class ConstString
extends Format21c {
    public static final int OPCODE = 26;
    public static final String NAME = "ConstString";
    public static final String SMALI_NAME = "const-string";

    ConstString(int high, BytecodeStream stream, OffsetToObjectMapping mapping) {
        super(high, stream, mapping.getStringMap());
    }

    public ConstString(int register, DexString string) {
        super(register, string);
    }

    public DexString getString() {
        return (DexString)this.BBBB;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 26;
    }

    @Override
    public ConstString asConstString() {
        return this;
    }

    @Override
    public boolean isConstString() {
        return true;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", \"" + this.BBBB.toString() + "\"");
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", \"" + this.BBBB.toString() + "\"");
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        int index = this.BBBB.getOffset(mapping);
        if (index != (index & 0xFFFF)) {
            throw new InternalCompilerError("String-index overflow.");
        }
        super.write(dest, mapping);
    }

    @Override
    public void buildIR(IRBuilder builder) {
        builder.addConstString(this.AA, (DexString)this.BBBB);
    }

    @Override
    public boolean canThrow() {
        return true;
    }
}

