/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ArgumentUse;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.jar.InliningConstraintVisitor;
import com.android.tools.r8.jar.JarArgumentUseVisitor;
import com.android.tools.r8.jar.JarRegisterEffectsVisitor;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.android.tools.r8.org.objectweb.asm.tree.AbstractInsnNode;
import com.android.tools.r8.org.objectweb.asm.tree.LabelNode;
import com.android.tools.r8.org.objectweb.asm.tree.LineNumberNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.tree.TryCatchBlockNode;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OffOrAuto;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ListIterator;
import java.util.function.BiFunction;

public class JarCode
extends Code {
    private final DexMethod method;
    private final Origin origin;
    private MethodNode node;
    protected JarClassFileReader.ReparseContext context;
    protected final JarApplicationReader application;
    private boolean reachabilitySensitive = false;

    public void writeTo(MethodVisitor visitor) {
        this.node.accept(visitor);
    }

    public JarCode(DexMethod method, Origin origin, JarClassFileReader.ReparseContext context, JarApplicationReader application) {
        this.method = method;
        this.origin = origin;
        this.context = context;
        this.application = application;
        context.codeList.add(this);
    }

    public void markReachabilitySensitive() {
        assert (this.context != null);
        this.reachabilitySensitive = true;
    }

    public MethodNode getNode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node;
    }

    @Override
    public boolean isJarCode() {
        return true;
    }

    @Override
    public JarCode asJarCode() {
        return this;
    }

    @Override
    protected int computeHashCode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node.hashCode();
    }

    @Override
    protected boolean computeEquals(Object other) {
        this.triggerDelayedParsingIfNeccessary();
        if (this == other) {
            return true;
        }
        if (other instanceof JarCode) {
            JarCode o = (JarCode)other;
            o.triggerDelayedParsingIfNeccessary();
            return this.node.equals(o.node);
        }
        return false;
    }

    @Override
    public boolean isEmptyVoidMethod() {
        ListIterator<AbstractInsnNode> it = this.getNode().instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn.getType() == 177 || insn instanceof LabelNode || insn instanceof LineNumberNode) continue;
            return false;
        }
        return true;
    }

    public boolean hasLocalVariableTable() {
        return this.getNode().localVariables != null && !this.getNode().localVariables.isEmpty();
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug || encodedMethod.getOptimizationInfo().isReachabilitySensitive() ? this.internalBuildWithLocals(encodedMethod, encodedMethod, appInfo, graphLense, options, null, null) : this.internalBuild(encodedMethod, encodedMethod, appInfo, graphLense, options, null, null);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        assert (generator != null);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug || encodedMethod.getOptimizationInfo().isReachabilitySensitive() ? this.internalBuildWithLocals(context, encodedMethod, appInfo, graphLense, options, generator, callerPosition) : this.internalBuild(context, encodedMethod, appInfo, graphLense, options, generator, callerPosition);
    }

    private IRCode internalBuildWithLocals(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) {
        try {
            return this.internalBuild(context, encodedMethod, appInfo, graphLense, options, generator, callerPosition);
        }
        catch (InvalidDebugInfoException e) {
            options.warningInvalidDebugInfo(encodedMethod, this.origin, e);
            this.node.localVariables.clear();
            return this.internalBuild(context, encodedMethod, appInfo, graphLense, options, generator, callerPosition);
        }
    }

    private boolean keepLocals(DexEncodedMethod encodedMethod, InternalOptions options) {
        if (options.testing.noLocalsTableOnInput) {
            return false;
        }
        if (options.debug) {
            return true;
        }
        if (options.getProguardConfiguration() != null && options.getProguardConfiguration().getKeepAttributes().localVariableTable) {
            return true;
        }
        return encodedMethod.getOptimizationInfo().isReachabilitySensitive();
    }

    private IRCode internalBuild(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) {
        if (!this.keepLocals(encodedMethod, options)) {
            this.node.localVariables.clear();
        }
        JarSourceCode source = new JarSourceCode(this.method.getHolder(), this.node, this.application, graphLense.getOriginalMethodSignature(encodedMethod.method), callerPosition);
        IRBuilder builder = new IRBuilder(encodedMethod, appInfo, source, options, this.origin, generator, graphLense);
        return builder.build(context);
    }

    @Override
    public void registerCodeReferences(UseRegistry registry) {
        this.triggerDelayedParsingIfNeccessary();
        this.node.instructions.accept(new JarRegisterEffectsVisitor(this.method.getHolder(), registry, this.application));
        for (TryCatchBlockNode tryCatchBlockNode : this.node.tryCatchBlocks) {
            if (tryCatchBlockNode.type == null) continue;
            registry.registerTypeReference(this.application.getTypeFromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(tryCatchBlockNode.type)));
        }
    }

    @Override
    public void registerArgumentReferences(ArgumentUse registry) {
        this.triggerDelayedParsingIfNeccessary();
        this.node.instructions.accept(new JarArgumentUseVisitor(this.getOwner(), registry));
    }

    public Inliner.ConstraintWithTarget computeInliningConstraint(DexEncodedMethod encodedMethod, AppView<? extends Enqueuer.AppInfoWithLiveness> appView, GraphLense graphLense, DexType invocationContext) {
        InliningConstraintVisitor visitor = new InliningConstraintVisitor(this.application, appView.appInfo(), graphLense, encodedMethod, invocationContext);
        if (appView.options().enableDesugaring && appView.options().interfaceMethodDesugaring == OffOrAuto.Auto && !appView.options().canUseDefaultAndStaticInterfaceMethods()) {
            visitor.disallowStaticInterfaceMethodCalls();
        }
        for (AbstractInsnNode insn = this.node.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            insn.accept(visitor);
            if (!visitor.isFinished()) continue;
            return visitor.getConstraint();
        }
        for (TryCatchBlockNode block : this.node.tryCatchBlocks) {
            visitor.accept(block);
            if (!visitor.isFinished()) continue;
            return visitor.getConstraint();
        }
        return visitor.getConstraint();
    }

    @Override
    public String toString() {
        this.triggerDelayedParsingIfNeccessary();
        TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
        this.node.accept(visitor);
        StringWriter writer = new StringWriter();
        visitor.p.print(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.toString();
    }

    private void triggerDelayedParsingIfNeccessary() {
        if (this.context != null) {
            JarClassFileReader.ReparseContext context = this.context;
            this.parseCode(context, false);
            if (this.hasJsr(context)) {
                this.parseCode(context, true);
                assert (!this.hasJsr(context));
            }
            assert (JarCode.verifyNoReparseContext(context.owner));
        }
    }

    private void parseCode(JarClassFileReader.ReparseContext context, boolean useJsrInliner) {
        int parsingOptions = 4;
        if (this.application.options.getProguardConfiguration() != null) {
            ProguardKeepAttributes keep = this.application.options.getProguardConfiguration().getKeepAttributes();
            if (!(keep.localVariableTable || keep.localVariableTypeTable || keep.lineNumberTable || this.reachabilitySensitive)) {
                parsingOptions |= 2;
            }
        }
        SecondVisitor classVisitor = new SecondVisitor(this.createCodeLocator(context), useJsrInliner);
        try {
            new ClassReader(context.classCache).accept(classVisitor, parsingOptions);
        }
        catch (Exception exception) {
            throw new CompilationError("Unable to parse method `" + this.method.toSourceString() + "`", exception);
        }
    }

    protected BiFunction<String, String, JarCode> createCodeLocator(JarClassFileReader.ReparseContext context) {
        return new DefaultCodeLocator(context, this.application);
    }

    private boolean hasJsr(JarClassFileReader.ReparseContext context) {
        for (Code code : context.codeList) {
            if (!this.hasJsr(code.asJarCode().node)) continue;
            return true;
        }
        return false;
    }

    private boolean hasJsr(MethodNode node) {
        ListIterator<AbstractInsnNode> it = node.instructions.iterator();
        while (it.hasNext()) {
            int opcode = ((AbstractInsnNode)it.next()).getOpcode();
            if (opcode != 168 && opcode != 169) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyNoReparseContext(DexProgramClass owner) {
        Code code;
        for (DexEncodedMethod method : owner.virtualMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        for (DexEncodedMethod method : owner.directMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        return true;
    }

    private static class SecondVisitor
    extends ClassVisitor {
        private final BiFunction<String, String, JarCode> codeLocator;
        private final boolean useJsrInliner;

        public SecondVisitor(BiFunction<String, String, JarCode> codeLocator, boolean useJsrInliner) {
            super(393216);
            this.codeLocator = codeLocator;
            this.useJsrInliner = useJsrInliner;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodNode node = this.useJsrInliner ? new JSRInlinerAdapter(null, access, name, desc, signature, exceptions) : new MethodNode(393216, access, name, desc, signature, exceptions);
            JarCode code = null;
            MethodAccessFlags flags = JarClassFileReader.createMethodAccessFlags(name, access);
            if (!flags.isAbstract() && !flags.isNative()) {
                code = this.codeLocator.apply(name, desc);
            }
            if (code != null) {
                code.context = null;
                code.node = node;
                return node;
            }
            return null;
        }
    }

    private static class DefaultCodeLocator
    implements BiFunction<String, String, JarCode> {
        private final JarClassFileReader.ReparseContext context;
        private final JarApplicationReader application;
        private int methodIndex = 0;

        private DefaultCodeLocator(JarClassFileReader.ReparseContext context, JarApplicationReader application) {
            this.context = context;
            this.application = application;
        }

        @Override
        public JarCode apply(String name, String desc) {
            JarCode code = this.context.codeList.get(this.methodIndex++).asJarCode();
            assert (code.method == this.application.getMethod(this.context.owner.type, name, desc));
            return code;
        }
    }
}

