/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.code.Format22c;
import com.android.tools.r8.code.Iget;
import com.android.tools.r8.code.IgetBoolean;
import com.android.tools.r8.code.IgetByte;
import com.android.tools.r8.code.IgetChar;
import com.android.tools.r8.code.IgetObject;
import com.android.tools.r8.code.IgetShort;
import com.android.tools.r8.code.IgetWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class InstanceGet
extends FieldInstruction {
    public InstanceGet(Value dest, Value object, DexField field) {
        super(field, dest, object);
    }

    public Value dest() {
        return this.outValue;
    }

    public Value object() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public boolean couldIntroduceAnAlias() {
        return true;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int destRegister = builder.allocatedRegister(this.dest(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Iget(destRegister, objectRegister, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new IgetWide(destRegister, objectRegister, field);
                break;
            }
            case OBJECT: {
                instruction = new IgetObject(destRegister, objectRegister, field);
                break;
            }
            case BOOLEAN: {
                instruction = new IgetBoolean(destRegister, objectRegister, field);
                break;
            }
            case BYTE: {
                instruction = new IgetByte(destRegister, objectRegister, field);
                break;
            }
            case CHAR: {
                instruction = new IgetChar(destRegister, objectRegister, field);
                break;
            }
            case SHORT: {
                instruction = new IgetShort(destRegister, objectRegister, field);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.getType()));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInstanceGet()) {
            return false;
        }
        InstanceGet o = other.asInstanceGet();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInstanceGet(this.getField(), invocationContext);
    }

    @Override
    public boolean isInstanceGet() {
        return true;
    }

    @Override
    public InstanceGet asInstanceGet() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(this.getField().type, Nullability.maybeNull(), appInfo);
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.getField().type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(180, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.object() == value;
    }
}

