/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.IdentifierMinifier;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Minifier {
    static final char INNER_CLASS_SEPARATOR = '$';
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final Set<DexCallSite> desugaredCallSites;
    private final InternalOptions options;

    public Minifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, Set<DexCallSite> desugaredCallSites, InternalOptions options) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.desugaredCallSites = desugaredCallSites;
        this.options = options;
    }

    public NamingLens run(Timing timing) {
        assert (this.options.enableMinification);
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appInfo, this.rootSet, this.options);
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing);
        timing.end();
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appInfo, this.rootSet, this.desugaredCallSites, this.options).computeRenaming(timing);
        timing.end();
        timing.begin("MinifyFields");
        Map<DexField, DexString> fieldRenaming = new FieldNameMinifier(this.appInfo, this.rootSet, this.options).computeRenaming(timing);
        timing.end();
        MinifiedRenaming lens = new MinifiedRenaming(classRenaming, methodRenaming, fieldRenaming, this.appInfo);
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appInfo, this.options.getProguardConfiguration().getAdaptClassStrings(), lens).run();
        timing.end();
        return lens;
    }

    private static class MinifiedRenaming
    extends NamingLens {
        private final AppInfo appInfo;
        private final Map<String, String> packageRenaming;
        private final Map<DexItem, DexString> renaming = new IdentityHashMap<DexItem, DexString>();

        private MinifiedRenaming(ClassNameMinifier.ClassRenaming classRenaming, MethodNameMinifier.MethodRenaming methodRenaming, Map<DexField, DexString> fieldRenaming, AppInfo appInfo) {
            this.appInfo = appInfo;
            this.packageRenaming = classRenaming.packageRenaming;
            this.renaming.putAll(classRenaming.classRenaming);
            this.renaming.putAll(methodRenaming.renaming);
            this.renaming.putAll(methodRenaming.callSiteRenaming);
            this.renaming.putAll(fieldRenaming);
        }

        @Override
        public String lookupPackageName(String packageName) {
            return this.packageRenaming.getOrDefault(packageName, packageName);
        }

        @Override
        public DexString lookupDescriptor(DexType type) {
            return this.renaming.getOrDefault(type, type.descriptor);
        }

        @Override
        public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
            if (attribute.getInnerName() == null) {
                return null;
            }
            DexType innerType = attribute.getInner();
            String inner = DescriptorUtils.descriptorToInternalName(innerType.descriptor.toString());
            String innerName = attribute.getInnerName().toString();
            int lengthOfPrefix = inner.length() - innerName.length();
            if (lengthOfPrefix < 0 || inner.lastIndexOf(36, lengthOfPrefix - 1) < 0 || !inner.endsWith(innerName)) {
                return this.lookupSimpleName(innerType, options.itemFactory);
            }
            String innerTypeMapped = DescriptorUtils.descriptorToInternalName(this.lookupDescriptor(innerType).toString());
            if (inner.equals(innerTypeMapped)) {
                return attribute.getInnerName();
            }
            int index = innerTypeMapped.lastIndexOf(36);
            if (index < 0) {
                assert (!options.testing.allowFailureOnInnerClassErrors) : "Outer$Inner class was remapped without keeping the dollar separator";
                return this.lookupSimpleName(innerType, options.itemFactory);
            }
            return options.itemFactory.createString(innerTypeMapped.substring(index + 1));
        }

        @Override
        public DexString lookupName(DexMethod method) {
            return this.renaming.getOrDefault(method, method.name);
        }

        @Override
        public DexString lookupMethodName(DexCallSite callSite) {
            return this.renaming.getOrDefault(callSite, callSite.methodName);
        }

        @Override
        public DexString lookupName(DexField field) {
            return this.renaming.getOrDefault(field, field.name);
        }

        @Override
        void forAllRenamedTypes(Consumer<DexType> consumer) {
            DexReference.filterDexType(DexReference.filterDexReference(this.renaming.keySet().stream())).forEach(consumer);
        }

        @Override
        <T extends DexItem> Map<String, T> getRenamedItems(Class<T> clazz, Predicate<T> predicate, Function<T, String> namer) {
            return this.renaming.keySet().stream().filter(item -> clazz.isInstance(item) && predicate.test((DexItem)clazz.cast(item))).map(clazz::cast).collect(ImmutableMap.toImmutableMap(namer, i -> i));
        }

        @Override
        public boolean checkTargetCanBeTranslated(DexMethod item) {
            if (item.holder.isArrayType()) {
                return true;
            }
            DexClass holder = this.appInfo.definitionFor(item.holder);
            if (holder == null || holder.isLibraryClass()) {
                return true;
            }
            DexEncodedMethod staticTarget = this.appInfo.lookupStaticTarget(item);
            DexEncodedMethod directTarget = this.appInfo.lookupDirectTarget(item);
            DexEncodedMethod virtualTarget = this.appInfo.lookupVirtualTarget(item.holder, item);
            DexClass staticTargetHolder = staticTarget != null ? this.appInfo.definitionFor(staticTarget.method.getHolder()) : null;
            DexClass directTargetHolder = directTarget != null ? this.appInfo.definitionFor(directTarget.method.getHolder()) : null;
            DexClass virtualTargetHolder = virtualTarget != null ? this.appInfo.definitionFor(virtualTarget.method.getHolder()) : null;
            return directTarget == null && staticTarget == null && virtualTarget == null || virtualTarget != null && virtualTarget.method == item || directTarget != null && directTarget.method == item || staticTarget != null && staticTarget.method == item || directTargetHolder != null && directTargetHolder.isLibraryClass() || virtualTargetHolder != null && virtualTargetHolder.isLibraryClass() || staticTargetHolder != null && staticTargetHolder.isLibraryClass();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.renaming.forEach((item, str) -> {
                if (item instanceof DexType) {
                    builder.append("[c] ");
                } else if (item instanceof DexMethod) {
                    builder.append("[m] ");
                } else if (item instanceof DexField) {
                    builder.append("[f] ");
                }
                builder.append(item.toSourceString());
                builder.append(" -> ");
                builder.append(str.toSourceString());
                builder.append('\n');
            });
            return builder.toString();
        }
    }
}

