/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.MapMaker;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.DescriptorUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

@Keep
public final class Reference {
    public static PrimitiveReference BOOL = PrimitiveReference.BOOL;
    public static PrimitiveReference BYTE = PrimitiveReference.BYTE;
    public static PrimitiveReference CHAR = PrimitiveReference.CHAR;
    public static PrimitiveReference SHORT = PrimitiveReference.SHORT;
    public static PrimitiveReference INT = PrimitiveReference.INT;
    public static PrimitiveReference FLOAT = PrimitiveReference.FLOAT;
    public static PrimitiveReference LONG = PrimitiveReference.LONG;
    public static PrimitiveReference DOUBLE = PrimitiveReference.DOUBLE;
    private static Reference instance;
    private final ConcurrentMap<String, ClassReference> classes = new MapMaker().weakValues().makeMap();
    private final ConcurrentMap<String, ArrayReference> arrays = new MapMaker().weakValues().makeMap();
    private final ConcurrentMap<MethodReference, MethodReference> methods = new MapMaker().weakValues().makeMap();
    private final ConcurrentMap<FieldReference, FieldReference> fields = new MapMaker().weakValues().makeMap();

    private Reference() {
    }

    private static Reference getInstance() {
        if (instance == null) {
            instance = new Reference();
        }
        return instance;
    }

    public static TypeReference typeFromDescriptor(String descriptor) {
        switch (descriptor.charAt(0)) {
            case 'L': {
                return Reference.classFromDescriptor(descriptor);
            }
            case '[': {
                return Reference.arrayFromDescriptor(descriptor);
            }
        }
        return Reference.primitiveFromDescriptor(descriptor);
    }

    private static TypeReference typeFromClass(Class<?> clazz) {
        return Reference.typeFromDescriptor(DescriptorUtils.javaTypeToDescriptor(clazz.getTypeName()));
    }

    public static PrimitiveReference primitiveFromDescriptor(String descriptor) {
        return PrimitiveReference.fromDescriptor(descriptor);
    }

    public static ClassReference classFromDescriptor(String descriptor) {
        return Reference.getInstance().classes.computeIfAbsent(descriptor, ClassReference::fromDescriptor);
    }

    public static ClassReference classFromBinaryName(String binaryName) {
        return Reference.classFromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(binaryName));
    }

    public static ClassReference classFromTypeName(String typeName) {
        return Reference.classFromDescriptor(DescriptorUtils.javaTypeToDescriptor(typeName));
    }

    public static ClassReference classFromClass(Class<?> clazz) {
        return Reference.classFromTypeName(clazz.getTypeName());
    }

    public static ArrayReference arrayFromDescriptor(String descriptor) {
        return Reference.getInstance().arrays.computeIfAbsent(descriptor, ArrayReference::fromDescriptor);
    }

    public static MethodReference method(ClassReference holderClass, String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
        MethodReference key = new MethodReference(holderClass, methodName, ImmutableList.copyOf(formalTypes), returnType);
        return Reference.getInstance().methods.computeIfAbsent(key, k -> new MethodReference(k.getHolderClass(), k.getMethodName(), ImmutableList.copyOf(k.getFormalTypes()), k.getReturnType()));
    }

    public static MethodReference methodFromMethod(Method method) {
        String methodName = method.getName();
        Class<?> holderClass = method.getDeclaringClass();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> parameterType : parameterTypes) {
            builder.add(Reference.typeFromClass(parameterType));
        }
        return Reference.method(Reference.classFromClass(holderClass), methodName, (List<TypeReference>)((Object)builder.build()), returnType == Void.TYPE ? null : Reference.typeFromClass(returnType));
    }

    public static FieldReference field(ClassReference holderClass, String fieldName, TypeReference fieldType) {
        FieldReference key = new FieldReference(holderClass, fieldName, fieldType);
        return Reference.getInstance().fields.computeIfAbsent(key, k -> new FieldReference(k.getHolderClass(), k.getFieldName(), k.getFieldType()));
    }

    public static FieldReference fieldFromField(Field field) {
        Class<?> holderClass = field.getDeclaringClass();
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        return Reference.field(Reference.classFromClass(holderClass), fieldName, Reference.typeFromClass(fieldType));
    }
}

