/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.util.IntList;
import java.util.BitSet;

public class IdenticalBlockCombiner {
    private final RopMethod ropMethod;
    private final BasicBlockList blocks;
    private final BasicBlockList newBlocks;

    public IdenticalBlockCombiner(RopMethod rm) {
        this.ropMethod = rm;
        this.blocks = this.ropMethod.getBlocks();
        this.newBlocks = this.blocks.getMutableCopy();
    }

    public RopMethod process() {
        int szBlocks = this.blocks.size();
        BitSet toDelete = new BitSet(this.blocks.getMaxLabel());
        for (int bindex = 0; bindex < szBlocks; ++bindex) {
            BasicBlock b2 = this.blocks.get(bindex);
            if (toDelete.get(b2.getLabel())) continue;
            IntList preds = this.ropMethod.labelToPredecessors(b2.getLabel());
            int szPreds = preds.size();
            for (int i2 = 0; i2 < szPreds; ++i2) {
                int iLabel = preds.get(i2);
                BasicBlock iBlock = this.blocks.labelToBlock(iLabel);
                if (toDelete.get(iLabel) || iBlock.getSuccessors().size() > 1 || iBlock.getFirstInsn().getOpcode().getOpcode() == 55) continue;
                IntList toCombine = new IntList();
                for (int j2 = i2 + 1; j2 < szPreds; ++j2) {
                    int jLabel = preds.get(j2);
                    BasicBlock jBlock = this.blocks.labelToBlock(jLabel);
                    if (jBlock.getSuccessors().size() != 1 || !IdenticalBlockCombiner.compareInsns(iBlock, jBlock)) continue;
                    toCombine.add(jLabel);
                    toDelete.set(jLabel);
                }
                this.combineBlocks(iLabel, toCombine);
            }
        }
        for (int i3 = szBlocks - 1; i3 >= 0; --i3) {
            if (!toDelete.get(this.newBlocks.get(i3).getLabel())) continue;
            this.newBlocks.set(i3, null);
        }
        this.newBlocks.shrinkToFit();
        this.newBlocks.setImmutable();
        return new RopMethod(this.newBlocks, this.ropMethod.getFirstLabel());
    }

    private static boolean compareInsns(BasicBlock a2, BasicBlock b2) {
        return a2.getInsns().contentEquals(b2.getInsns());
    }

    private void combineBlocks(int alphaLabel, IntList betaLabels) {
        int szBetas = betaLabels.size();
        for (int i2 = 0; i2 < szBetas; ++i2) {
            int betaLabel = betaLabels.get(i2);
            BasicBlock bb2 = this.blocks.labelToBlock(betaLabel);
            IntList preds = this.ropMethod.labelToPredecessors(bb2.getLabel());
            int szPreds = preds.size();
            for (int j2 = 0; j2 < szPreds; ++j2) {
                BasicBlock predBlock = this.newBlocks.labelToBlock(preds.get(j2));
                this.replaceSucc(predBlock, betaLabel, alphaLabel);
            }
        }
    }

    private void replaceSucc(BasicBlock block, int oldLabel, int newLabel) {
        IntList newSuccessors = block.getSuccessors().mutableCopy();
        newSuccessors.set(newSuccessors.indexOf(oldLabel), newLabel);
        int newPrimarySuccessor = block.getPrimarySuccessor();
        if (newPrimarySuccessor == oldLabel) {
            newPrimarySuccessor = newLabel;
        }
        newSuccessors.setImmutable();
        BasicBlock newBB = new BasicBlock(block.getLabel(), block.getInsns(), newSuccessors, newPrimarySuccessor);
        this.newBlocks.set(this.newBlocks.indexOfLabel(block.getLabel()), newBB);
    }
}

