/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.utils;

import java.io.File;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"isValidZipEntryName", "", "entry", "Ljava/util/zip/ZipEntry;", "isValidZipEntryPath", "filePath", "Ljava/io/File;", "outputDir", "builder"})
@JvmName(name="ZipEntryUtils")
public final class ZipEntryUtils {
    public static final boolean isValidZipEntryName(@NotNull ZipEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        String string = entry.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
        return !StringsKt.contains$default((CharSequence)string, (CharSequence)"../", (boolean)false, (int)2, null);
    }

    public static final boolean isValidZipEntryPath(@NotNull File filePath, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        String string = filePath.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath.canonicalPath");
        return StringsKt.startsWith$default((String)string, (String)(outputDir.getCanonicalPath() + File.separator), (boolean)false, (int)2, null);
    }
}

