/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.util.Hex;
import com.android.dx.util.MutabilityControl;

public final class StdConstantPool
extends MutabilityControl
implements ConstantPool {
    private final Constant[] entries;

    public StdConstantPool(int size) {
        super(size > 1);
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.entries = new Constant[size];
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public Constant getOrNull(int n2) {
        try {
            return this.entries[n2];
        }
        catch (IndexOutOfBoundsException ex) {
            return StdConstantPool.throwInvalid(n2);
        }
    }

    @Override
    public Constant get0Ok(int n2) {
        if (n2 == 0) {
            return null;
        }
        return this.get(n2);
    }

    @Override
    public Constant get(int n2) {
        try {
            Constant result = this.entries[n2];
            if (result == null) {
                StdConstantPool.throwInvalid(n2);
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            return StdConstantPool.throwInvalid(n2);
        }
    }

    @Override
    public Constant[] getEntries() {
        return this.entries;
    }

    public void set(int n2, Constant cst) {
        Constant prev;
        boolean cat2;
        this.throwIfImmutable();
        boolean bl = cat2 = cst != null && cst.isCategory2();
        if (n2 < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        if (cat2) {
            if (n2 == this.entries.length - 1) {
                throw new IllegalArgumentException("(n == size - 1) && cst.isCategory2()");
            }
            this.entries[n2 + 1] = null;
        }
        if (cst != null && this.entries[n2] == null && (prev = this.entries[n2 - 1]) != null && prev.isCategory2()) {
            this.entries[n2 - 1] = null;
        }
        this.entries[n2] = cst;
    }

    private static Constant throwInvalid(int idx) {
        throw new ExceptionWithContext("invalid constant pool index " + Hex.u2(idx));
    }
}

