/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.bisect;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.joptsimple.OptionParser;
import com.android.tools.r8.joptsimple.OptionSet;
import com.android.tools.r8.joptsimple.OptionSpec;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class BisectOptions {
    private static final String HELP_FLAG = "help";
    public static final String BUILD_GOOD_FLAG = "good";
    public static final String BUILD_BAD_FLAG = "bad";
    public static final String RESULT_GOOD_FLAG = "result-good";
    public static final String RESULT_BAD_FLAG = "result-bad";
    public static final String STATE_FLAG = "state";
    public static final String OUTPUT_FLAG = "output";
    public static final String COMMAND_FLAG = "command";
    public final File goodBuild;
    public final File badBuild;
    public final File stateFile;
    public final File command;
    public final File output;
    public final Result result;

    private BisectOptions(File goodBuild, File badBuild, File stateFile, File command, File output2, Result result) {
        this.goodBuild = goodBuild;
        this.badBuild = badBuild;
        this.stateFile = stateFile;
        this.command = command;
        this.output = output2;
        this.result = result;
    }

    public static BisectOptions parse(String[] args) throws IOException {
        ParserSpec parser = new ParserSpec();
        OptionSet options = parser.parse(args);
        if (options.has(parser.help)) {
            BisectOptions.printHelp(System.out);
            return null;
        }
        File goodBuild = BisectOptions.exists(BisectOptions.require(options, parser.goodBuild, BUILD_GOOD_FLAG), BUILD_GOOD_FLAG);
        File badBuild = BisectOptions.exists(BisectOptions.require(options, parser.badBuild, BUILD_BAD_FLAG), BUILD_BAD_FLAG);
        File stateFile = null;
        if (options.valueOf(parser.stateFile) != null) {
            stateFile = BisectOptions.exists(options.valueOf(parser.stateFile), STATE_FLAG);
        }
        File command = null;
        if (options.valueOf(parser.command) != null) {
            command = BisectOptions.exists(options.valueOf(parser.command), COMMAND_FLAG);
        }
        File output2 = null;
        if (options.valueOf(parser.output) != null) {
            output2 = BisectOptions.directoryExists(options.valueOf(parser.output), OUTPUT_FLAG);
        }
        Result result = Result.UNKNOWN;
        if (options.has(parser.resultGood)) {
            result = Result.GOOD;
        }
        if (options.has(parser.resultBad)) {
            if (result == Result.GOOD) {
                throw new CompilationError("Cannot specify --result-good and --result-bad simultaneously");
            }
            result = Result.BAD;
        }
        return new BisectOptions(goodBuild, badBuild, stateFile, command, output2, result);
    }

    private static <T> T require(OptionSet options, OptionSpec<T> option, String flag) {
        T value = options.valueOf(option);
        if (value != null) {
            return value;
        }
        throw new CompilationError("Missing required option: --" + flag);
    }

    private static File exists(String path, String flag) {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        throw new CompilationError("File --" + flag + ": " + file + " does not exist");
    }

    private static File directoryExists(String path, String flag) {
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        throw new CompilationError("File --" + flag + ": " + file + " is not a valid directory");
    }

    public static void printHelp(OutputStream out) throws IOException {
        ParserSpec.printHelp(out);
    }

    private static class ParserSpec {
        OptionSpec<String> goodBuild;
        OptionSpec<String> badBuild;
        OptionSpec<String> command;
        OptionSpec<String> stateFile;
        OptionSpec<String> output;
        OptionSpec<Void> resultGood;
        OptionSpec<Void> resultBad;
        OptionSpec<Void> help;

        private ParserSpec() {
        }

        void init(OptionParser parser) {
            this.help = parser.accepts(BisectOptions.HELP_FLAG).forHelp();
            this.resultGood = parser.accepts(BisectOptions.RESULT_GOOD_FLAG, "Bisect again assuming previous run was good.");
            this.resultBad = parser.accepts(BisectOptions.RESULT_BAD_FLAG, "Bisect again assuming previous run was bad.");
            this.goodBuild = parser.accepts(BisectOptions.BUILD_GOOD_FLAG, "Known good APK.").withRequiredArg().describedAs("apk");
            this.badBuild = parser.accepts(BisectOptions.BUILD_BAD_FLAG, "Known bad APK.").withRequiredArg().describedAs("apk");
            this.stateFile = parser.accepts(BisectOptions.STATE_FLAG, "Bisection state.").requiredIf(this.resultGood, this.resultBad).withRequiredArg().describedAs("file");
            this.output = parser.accepts(BisectOptions.OUTPUT_FLAG, "Output directory.").withRequiredArg().describedAs("dir");
            this.command = parser.accepts(BisectOptions.COMMAND_FLAG, "Command to run after each bisection.").requiredUnless(this.stateFile, new OptionSpec[0]).withRequiredArg().describedAs("file");
        }

        OptionSet parse(String[] args) {
            OptionParser parser = new OptionParser();
            this.init(parser);
            return parser.parse(args);
        }

        static void printHelp(OutputStream out) throws IOException {
            OptionParser parser = new OptionParser();
            new ParserSpec().init(parser);
            parser.printHelpOn(out);
        }
    }

    public static enum Result {
        UNKNOWN,
        GOOD,
        BAD;

    }
}

