/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;

public class DexEncodedField
extends KeyedDexItem<DexField> {
    public static final DexEncodedField[] EMPTY_ARRAY = new DexEncodedField[0];
    public final DexField field;
    public final FieldAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    private DexValue staticValue;

    public DexEncodedField(DexField field, FieldAccessFlags accessFlags, DexAnnotationSet annotations, DexValue staticValue) {
        this.field = field;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.staticValue = staticValue;
    }

    public boolean isProgramField(AppInfo appInfo) {
        if (this.field.clazz.isClassType()) {
            DexClass clazz = appInfo.definitionFor(this.field.clazz);
            return clazz != null && clazz.isProgramClass();
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.field.collectIndexedItems(indexedItems, method, instructionOffset);
        this.annotations.collectIndexedItems(indexedItems, method, instructionOffset);
        if (this.accessFlags.isStatic()) {
            this.getStaticValue().collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        this.annotations.collectMixedSectionItems(mixedItems);
    }

    public String toString() {
        return "Encoded field " + this.field;
    }

    @Override
    public String toSmaliString() {
        return this.field.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.field.toSourceString();
    }

    @Override
    public DexField getKey() {
        return this.field;
    }

    @Override
    public DexReference toReference() {
        return this.field;
    }

    @Override
    public boolean isDexEncodedField() {
        return true;
    }

    @Override
    public DexEncodedField asDexEncodedField() {
        return this;
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        return this.isStatic();
    }

    public boolean hasAnnotation() {
        return !this.annotations.isEmpty();
    }

    public boolean hasExplicitStaticValue() {
        assert (this.accessFlags.isStatic());
        return this.staticValue != null;
    }

    public void setStaticValue(DexValue staticValue) {
        assert (this.accessFlags.isStatic());
        assert (staticValue != null);
        this.staticValue = staticValue;
    }

    public DexValue getStaticValue() {
        assert (this.accessFlags.isStatic());
        return this.staticValue == null ? DexValue.defaultForType(this.field.type) : this.staticValue;
    }

    public Instruction valueAsConstInstruction(Enqueuer.AppInfoWithLiveness appInfo, Value dest, InternalOptions options) {
        boolean isEffectivelyFinal;
        boolean bl = isEffectivelyFinal = (this.accessFlags.isFinal() || !appInfo.isFieldWritten(this.field)) && !appInfo.isPinned(this.field);
        if (!isEffectivelyFinal) {
            return null;
        }
        if (this.accessFlags.isStatic()) {
            DexClass clazz = appInfo.definitionFor(this.field.clazz);
            assert (clazz != null) : "Class for the field must be present";
            return this.getStaticValue().asConstInstruction(clazz.hasClassInitializer(), dest, options);
        }
        return null;
    }

    public DexEncodedField toTypeSubstitutedField(DexField field) {
        if (this.field == field) {
            return this;
        }
        return new DexEncodedField(field, this.accessFlags, this.annotations, this.staticValue);
    }
}

