/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.analysis.TypeChecker;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCodeInstructionsIterator;
import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IRCode {
    private static final int MAX_MARKING_COLOR = 0x40000000;
    public static final int INSTRUCTION_NUMBER_DELTA = 2;
    public final DexEncodedMethod method;
    public LinkedList<BasicBlock> blocks;
    public final ValueNumberGenerator valueNumberGenerator;
    private int usedMarkingColors = 0;
    private boolean numbered = false;
    private int nextInstructionNumber = 0;
    private boolean allThrowingInstructionsHavePositions;
    public final boolean hasDebugPositions;
    public boolean hasConstString;
    public final boolean hasMonitorInstruction;
    public final InternalOptions options;
    public final Origin origin;

    public IRCode(InternalOptions options, DexEncodedMethod method, LinkedList<BasicBlock> blocks, ValueNumberGenerator valueNumberGenerator, boolean hasDebugPositions, boolean hasMonitorInstruction, boolean hasConstString, Origin origin) {
        assert (options != null);
        this.options = options;
        this.method = method;
        this.blocks = blocks;
        this.valueNumberGenerator = valueNumberGenerator;
        this.hasDebugPositions = hasDebugPositions;
        this.hasMonitorInstruction = hasMonitorInstruction;
        this.hasConstString = hasConstString;
        this.origin = origin;
        this.allThrowingInstructionsHavePositions = this.computeAllThrowingInstructionsHavePositions();
    }

    public void copyMetadataFromInlinee(IRCode inlinee) {
        assert (!inlinee.hasMonitorInstruction);
        this.hasConstString |= inlinee.hasConstString;
    }

    public BasicBlock entryBlock() {
        return this.blocks.getFirst();
    }

    public Map<BasicBlock, LiveAtEntrySets> computeLiveAtEntrySets() {
        IdentityHashMap<BasicBlock, LiveAtEntrySets> liveAtEntrySets = new IdentityHashMap<BasicBlock, LiveAtEntrySets>();
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        ImmutableList<BasicBlock> sorted2 = this.topologicallySortedBlocks();
        worklist.addAll(sorted2.reverse());
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            HashSet<Value> live = new HashSet<Value>();
            HashSet<Value> liveLocals = new HashSet<Value>();
            ArrayDeque<Value> liveStack = new ArrayDeque<Value>();
            Set<BasicBlock> exceptionalSuccessors = block.getCatchHandlers().getUniqueTargets();
            for (BasicBlock succ : block.getSuccessors()) {
                LiveAtEntrySets liveAtSucc = (LiveAtEntrySets)liveAtEntrySets.get(succ);
                if (liveAtSucc != null) {
                    live.addAll(liveAtSucc.liveValues);
                    liveLocals.addAll(liveAtSucc.liveLocalValues);
                    if (exceptionalSuccessors.contains(succ)) {
                        assert (liveAtSucc.liveStackValues.size() == 0);
                    } else {
                        assert (liveStack.isEmpty());
                        liveStack = new ArrayDeque<Value>(liveAtSucc.liveStackValues);
                    }
                }
                int predIndex = succ.getPredecessors().indexOf(block);
                for (Phi phi : succ.getPhis()) {
                    Value operand = phi.getOperand(predIndex);
                    if (operand.isValueOnStack()) {
                        liveStack.addLast(operand);
                        continue;
                    }
                    live.add(operand);
                    if (!phi.hasLocalInfo()) continue;
                    assert (phi.getLocalInfo() == operand.getLocalInfo());
                    liveLocals.add(operand);
                }
            }
            assert (liveStack.isEmpty() || block.getSuccessors().size() - exceptionalSuccessors.size() == 1);
            Iterator<Instruction> iterator2 = block.getInstructions().descendingIterator();
            while (iterator2.hasNext()) {
                Instruction instruction = iterator2.next();
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    if (outValue instanceof StackValue) {
                        Value pop = (Value)liveStack.removeLast();
                        assert (pop == outValue);
                    } else if (outValue instanceof StackValues) {
                        StackValue[] values2 = ((StackValues)outValue).getStackValues();
                        for (int i = values2.length - 1; i >= 0; --i) {
                            Value pop = (Value)liveStack.removeLast();
                            assert (pop == values2[i]);
                        }
                    } else {
                        live.remove(outValue);
                        assert (outValue.hasLocalInfo() || !liveLocals.contains(outValue));
                        if (outValue.hasLocalInfo()) {
                            liveLocals.remove(outValue);
                        }
                    }
                }
                for (Value use2 : instruction.inValues()) {
                    if (use2.needsRegister()) {
                        live.add(use2);
                        continue;
                    }
                    if (!use2.isValueOnStack()) continue;
                    liveStack.addLast(use2);
                }
                assert (instruction.getDebugValues().stream().allMatch(Value::needsRegister));
                assert (instruction.getDebugValues().stream().allMatch(Value::hasLocalInfo));
                live.addAll(instruction.getDebugValues());
                liveLocals.addAll(instruction.getDebugValues());
            }
            for (Phi phi : block.getPhis()) {
                if (phi.isValueOnStack()) {
                    liveStack.remove(phi);
                } else {
                    live.remove(phi);
                }
                assert (phi.hasLocalInfo() || !liveLocals.contains(phi));
                if (!phi.hasLocalInfo()) continue;
                liveLocals.remove(phi);
            }
            LiveAtEntrySets liveAtEntry = new LiveAtEntrySets(live, liveLocals, liveStack);
            LiveAtEntrySets previousLiveAtEntry = liveAtEntrySets.put(block, liveAtEntry);
            if (previousLiveAtEntry != null && previousLiveAtEntry.equals(liveAtEntry)) continue;
            for (BasicBlock pred : block.getPredecessors()) {
                if (worklist.contains(pred)) continue;
                worklist.add(pred);
            }
        }
        assert (((LiveAtEntrySets)liveAtEntrySets.get(sorted2.get(0))).isEmpty()) : "Unexpected values live at entry to first block: " + ((LiveAtEntrySets)liveAtEntrySets.get(sorted2.get((int)0))).liveValues;
        return liveAtEntrySets;
    }

    public void splitCriticalEdges() {
        ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
        int nextBlockNumber = this.getHighestBlockNumber() + 1;
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getMutablePredecessors();
            if (predecessors.size() <= 1) continue;
            assert (!block.entry().isMoveException());
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                BasicBlock pred = predecessors.get(predIndex);
                if (pred.hasOneNormalExit()) continue;
                BasicBlock newBlock = BasicBlock.createGotoBlock(nextBlockNumber++, pred.exit().getPosition(), block);
                newBlocks.add(newBlock);
                pred.replaceSuccessor(block, newBlock);
                newBlock.getMutablePredecessors().add(pred);
                predecessors.set(predIndex, newBlock);
            }
        }
        this.blocks.addAll(newBlocks);
    }

    public boolean verifySplitCriticalEdges() {
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() > 1) {
                for (BasicBlock predecessor : predecessors) {
                    assert (predecessor.hasOneNormalExit());
                    assert (predecessor.getSuccessors().get(0) == block);
                }
            }
            if (!block.hasCatchHandlers()) continue;
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                assert (handler.getPredecessors().size() == 1);
                assert (handler.getPredecessors().get(0) == block);
            }
        }
        return true;
    }

    public void traceBlocks() {
        ImmutableList<BasicBlock> sorted2 = this.topologicallySortedBlocks();
        int color = this.reserveMarkingColor();
        int nextBlockNumber = this.blocks.size();
        LinkedList<BasicBlock> tracedBlocks = new LinkedList<BasicBlock>();
        for (BasicBlock block : sorted2) {
            if (block.isMarked(color)) continue;
            block.mark(color);
            tracedBlocks.add(block);
            BasicBlock current = block;
            BasicBlock fallthrough = block.exit().fallthroughBlock();
            while (fallthrough != null && !fallthrough.isMarked(color)) {
                fallthrough.mark(color);
                tracedBlocks.add(fallthrough);
                current = fallthrough;
                fallthrough = fallthrough.exit().fallthroughBlock();
            }
            if (fallthrough == null) continue;
            BasicBlock newFallthrough = BasicBlock.createGotoBlock(nextBlockNumber++, current.exit().getPosition(), fallthrough);
            current.exit().setFallthroughBlock(newFallthrough);
            newFallthrough.getMutablePredecessors().add(current);
            fallthrough.replacePredecessor(current, newFallthrough);
            newFallthrough.mark(color);
            tracedBlocks.add(newFallthrough);
        }
        this.blocks = tracedBlocks;
        this.returnMarkingColor(color);
        assert (this.noColorsInUse());
    }

    private void ensureBlockNumbering() {
        if (!this.numbered) {
            this.numbered = true;
            int blockNumber = 0;
            for (BasicBlock block : this.topologicallySortedBlocks()) {
                block.setNumber(blockNumber++);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public void clearMarks(int color) {
        for (BasicBlock block : this.blocks) {
            block.clearMark(color);
        }
    }

    public void removeMarkedBlocks(int color) {
        ListIterator<BasicBlock> blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!block.isMarked(color)) continue;
            blockIterator.remove();
        }
    }

    public boolean verifyNoBlocksMarked(int color) {
        for (BasicBlock block : this.blocks) {
            assert (!block.isMarked(color));
        }
        return true;
    }

    public void removeBlocks(Collection<BasicBlock> blocksToRemove) {
        this.blocks.removeAll(blocksToRemove);
    }

    public ImmutableList<BasicBlock> topologicallySortedBlocks() {
        ImmutableList<BasicBlock> ordered = this.depthFirstSorting();
        return this.options.testing.placeExceptionalBlocksLast ? IRCode.reorderExceptionalBlocksLastForTesting(ordered) : ordered;
    }

    private ImmutableList<BasicBlock> depthFirstSorting() {
        ArrayList<BasicBlock> reverseOrdered = new ArrayList<BasicBlock>(this.blocks.size());
        HashSet<BasicBlock> visitedBlocks = new HashSet<BasicBlock>(this.blocks.size());
        ArrayDeque<Object> worklist = new ArrayDeque<Object>(this.blocks.size());
        worklist.addLast(this.entryBlock());
        while (!worklist.isEmpty()) {
            Object item = worklist.removeLast();
            if (item instanceof BlockMarker) {
                reverseOrdered.add(((BlockMarker)item).block);
                continue;
            }
            BasicBlock block = (BasicBlock)item;
            if (visitedBlocks.contains(block)) continue;
            visitedBlocks.add(block);
            worklist.addLast(new BlockMarker(block));
            for (int i = block.getSuccessors().size() - 1; i >= 0; --i) {
                worklist.addLast(block.getSuccessors().get(i));
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = reverseOrdered.size() - 1; i >= 0; --i) {
            builder.add((BasicBlock)reverseOrdered.get(i));
        }
        return builder.build();
    }

    private static ImmutableList<BasicBlock> reorderExceptionalBlocksLastForTesting(ImmutableList<BasicBlock> blocks) {
        ImmutableList.Builder reordered = ImmutableList.builder();
        for (BasicBlock block : blocks) {
            if (block.entry().isMoveException()) continue;
            reordered.add(block);
        }
        for (BasicBlock block : blocks) {
            if (!block.entry().isMoveException()) continue;
            reordered.add(block);
        }
        return reordered.build();
    }

    public void print(CfgPrinter printer) {
        this.ensureBlockNumbering();
        for (BasicBlock block : this.blocks) {
            block.print(printer);
        }
    }

    public boolean isConsistentSSA() {
        assert (this.isConsistentGraph());
        assert (this.consistentDefUseChains());
        assert (this.validThrowingInstructions());
        assert (this.noCriticalEdges());
        assert (this.verifyNoImpreciseOrBottomTypes());
        return true;
    }

    public boolean isConsistentGraph() {
        assert (this.noColorsInUse());
        assert (this.consistentBlockNumbering());
        assert (this.consistentPredecessorSuccessors());
        assert (this.consistentCatchHandlers());
        assert (this.consistentBlockInstructions());
        assert (!this.allThrowingInstructionsHavePositions || this.computeAllThrowingInstructionsHavePositions());
        return true;
    }

    public boolean verifyTypes(AppInfo appInfo, AppView<? extends AppInfo> appView, GraphLense graphLense) {
        if (appView != null && appView.enableWholeProgramOptimizations()) assert (new TypeChecker(appView).check(this));
        assert (this.blocks.stream().allMatch(block -> block.verifyTypes(appInfo, graphLense)));
        return true;
    }

    private boolean noCriticalEdges() {
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() <= 1) continue;
            if (block.entry() instanceof MoveException) {
                assert (false);
                return false;
            }
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                if (predecessors.get(predIndex).hasOneNormalExit()) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    public boolean hasCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            return true;
        }
        return false;
    }

    private boolean consistentDefUseChains() {
        HashSet<Value> values2 = new HashSet<Value>();
        for (BasicBlock block : this.blocks) {
            int predecessorCount = block.getPredecessors().size();
            for (Phi phi : block.getPhis()) {
                assert (!phi.isTrivialPhi());
                assert (phi.getOperands().size() == predecessorCount);
                values2.add(phi);
                for (Value value : phi.getOperands()) {
                    values2.add(value);
                    assert (value.uniquePhiUsers().contains(phi));
                    assert (!phi.hasLocalInfo() || phi.getLocalInfo() == value.getLocalInfo());
                }
            }
            for (Instruction instruction : block.getInstructions()) {
                assert (instruction.getBlock() == block);
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    values2.add(outValue);
                    assert (outValue.definition == instruction);
                }
                for (Value value : instruction.inValues()) {
                    values2.add(value);
                    assert (value.uniqueUsers().contains(instruction));
                }
                for (Value value : instruction.getDebugValues()) {
                    values2.add(value);
                    assert (value.debugUsers().contains(instruction));
                }
            }
        }
        for (Value value : values2) {
            assert (this.verifyValue(value));
            assert (this.consistentValueUses(value));
        }
        return true;
    }

    private boolean verifyValue(Value value) {
        assert (!value.isPhi() ? this.verifyDefinition(value) : this.verifyPhi(value.asPhi()));
        return true;
    }

    private boolean verifyPhi(Phi phi) {
        assert (phi.getBlock().getPhis().contains(phi));
        return true;
    }

    private boolean verifyDefinition(Value value) {
        Value outValue = value.definition.outValue();
        assert (outValue == value || value instanceof StackValue && Arrays.asList(((StackValues)outValue).getStackValues()).contains(value));
        return true;
    }

    private boolean consistentValueUses(Value value) {
        for (Instruction user : value.uniqueUsers()) {
            assert (user.inValues().contains(value));
        }
        for (Phi phiUser : value.uniquePhiUsers()) {
            assert (phiUser.getOperands().contains(value));
            assert (phiUser.getBlock().getPhis().contains(phiUser));
        }
        if (value.hasLocalInfo()) {
            for (Instruction debugUser : value.debugUsers()) {
                assert (debugUser.getDebugValues().contains(value));
            }
        }
        return true;
    }

    private boolean consistentPredecessorSuccessors() {
        for (BasicBlock block : this.blocks) {
            assert (new HashSet<BasicBlock>(block.getSuccessors()).size() == block.getSuccessors().size());
            for (BasicBlock succ : block.getSuccessors()) {
                assert (this.blocks.contains(succ));
                assert (succ.getPredecessors().contains(block));
            }
            assert (new HashSet<BasicBlock>(block.getPredecessors()).size() == block.getPredecessors().size());
            for (BasicBlock pred : block.getPredecessors()) {
                assert (this.blocks.contains(pred));
                assert (pred.getSuccessors().contains(block));
            }
        }
        return true;
    }

    private boolean consistentCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            assert (block.consistentCatchHandlers());
        }
        return true;
    }

    public boolean consistentBlockNumbering() {
        this.blocks.stream().collect(Collectors.groupingBy(BasicBlock::getNumber, Collectors.counting())).forEach((key, value) -> {
            assert (value == 1L);
        });
        return true;
    }

    private boolean consistentBlockInstructions() {
        boolean argumentsAllowed = true;
        for (BasicBlock block : this.blocks) {
            block.consistentBlockInstructions(argumentsAllowed, this.options.debug || this.method.getOptimizationInfo().isReachabilitySensitive());
            argumentsAllowed = false;
        }
        return true;
    }

    private boolean validThrowingInstructions() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                assert (handler.getPredecessors().size() == 1);
            }
            boolean seenThrowing = false;
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.instructionTypeCanThrow()) {
                    assert (!seenThrowing);
                    seenThrowing = true;
                    continue;
                }
                if (seenThrowing) assert (instruction.isDebugInstruction() || instruction.isGoto());
            }
        }
        return true;
    }

    public boolean verifyNoImpreciseOrBottomTypes() {
        Predicate<Value> verifyValue = v -> {
            assert (!v.isNeverNull() || v.getTypeLattice().isReference() && v.getTypeLattice().nullability().isDefinitelyNotNull());
            assert (v.getTypeLattice().isPreciseType());
            assert (!v.getTypeLattice().isFineGrainedType());
            assert (!v.getTypeLattice().isBottom());
            assert (!(v.definition instanceof ImpreciseMemberTypeInstruction) || ((ImpreciseMemberTypeInstruction)((Object)v.definition)).getMemberType().isPrecise());
            return true;
        };
        return this.verifySSATypeLattice(v -> {
            if (v instanceof StackValues) {
                return Stream.of(((StackValues)v).getStackValues()).allMatch(verifyValue);
            }
            return this.verifyValue((Value)v);
        });
    }

    private boolean verifySSATypeLattice(Predicate<Value> tester) {
        for (BasicBlock block : this.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                Value outValue = instruction.outValue();
                if (outValue != null) assert (tester.test(outValue));
            }
            for (Phi phi : block.getPhis()) {
                assert (tester.test(phi));
            }
        }
        return true;
    }

    public Iterable<Instruction> instructions() {
        return this::instructionIterator;
    }

    public InstructionIterator instructionIterator() {
        return new IRCodeInstructionsIterator(this);
    }

    public List<BasicBlock> computeNormalExitBlocks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BasicBlock block : this.blocks) {
            if (!block.exit().isReturn()) continue;
            builder.add(block);
        }
        return builder.build();
    }

    public ListIterator<BasicBlock> listIterator() {
        return new BasicBlockIterator(this);
    }

    public ListIterator<BasicBlock> listIterator(int index) {
        return new BasicBlockIterator(this, index);
    }

    public ImmutableList<BasicBlock> numberInstructions() {
        ImmutableList<BasicBlock> blocks = this.topologicallySortedBlocks();
        for (BasicBlock block : blocks) {
            this.nextInstructionNumber = block.numberInstructions(this.nextInstructionNumber);
        }
        return blocks;
    }

    public int numberRemainingInstructions() {
        InstructionIterator it = this.instructionIterator();
        while (it.hasNext()) {
            Instruction i = (Instruction)it.next();
            if (i.getNumber() != -1) continue;
            i.setNumber(this.nextInstructionNumber);
            this.nextInstructionNumber += 2;
        }
        return this.nextInstructionNumber;
    }

    public int getNextInstructionNumber() {
        return this.nextInstructionNumber;
    }

    public List<Value> collectArguments() {
        return this.collectArguments(false);
    }

    public List<Value> collectArguments(boolean ignoreReceiver) {
        ArrayList<Value> arguments = new ArrayList<Value>();
        InstructionIterator iterator2 = this.entryBlock().iterator();
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isArgument()) continue;
            Value out = instruction.asArgument().outValue();
            if (ignoreReceiver && out.isThis()) continue;
            arguments.add(out);
        }
        assert (arguments.size() == this.method.method.getArity() + (this.method.accessFlags.isStatic() || ignoreReceiver ? 0 : 1));
        return arguments;
    }

    public Value getThis() {
        if (this.method.accessFlags.isStatic()) {
            return null;
        }
        Instruction firstArg = this.entryBlock().listIterator().nextUntil(Instruction::isArgument);
        assert (firstArg != null);
        Value thisValue = firstArg.asArgument().outValue();
        assert (thisValue.isThis());
        return thisValue;
    }

    public Value createValue(TypeLatticeElement typeLattice, DebugLocalInfo local) {
        return new Value(this.valueNumberGenerator.next(), typeLattice, local);
    }

    public Value createValue(TypeLatticeElement typeLattice) {
        return this.createValue(typeLattice, null);
    }

    public Value createValue(DebugLocalInfo local) {
        return this.createValue(TypeLatticeElement.BOTTOM, local);
    }

    public ConstNumber createIntConstant(int value) {
        Value out = this.createValue(TypeLatticeElement.INT);
        return new ConstNumber(out, value);
    }

    public final int getHighestBlockNumber() {
        return this.blocks.stream().max(Comparator.comparingInt(BasicBlock::getNumber)).get().getNumber();
    }

    public ConstNumber createConstNull() {
        Value out = this.createValue(TypeLatticeElement.NULL);
        return new ConstNumber(out, 0L);
    }

    public ConstNumber createConstNull(DebugLocalInfo local) {
        Value out = this.createValue(TypeLatticeElement.NULL, local);
        return new ConstNumber(out, 0L);
    }

    public boolean doAllThrowingInstructionsHavePositions() {
        return this.allThrowingInstructionsHavePositions;
    }

    public void setAllThrowingInstructionsHavePositions(boolean value) {
        this.allThrowingInstructionsHavePositions = value;
    }

    private boolean computeAllThrowingInstructionsHavePositions() {
        InstructionIterator it = this.instructionIterator();
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.instructionTypeCanThrow() || instruction.isConstString() || instruction.isDexItemBasedConstString() || !instruction.getPosition().isNone()) continue;
            return false;
        }
        return true;
    }

    public void removeAllTrivialPhis() {
        this.removeAllTrivialPhis(null);
    }

    public void removeAllTrivialPhis(IRBuilder builder) {
        for (BasicBlock block : this.blocks) {
            ArrayList<Phi> phis = new ArrayList<Phi>(block.getPhis());
            for (Phi phi : phis) {
                phi.removeTrivialPhi(builder);
            }
        }
    }

    public int reserveMarkingColor() {
        int color;
        assert (this.anyMarkingColorAvailable());
        for (color = 1; (this.usedMarkingColors & color) == color; color <<= 1) {
            assert (color <= 0x40000000);
        }
        this.usedMarkingColors |= color;
        assert (this.isMarkingColorInUse(color));
        assert (this.verifyNoBlocksMarked(color));
        return color;
    }

    public boolean anyMarkingColorAvailable() {
        for (int color = 1; (this.usedMarkingColors & color) == color; color <<= 1) {
            if (color <= 0x40000000) continue;
            return false;
        }
        return true;
    }

    public void returnMarkingColor(int color) {
        assert (this.isMarkingColorInUse(color));
        this.clearMarks(color);
        this.usedMarkingColors &= ~color;
    }

    public boolean isMarkingColorInUse(int color) {
        return (this.usedMarkingColors & color) != 0;
    }

    public boolean anyBlocksMarkedWithColor(int color) {
        for (BasicBlock block : this.blocks) {
            if (!block.isMarked(color)) continue;
            return true;
        }
        return false;
    }

    public boolean noColorsInUse() {
        return this.usedMarkingColors == 0;
    }

    public Set<BasicBlock> getUnreachableBlocks() {
        Set<BasicBlock> unreachableBlocks = Sets.newIdentityHashSet();
        int color = this.reserveMarkingColor();
        this.markTransitiveSuccessors(this.entryBlock(), color);
        for (BasicBlock block : this.blocks) {
            if (block.isMarked(color)) continue;
            unreachableBlocks.add(block);
        }
        this.returnMarkingColor(color);
        return unreachableBlocks;
    }

    public Set<Value> removeUnreachableBlocks() {
        ImmutableSet.Builder affectedValueBuilder = ImmutableSet.builder();
        int color = this.reserveMarkingColor();
        this.markTransitiveSuccessors(this.entryBlock(), color);
        ListIterator<BasicBlock> blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock current = blockIterator.next();
            if (current.isMarked(color)) continue;
            affectedValueBuilder.addAll(current.cleanForRemoval());
            blockIterator.remove();
        }
        this.returnMarkingColor(color);
        return affectedValueBuilder.build();
    }

    private void markTransitiveSuccessors(BasicBlock subject, int color) {
        assert (this.isMarkingColorInUse(color) && !this.anyBlocksMarkedWithColor(color));
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            if (block.isMarked(color)) continue;
            block.mark(color);
            for (BasicBlock successor : block.getSuccessors()) {
                if (successor.isMarked(color)) continue;
                worklist.add(successor);
            }
        }
    }

    public void markTransitivePredecessors(BasicBlock subject, int color) {
        assert (this.isMarkingColorInUse(color) && !this.anyBlocksMarkedWithColor(color));
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            if (block.isMarked(color)) continue;
            block.mark(color);
            for (BasicBlock predecessor : block.getPredecessors()) {
                if (predecessor.isMarked(color)) continue;
                worklist.add(predecessor);
            }
        }
    }

    private static class BlockMarker {
        final BasicBlock block;

        BlockMarker(BasicBlock block) {
            this.block = block;
        }
    }

    public static class LiveAtEntrySets {
        public final Set<Value> liveValues;
        public final Set<Value> liveLocalValues;
        public final Deque<Value> liveStackValues;

        public LiveAtEntrySets(Set<Value> liveValues, Set<Value> liveLocalValues, Deque<Value> liveStackValues) {
            assert (liveValues.containsAll(liveLocalValues));
            this.liveValues = liveValues;
            this.liveLocalValues = liveLocalValues;
            this.liveStackValues = liveStackValues;
        }

        public int hashCode() {
            throw new Unreachable();
        }

        public boolean equals(Object o) {
            LiveAtEntrySets other = (LiveAtEntrySets)o;
            return this.liveValues.equals(other.liveValues) && this.liveLocalValues.equals(other.liveLocalValues);
        }

        public boolean isEmpty() {
            return this.liveValues.isEmpty() && this.liveLocalValues.isEmpty();
        }
    }
}

