/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeVirtualRange;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;
import java.util.List;

public class InvokeVirtual
extends InvokeMethodWithReceiver {
    public InvokeVirtual(DexMethod target, Value result, List<Value> arguments) {
        super(target, result, arguments);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.VIRTUAL;
    }

    @Override
    protected String getTypeString() {
        return "Virtual";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeVirtualRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeVirtual(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeVirtual() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeVirtual() {
        return true;
    }

    @Override
    public InvokeVirtual asInvokeVirtual() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(Enqueuer.AppInfoWithLiveness appInfo, DexType invocationContext) {
        DexType refinedReceiverType = TypeAnalysis.getRefinedReceiverType(appInfo, this);
        DexMethod method = this.getInvokedMethod();
        return appInfo.lookupSingleVirtualTarget(method, refinedReceiverType);
    }

    @Override
    public Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping appInfo, DexType invocationContext) {
        return appInfo.lookupVirtualTargets(this.getInvokedMethod());
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeVirtual(this.getInvokedMethod(), invocationContext);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(182, this.getInvokedMethod(), false));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, AppView<? extends AppInfoWithSubtyping> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeVirtual(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<? extends AppInfo> appView, DexType context) {
        if (appView == null || !appView.enableWholeProgramOptimizations()) {
            return true;
        }
        if (appView.options().debug) {
            return true;
        }
        Value receiver = this.getReceiver();
        if (receiver.getTypeLattice().nullability().isNullable()) {
            return true;
        }
        return !appView.dexItemFactory().classMethods.isReflectiveNameLookup(this.getInvokedMethod());
    }

    @Override
    public boolean canBeDeadCode(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, AppInfo appInfo, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }
}

