/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.code.Format21c;
import com.android.tools.r8.code.Sget;
import com.android.tools.r8.code.SgetBoolean;
import com.android.tools.r8.code.SgetByte;
import com.android.tools.r8.code.SgetChar;
import com.android.tools.r8.code.SgetObject;
import com.android.tools.r8.code.SgetShort;
import com.android.tools.r8.code.SgetWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.shaking.Enqueuer;

public class StaticGet
extends FieldInstruction {
    public StaticGet(Value dest, DexField field) {
        super(field, dest, (Value)null);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public boolean couldIntroduceAnAlias() {
        return true;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format21c instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Sget(dest, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new SgetWide(dest, field);
                break;
            }
            case OBJECT: {
                instruction = new SgetObject(dest, field);
                break;
            }
            case BOOLEAN: {
                instruction = new SgetBoolean(dest, field);
                break;
            }
            case BYTE: {
                instruction = new SgetByte(dest, field);
                break;
            }
            case CHAR: {
                instruction = new SgetChar(dest, field);
                break;
            }
            case SHORT: {
                instruction = new SgetShort(dest, field);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.getType()));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean canBeDeadCode(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, AppInfo appInfo, IRCode code) {
        if (appView == null || !appView.enableWholeProgramOptimizations()) {
            return false;
        }
        DexEncodedField resolvedField = appInfo.resolveFieldOn(this.getField().getHolder(), this.getField());
        if (resolvedField == null) {
            return false;
        }
        if (!MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appInfo, code.method.method.getHolder(), resolvedField.field.clazz, resolvedField.accessFlags)) {
            return false;
        }
        DexType context = code.method.method.holder;
        return !this.getField().clazz.classInitializationMayHaveSideEffects(appInfo, type -> context.isSubtypeOf((DexType)type, appInfo));
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isStaticGet()) {
            return false;
        }
        StaticGet o = other.asStaticGet();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forStaticGet(this.getField(), invocationContext);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public boolean isStaticGet() {
        return true;
    }

    @Override
    public StaticGet asStaticGet() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(178, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.getField().type;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(this.getField().type, Nullability.maybeNull(), appInfo);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, AppView<? extends AppInfoWithSubtyping> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forStaticGet(this, clazz, appView, mode, assumption);
    }
}

