/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NonNull;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Devirtualizer {
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;

    public Devirtualizer(AppView<? extends Enqueuer.AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public void devirtualizeInvokeInterface(IRCode code, DexType invocationContext) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        IdentityHashMap<InvokeInterface, InvokeVirtual> devirtualizedCall = new IdentityHashMap<InvokeInterface, InvokeVirtual>();
        DominatorTree dominatorTree = new DominatorTree(code);
        IdentityHashMap castedReceiverCache = new IdentityHashMap();
        Set<CheckCast> newCheckCastInstructions = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                TypeLatticeElement castTypeLattice;
                Value receiver;
                TypeLatticeElement receiverTypeLattice;
                Inliner.ConstraintWithTarget visibility;
                InvokeInterface invoke;
                DexEncodedMethod target;
                NonNull nonNull;
                Instruction origin;
                Instruction current = (Instruction)it.next();
                if (current.isNonNull() && (origin = (nonNull = current.asNonNull()).origin()).isInvokeInterface() && !origin.asInvokeInterface().getReceiver().hasLocalInfo() && devirtualizedCall.containsKey(origin.asInvokeInterface()) && origin.asInvokeInterface().getReceiver() == nonNull.getAliasForOutValue()) {
                    CheckCast definition;
                    InvokeVirtual devirtualizedInvoke = (InvokeVirtual)devirtualizedCall.get(origin.asInvokeInterface());
                    CheckCast newCheckCast = null;
                    Value newReceiver = devirtualizedInvoke.getReceiver();
                    if (!newReceiver.isPhi() && newReceiver.definition.isCheckCast() && newCheckCastInstructions.contains(definition = newReceiver.definition.asCheckCast())) {
                        newCheckCast = definition;
                    }
                    if (newCheckCast != null) {
                        Value oldReceiver = newCheckCast.object();
                        TypeLatticeElement oldReceiverType = oldReceiver.getTypeLattice();
                        TypeLatticeElement newReceiverType = newReceiver.getTypeLattice();
                        if (newReceiverType.lessThanOrEqual(oldReceiverType, this.appView.appInfo()) && dominatorTree.dominatedBy(block, devirtualizedInvoke.getBlock())) {
                            assert (nonNull.src() == oldReceiver);
                            assert (!oldReceiver.hasLocalInfo());
                            oldReceiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(nonNull), ImmutableMap.of());
                        }
                    }
                }
                if (!current.isInvokeInterface() || (target = (invoke = current.asInvokeInterface()).lookupSingleTarget(this.appView.appInfo(), invocationContext)) == null) continue;
                DexType holderType = target.method.getHolder();
                DexClass holderClass = this.appView.appInfo().definitionFor(holderType);
                if (holderClass == null || holderClass.isInterface() || (visibility = Inliner.ConstraintWithTarget.classIsVisible(invocationContext, holderType, this.appView.appInfo())) == Inliner.ConstraintWithTarget.NEVER) continue;
                InvokeVirtual devirtualizedInvoke = new InvokeVirtual(target.method, invoke.outValue(), invoke.inValues());
                it.replaceCurrentInstruction(devirtualizedInvoke);
                devirtualizedCall.put(invoke, devirtualizedInvoke);
                if (holderType == invoke.getInvokedMethod().getHolder() || (receiverTypeLattice = (receiver = invoke.getReceiver()).getTypeLattice()).lessThanOrEqual(castTypeLattice = TypeLatticeElement.fromDexType(holderType, receiverTypeLattice.nullability(), this.appView.appInfo()), this.appView.appInfo())) continue;
                Value newReceiver = null;
                if (castedReceiverCache.containsKey(receiver) && ((Map)castedReceiverCache.get(receiver)).containsKey(holderType)) {
                    Value cachedReceiver = (Value)((Map)castedReceiverCache.get(receiver)).get(holderType);
                    if (dominatorTree.dominatedBy(block, cachedReceiver.definition.getBlock())) {
                        newReceiver = cachedReceiver;
                    }
                }
                if (newReceiver == null) {
                    BasicBlock blockWithDevirtualizedInvoke;
                    newReceiver = code.createValue(castTypeLattice);
                    if (!receiver.hasLocalInfo()) {
                        castedReceiverCache.putIfAbsent(receiver, new IdentityHashMap());
                        ((Map)castedReceiverCache.get(receiver)).put(holderType, newReceiver);
                    }
                    CheckCast checkCast = new CheckCast(newReceiver, receiver, holderType);
                    checkCast.setPosition(invoke.getPosition());
                    newCheckCastInstructions.add(checkCast);
                    assert (it.peekPrevious() == devirtualizedInvoke);
                    it.previous();
                    BasicBlock basicBlock = blockWithDevirtualizedInvoke = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithDevirtualizedInvoke != block) {
                        it = block.listIterator(block.getInstructions().size());
                        it.previous();
                        it.add(checkCast);
                        dominatorTree = new DominatorTree(code);
                        it = blockWithDevirtualizedInvoke.listIterator();
                        assert (it.peekNext() == devirtualizedInvoke);
                        it.next();
                    } else {
                        it.add(checkCast);
                        assert (it.peekNext() == devirtualizedInvoke);
                        it.next();
                    }
                }
                affectedValues.addAll(receiver.affectedValues());
                if (!receiver.hasLocalInfo()) {
                    receiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(devirtualizedInvoke), ImmutableMap.of());
                    continue;
                }
                receiver.removeUser(devirtualizedInvoke);
                devirtualizedInvoke.replaceValue(receiver, newReceiver);
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView.appInfo(), code.method).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }
}

